/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.DynamicBundle;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.WithoutOwnBeforeRunSteps;
import com.intellij.execution.impl.BeforeRunStepsPanel;
import com.intellij.execution.impl.ConfigurationSettingsEditor;
import com.intellij.execution.impl.RunConfigurationCreator;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ConfigurationSettingsEditorWrapper
extends SettingsEditor<RunnerAndConfigurationSettings>
implements BeforeRunStepsPanel.StepsBeforeRunListener {
    public static final DataKey<ConfigurationSettingsEditorWrapper> CONFIGURATION_EDITOR_KEY = DataKey.create("ConfigurationSettingsEditor");
    @NonNls
    private static final String EXPAND_PROPERTY_KEY = "ExpandBeforeRunStepsPanel";
    private JPanel myComponentPlace;
    private JPanel myWholePanel;
    private JPanel myBeforeLaunchContainer;
    private JBCheckBox myIsAllowRunningInParallelCheckBox;
    private JPanel myDisclaimerPanel;
    private JLabel myDisclaimerLabel;
    private JLabel myCreateNewRCLabel;
    private final BeforeRunStepsPanel myBeforeRunStepsPanel;
    private final ConfigurationSettingsEditor myEditor;
    private final HideableDecorator myDecorator;

    public <T extends SettingsEditor> T selectExecutorAndGetEditor(ProgramRunner runner, Class<T> editorClass) {
        return this.myEditor.selectExecutorAndGetEditor(runner, editorClass);
    }

    public <T extends SettingsEditor> T selectTabAndGetEditor(Class<T> editorClass) {
        return this.myEditor.selectTabAndGetEditor(editorClass);
    }

    public ConfigurationSettingsEditorWrapper(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            ConfigurationSettingsEditorWrapper.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        this.myEditor = new ConfigurationSettingsEditor(settings);
        Disposer.register(this, this.myEditor);
        this.myBeforeRunStepsPanel = new BeforeRunStepsPanel(this);
        this.myDecorator = new HideableDecorator(this.myBeforeLaunchContainer, "", false){

            @Override
            protected void on() {
                super.on();
                this.storeState();
            }

            @Override
            protected void off() {
                super.off();
                this.storeState();
            }

            private void storeState() {
                PropertiesComponent.getInstance().setValue(ConfigurationSettingsEditorWrapper.EXPAND_PROPERTY_KEY, String.valueOf(this.isExpanded()));
            }
        };
        this.myDecorator.setOn(PropertiesComponent.getInstance().getBoolean(EXPAND_PROPERTY_KEY, true));
        this.myDecorator.setContentComponent(this.myBeforeRunStepsPanel);
        this.doReset(settings);
    }

    private void doReset(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            ConfigurationSettingsEditorWrapper.$$$reportNull$$$0(1);
        }
        this.myBeforeRunStepsPanel.doReset(settings);
        this.myBeforeLaunchContainer.setVisible(!(settings.getConfiguration() instanceof WithoutOwnBeforeRunSteps));
        this.myIsAllowRunningInParallelCheckBox.setSelected(settings.getConfiguration().isAllowRunningInParallel());
        this.myIsAllowRunningInParallelCheckBox.setVisible(settings.isTemplate() && settings.getFactory().getSingletonPolicy().isPolicyConfigurable());
        this.myDisclaimerPanel.setVisible(settings.isTemplate() && ProjectManager.getInstance().getOpenProjects().length != 0);
    }

    @Override
    @NotNull
    protected JComponent createEditor() {
        this.myComponentPlace.setLayout(new BorderLayout());
        this.myComponentPlace.add((Component)this.myEditor.getComponent(), "Center");
        DataManager.registerDataProvider(this.myWholePanel, dataId -> {
            if (CONFIGURATION_EDITOR_KEY.is(dataId)) {
                return this;
            }
            return null;
        });
        JPanel jPanel = this.myWholePanel;
        if (jPanel == null) {
            ConfigurationSettingsEditorWrapper.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @Override
    public void resetEditorFrom(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            ConfigurationSettingsEditorWrapper.$$$reportNull$$$0(3);
        }
        this.myEditor.resetEditorFrom(settings);
        this.doReset(settings);
    }

    @Override
    public void applyEditorTo(@NotNull RunnerAndConfigurationSettings settings) throws ConfigurationException {
        if (settings == null) {
            ConfigurationSettingsEditorWrapper.$$$reportNull$$$0(4);
        }
        this.myEditor.applyEditorTo(settings);
        this.doApply((RunnerAndConfigurationSettingsImpl)settings, false);
    }

    @Override
    @NotNull
    public RunnerAndConfigurationSettings getSnapshot() throws ConfigurationException {
        RunnerAndConfigurationSettings result2 = this.myEditor.getSnapshot();
        this.doApply((RunnerAndConfigurationSettingsImpl)result2, true);
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = result2;
        if (runnerAndConfigurationSettings == null) {
            ConfigurationSettingsEditorWrapper.$$$reportNull$$$0(5);
        }
        return runnerAndConfigurationSettings;
    }

    private void doApply(@NotNull RunnerAndConfigurationSettingsImpl settings, boolean isSnapshot) {
        if (settings == null) {
            ConfigurationSettingsEditorWrapper.$$$reportNull$$$0(6);
        }
        RunConfiguration runConfiguration = settings.getConfiguration();
        List<BeforeRunTask<?>> tasks = ContainerUtil.copyList(this.myBeforeRunStepsPanel.getTasks());
        RunnerAndConfigurationSettingsImpl settingsToApply = null;
        if (isSnapshot) {
            runConfiguration.setBeforeRunTasks(tasks);
        } else {
            RunManagerImpl runManager = settings.getManager();
            runManager.setBeforeRunTasks(runConfiguration, (List<? extends BeforeRunTask<?>>)tasks);
            settingsToApply = runManager.getSettings(runConfiguration);
        }
        if (settingsToApply == null) {
            settingsToApply = settings;
        }
        settingsToApply.setEditBeforeRun(this.myBeforeRunStepsPanel.needEditBeforeRun());
        settingsToApply.setActivateToolWindowBeforeRun(this.myBeforeRunStepsPanel.needActivateToolWindowBeforeRun());
        if (this.myIsAllowRunningInParallelCheckBox.isVisible()) {
            settings.getConfiguration().setAllowRunningInParallel(this.myIsAllowRunningInParallelCheckBox.isSelected());
        }
    }

    public void addBeforeLaunchStep(@NotNull BeforeRunTask<?> task2) {
        if (task2 == null) {
            ConfigurationSettingsEditorWrapper.$$$reportNull$$$0(7);
        }
        this.myBeforeRunStepsPanel.addTask(task2);
    }

    @NotNull
    public List<BeforeRunTask<?>> getStepsBeforeLaunch() {
        List<BeforeRunTask<?>> list2 = this.myBeforeRunStepsPanel.getTasks();
        if (list2 == null) {
            ConfigurationSettingsEditorWrapper.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @Override
    public void fireStepsBeforeRunChanged() {
        this.fireEditorStateChanged();
    }

    @Override
    public void titleChanged(@NotNull String title) {
        if (title == null) {
            ConfigurationSettingsEditorWrapper.$$$reportNull$$$0(9);
        }
        this.myDecorator.setTitle(title);
    }

    private void createUIComponents() {
        this.myDisclaimerLabel = new JLabel(ExecutionBundle.message("template.disclaimer", new Object[0]), AllIcons.General.Warning, 10);
        this.myDisclaimerLabel.setBorder(JBUI.Borders.emptyBottom(2));
        this.myCreateNewRCLabel = new LinkLabel(ExecutionBundle.message("create.configuration", new Object[0]), null, new LinkListener(){

            public void linkSelected(LinkLabel aSource, Object aLinkData) {
                RunConfigurationCreator creator = DataManager.getInstance().getDataContext(ConfigurationSettingsEditorWrapper.this.myDisclaimerLabel).getData(RunConfigurationCreator.KEY);
                if (creator != null) {
                    creator.createNewConfiguration(((RunnerAndConfigurationSettings)ConfigurationSettingsEditorWrapper.this.myEditor.getFactory().create()).getFactory());
                }
            }
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBCheckBox jBCheckBox;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.createUIComponents();
        this.myWholePanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 5, 0, 0), -1, -1, false, false));
        this.myComponentPlace = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myBeforeLaunchContainer = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel4.add((Component)jPanel2, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 0, 1, 0, new Dimension(-1, 10), new Dimension(-1, 10), new Dimension(-1, 10)));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myIsAllowRunningInParallelCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$(jBCheckBox, DynamicBundle.getBundle("messages/ExecutionBundle", ConfigurationSettingsEditorWrapper.class).getString("run.configuration.allow.running.parallel"));
        jPanel4.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 1, 4, 0, 3, 0, null, null, null));
        this.myDisclaimerPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), 5, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        JLabel jLabel = this.myDisclaimerLabel;
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle("messages/ExecutionBundle", ConfigurationSettingsEditorWrapper.class).getString("template.disclaimer"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 9, 0, 2, 0, null, null, null));
        JLabel jLabel2 = this.myCreateNewRCLabel;
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle("messages/ExecutionBundle", ConfigurationSettingsEditorWrapper.class).getString("create.configuration"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 1, 0, 0, 0, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel.add((Component)jSeparator, new GridConstraints(1, 1, 1, 2, 0, 1, 6, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/ConfigurationSettingsEditorWrapper";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/ConfigurationSettingsEditorWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSnapshot";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getStepsBeforeLaunch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doReset";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doApply";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addBeforeLaunchStep";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "titleChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

