/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.impl.RunConfigurable;
import com.intellij.execution.impl.RunDialogBase;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.project.Project;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.FlowLayout;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\fH\u0014J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014\u00a8\u0006\u0011"}, d2={"Lcom/intellij/execution/impl/ProjectRunConfigurationConfigurable;", "Lcom/intellij/execution/impl/RunConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "runDialog", "Lcom/intellij/execution/impl/RunDialogBase;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/impl/RunDialogBase;)V", "addRunConfigurationsToModel", "", "model", "Ljavax/swing/tree/DefaultMutableTreeNode;", "createLeftPanel", "Ljavax/swing/JComponent;", "createTipPanelAboutAddingNewRunConfiguration", "Ljavax/swing/JPanel;", "configurationType", "Lcom/intellij/execution/configurations/ConfigurationType;", "intellij.platform.execution.impl"})
public class ProjectRunConfigurationConfigurable
extends RunConfigurable {
    @Override
    @NotNull
    protected JComponent createLeftPanel() {
        if (this.getProject().isDefault()) {
            JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane(this.getTree());
            Intrinsics.checkExpressionValueIsNotNull((Object)jScrollPane, (String)"ScrollPaneFactory.createScrollPane(tree)");
            JScrollPane panel2 = jScrollPane;
            panel2.setBorder(IdeBorderFactory.createBorder(15));
            return panel2;
        }
        RunConfigurable.MyRemoveAction removeAction = new RunConfigurable.MyRemoveAction(this);
        String string = ExecutionBundle.message("move.up.action.name", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ExecutionBundle.message(\"move.up.action.name\")");
        Icon icon2 = IconUtil.getMoveUpIcon();
        Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"IconUtil.getMoveUpIcon()");
        RunConfigurable.MyMoveAction moveUpAction = new RunConfigurable.MyMoveAction(this, string, null, icon2, -1);
        String string2 = ExecutionBundle.message("move.down.action.name", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ExecutionBundle.message(\"move.down.action.name\")");
        Icon icon3 = IconUtil.getMoveDownIcon();
        Intrinsics.checkExpressionValueIsNotNull((Object)icon3, (String)"IconUtil.getMoveDownIcon()");
        RunConfigurable.MyMoveAction moveDownAction = new RunConfigurable.MyMoveAction(this, string2, null, icon3, 1);
        this.setToolbarDecorator(ToolbarDecorator.createDecorator(this.getTree()).setToolbarPosition(ActionToolbarPosition.TOP).setPanelBorder(JBUI.Borders.empty()).setAddAction(this.getToolbarAddAction()).setAddActionName(ExecutionBundle.message("add.new.run.configuration.action2.name", new Object[0])).setRemoveAction(removeAction).setRemoveActionUpdater(removeAction).setRemoveActionName(ExecutionBundle.message("remove.run.configuration.action.name", new Object[0])).setMoveUpAction(moveUpAction).setMoveUpActionName(ExecutionBundle.message("move.up.action.name", new Object[0])).setMoveUpActionUpdater(moveUpAction).setMoveDownAction(moveDownAction).setMoveDownActionName(ExecutionBundle.message("move.down.action.name", new Object[0])).setMoveDownActionUpdater(moveDownAction).addExtraAction(AnActionButton.fromAction(new RunConfigurable.MyCopyAction(this))).addExtraAction(AnActionButton.fromAction(new RunConfigurable.MySaveAction(this))).addExtraAction(AnActionButton.fromAction(new RunConfigurable.MyEditTemplatesAction(this))).addExtraAction(AnActionButton.fromAction(new RunConfigurable.MyCreateFolderAction(this))).addExtraAction(AnActionButton.fromAction(new RunConfigurable.MySortFolderAction(this))).setMinimumSize(new JBDimension(200, 200)).setButtonComparator(ExecutionBundle.message("add.new.run.configuration.action2.name", new Object[0]), ExecutionBundle.message("remove.run.configuration.action.name", new Object[0]), ExecutionBundle.message("copy.configuration.action.name", new Object[0]), ExecutionBundle.message("action.name.save.configuration", new Object[0]), ExecutionBundle.message("run.configuration.edit.default.configuration.settings.text", new Object[0]), ExecutionBundle.message("move.up.action.name", new Object[0]), ExecutionBundle.message("move.down.action.name", new Object[0]), ExecutionBundle.message("run.configuration.create.folder.text", new Object[0])).setForcedDnD());
        ToolbarDecorator toolbarDecorator = this.getToolbarDecorator();
        if (toolbarDecorator == null) {
            Intrinsics.throwNpe();
        }
        JPanel panel3 = toolbarDecorator.createPanel();
        this.initTree();
        JPanel jPanel = panel3;
        Intrinsics.checkExpressionValueIsNotNull((Object)jPanel, (String)"panel");
        return jPanel;
    }

    @Override
    @NotNull
    protected JPanel createTipPanelAboutAddingNewRunConfiguration(@Nullable ConfigurationType configurationType) {
        JPanel messagePanel = new JPanel(new FlowLayout(0, 0, 0));
        messagePanel.setBorder(JBUI.Borders.empty(30, 0, 0, 0));
        messagePanel.add(new JLabel("Click the"));
        ActionLink addIcon = new ActionLink("", IconUtil.getAddIcon(), this.getToolbarAddAction());
        addIcon.setBorder(JBUI.Borders.empty(0, 3, 0, 3));
        messagePanel.add(addIcon);
        String configurationTypeDescription = configurationType != null ? configurationType.getConfigurationTypeDescription() : ExecutionBundle.message("run.configuration.default.type.description", new Object[0]);
        messagePanel.add(new JLabel(ExecutionBundle.message("empty.run.configuration.panel.text.label3", configurationTypeDescription)));
        return messagePanel;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void addRunConfigurationsToModel(@NotNull DefaultMutableTreeNode model) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Object object = this.getRunManager().getConfigurationsGroupedByTypeAndFolder(true);
        boolean bl = false;
        Iterator<Map.Entry<ConfigurationType, Map<String, List<RunnerAndConfigurationSettings>>>> iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            void type;
            Map.Entry<ConfigurationType, Map<String, List<RunnerAndConfigurationSettings>>> entry;
            Map.Entry<ConfigurationType, Map<String, List<RunnerAndConfigurationSettings>>> entry2 = entry = iterator2.next();
            boolean bl2 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            Map<String, List<RunnerAndConfigurationSettings>> folderMap = entry2.getValue();
            DefaultMutableTreeNode typeNode = new DefaultMutableTreeNode(type);
            model.add(typeNode);
            Iterator<Map.Entry<String, List<RunnerAndConfigurationSettings>>> iterator3 = folderMap.entrySet().iterator();
            while (iterator3.hasNext()) {
                void folder;
                Map.Entry<String, List<RunnerAndConfigurationSettings>> entry3;
                Map.Entry<String, List<RunnerAndConfigurationSettings>> entry4 = entry3 = iterator3.next();
                boolean bl3 = false;
                String string = entry4.getKey();
                entry4 = entry3;
                bl3 = false;
                List<RunnerAndConfigurationSettings> configurations = entry4.getValue();
                DefaultMutableTreeNode node = null;
                if (folder == null) {
                    node = typeNode;
                } else {
                    node = new DefaultMutableTreeNode(folder);
                    typeNode.add(node);
                }
                for (RunnerAndConfigurationSettings it : configurations) {
                    node.add(new DefaultMutableTreeNode(it));
                }
            }
        }
    }

    public ProjectRunConfigurationConfigurable(@NotNull Project project2, @Nullable RunDialogBase runDialog) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        super(project2, runDialog);
    }

    public /* synthetic */ ProjectRunConfigurationConfigurable(Project project2, RunDialogBase runDialogBase, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            runDialogBase = null;
        }
        this(project2, runDialogBase);
    }
}

