/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/execution/impl/RunConfigEditorNotificationProvider;", "Lcom/intellij/ui/EditorNotifications$Provider;", "Lcom/intellij/ui/EditorNotificationPanel;", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "createNotificationPanel", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "getKey", "intellij.platform.execution.impl"})
public final class RunConfigEditorNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private final Key<EditorNotificationPanel> KEY;

    @Override
    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return this.KEY;
    }

    @Override
    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)fileEditor, (String)"fileEditor");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        String string = file2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
        if (!StringsKt.endsWith$default((String)string, (String)".run.xml", (boolean)false, (int)2, null)) {
            return null;
        }
        if (!ProjectFileIndex.getInstance(project2).isInContent(file2)) {
            return null;
        }
        EditorNotificationPanel panel2 = new EditorNotificationPanel();
        panel2.setText(ExecutionBundle.message("manual.editing.of.config.file.not.recommended", new Object[0]));
        panel2.createActionLabel(ExecutionBundle.message("open.run.debug.dialog", new Object[0]), new Runnable(project2, file2){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $file;

            public final void run() {
                RunManagerImpl runManager = RunManagerImpl.Companion.getInstanceImpl(this.$project);
                RunnerAndConfigurationSettings oldSelectedConfig = runManager.getSelectedConfiguration();
                runManager.selectConfigurationStoredInFile$intellij_platform_execution_impl(this.$file);
                boolean ok = new EditConfigurationsDialog(this.$project).showAndGet();
                if (!ok) {
                    runManager.setSelectedConfiguration(oldSelectedConfig);
                }
            }
            {
                this.$project = project2;
                this.$file = virtualFile2;
            }
        });
        return panel2;
    }

    public RunConfigEditorNotificationProvider() {
        Key key = Key.create("RunConfigEditorNotificationProvider");
        Intrinsics.checkExpressionValueIsNotNull(key, (String)"Key.create(\"RunConfigEditorNotificationProvider\")");
        this.KEY = key;
    }
}

