/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.ExecutionTargetManagerImpl;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.compound.ConfigurationSelectionUtil;
import com.intellij.execution.compound.TypeNameTarget;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.BeforeRunTaskAwareConfiguration;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.impl.RunConfigurationBeforeRunProviderDelegate;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class RunConfigurationBeforeRunProvider
extends BeforeRunTaskProvider<RunConfigurableBeforeRunTask> {
    public static final Key<RunConfigurableBeforeRunTask> ID = Key.create("RunConfigurationTask");
    private static final Logger LOG = Logger.getInstance(RunConfigurationBeforeRunProvider.class);
    private final Project myProject;

    public RunConfigurationBeforeRunProvider(Project project2) {
        this.myProject = project2;
    }

    @Override
    public Key<RunConfigurableBeforeRunTask> getId() {
        return ID;
    }

    @Override
    public Icon getIcon() {
        return AllIcons.Actions.Execute;
    }

    @Override
    public Icon getTaskIcon(RunConfigurableBeforeRunTask task2) {
        if (task2.getSettings() == null) {
            return null;
        }
        return ProgramRunnerUtil.getConfigurationIcon(task2.getSettings(), false);
    }

    @Override
    public String getName() {
        return ExecutionBundle.message("before.launch.run.another.configuration", new Object[0]);
    }

    @Override
    public String getDescription(RunConfigurableBeforeRunTask task2) {
        Pair<RunnerAndConfigurationSettings, ExecutionTarget> settingsWithTarget = task2.getSettingsWithTarget();
        if (settingsWithTarget == null) {
            return ExecutionBundle.message("before.launch.run.another.configuration", new Object[0]);
        }
        String text2 = ConfigurationSelectionUtil.getDisplayText(((RunnerAndConfigurationSettings)settingsWithTarget.first).getConfiguration(), (ExecutionTarget)settingsWithTarget.second);
        return ExecutionBundle.message("before.launch.run.certain.configuration", text2);
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    @Nullable
    public RunConfigurableBeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            RunConfigurationBeforeRunProvider.$$$reportNull$$$0(0);
        }
        return new RunConfigurableBeforeRunTask();
    }

    @Override
    public Promise<Boolean> configureTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull RunConfigurableBeforeRunTask task2) {
        if (context == null) {
            RunConfigurationBeforeRunProvider.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            RunConfigurationBeforeRunProvider.$$$reportNull$$$0(2);
        }
        if (task2 == null) {
            RunConfigurationBeforeRunProvider.$$$reportNull$$$0(3);
        }
        Project project2 = configuration.getProject();
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(project2);
        List<RunConfiguration> configurations = ContainerUtil.map(RunConfigurationBeforeRunProvider.getAvailableConfigurations(configuration), it -> it.getConfiguration());
        AsyncPromise result2 = new AsyncPromise();
        ConfigurationSelectionUtil.createPopup(project2, runManager, configurations, (selectedConfigs, selectedTarget) -> {
            RunnerAndConfigurationSettingsImpl selectedSettings;
            RunConfiguration selectedConfig = (RunConfiguration)ContainerUtil.getFirstItem(selectedConfigs);
            RunnerAndConfigurationSettingsImpl runnerAndConfigurationSettingsImpl = selectedSettings = selectedConfig == null ? null : runManager.getSettings(selectedConfig);
            if (selectedSettings != null) {
                task2.setSettingsWithTarget(selectedSettings, (ExecutionTarget)selectedTarget);
                result2.setResult((Object)true);
            } else {
                result2.setResult((Object)false);
            }
        }).showInBestPositionFor(context);
        return result2;
    }

    @NotNull
    private static List<RunnerAndConfigurationSettings> getAvailableConfigurations(@NotNull RunConfiguration runConfiguration) {
        Project project2;
        if (runConfiguration == null) {
            RunConfigurationBeforeRunProvider.$$$reportNull$$$0(4);
        }
        if ((project2 = runConfiguration.getProject()) == null || !project2.isInitialized()) {
            List<RunnerAndConfigurationSettings> list2 = Collections.emptyList();
            if (list2 == null) {
                RunConfigurationBeforeRunProvider.$$$reportNull$$$0(5);
            }
            return list2;
        }
        ArrayList<RunnerAndConfigurationSettings> configurations = new ArrayList<RunnerAndConfigurationSettings>(RunManagerImpl.getInstanceImpl(project2).getAllSettings());
        String executorId = DefaultRunExecutor.getRunExecutorInstance().getId();
        Iterator iterator2 = configurations.iterator();
        while (iterator2.hasNext()) {
            RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)iterator2.next();
            ProgramRunner<RunnerSettings> runner = ProgramRunner.getRunner(executorId, settings.getConfiguration());
            if (runner != null && settings.getConfiguration() != runConfiguration) continue;
            iterator2.remove();
        }
        ArrayList<RunnerAndConfigurationSettings> arrayList = configurations;
        if (arrayList == null) {
            RunConfigurationBeforeRunProvider.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Override
    public boolean canExecuteTask(@NotNull RunConfiguration configuration, @NotNull RunConfigurableBeforeRunTask task2) {
        RunnerAndConfigurationSettings settings;
        if (configuration == null) {
            RunConfigurationBeforeRunProvider.$$$reportNull$$$0(7);
        }
        if (task2 == null) {
            RunConfigurationBeforeRunProvider.$$$reportNull$$$0(8);
        }
        if ((settings = task2.getSettings()) == null) {
            return false;
        }
        String executorId = DefaultRunExecutor.getRunExecutorInstance().getId();
        ProgramRunner<RunnerSettings> runner = ProgramRunner.getRunner(executorId, settings.getConfiguration());
        return runner != null && runner.canRun(executorId, settings.getConfiguration());
    }

    @Override
    public boolean executeTask(@NotNull DataContext dataContext, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull RunConfigurableBeforeRunTask task2) {
        Pair<RunnerAndConfigurationSettings, ExecutionTarget> settings;
        if (dataContext == null) {
            RunConfigurationBeforeRunProvider.$$$reportNull$$$0(9);
        }
        if (configuration == null) {
            RunConfigurationBeforeRunProvider.$$$reportNull$$$0(10);
        }
        if (env == null) {
            RunConfigurationBeforeRunProvider.$$$reportNull$$$0(11);
        }
        if (task2 == null) {
            RunConfigurationBeforeRunProvider.$$$reportNull$$$0(12);
        }
        if ((settings = task2.getSettingsWithTarget()) == null) {
            return true;
        }
        return RunConfigurationBeforeRunProvider.doExecuteTask(env, (RunnerAndConfigurationSettings)settings.first, (ExecutionTarget)settings.second);
    }

    public static boolean doExecuteTask(@NotNull ExecutionEnvironment env, @NotNull RunnerAndConfigurationSettings settings, @Nullable ExecutionTarget target2) {
        RunConfiguration configuration;
        if (env == null) {
            RunConfigurationBeforeRunProvider.$$$reportNull$$$0(13);
        }
        if (settings == null) {
            RunConfigurationBeforeRunProvider.$$$reportNull$$$0(14);
        }
        Executor executor = (configuration = settings.getConfiguration()) instanceof BeforeRunTaskAwareConfiguration && ((BeforeRunTaskAwareConfiguration)((Object)configuration)).useRunExecutor() ? DefaultRunExecutor.getRunExecutorInstance() : env.getExecutor();
        String executorId = executor.getId();
        ExecutionEnvironmentBuilder builder2 = ExecutionEnvironmentBuilder.createOrNull(executor, settings);
        if (builder2 == null) {
            return false;
        }
        ExecutionTarget effectiveTarget = target2;
        if (effectiveTarget == null && ExecutionTargetManager.canRun(settings.getConfiguration(), env.getExecutionTarget())) {
            effectiveTarget = env.getExecutionTarget();
        }
        List<ExecutionTarget> allTargets = ExecutionTargetManager.getInstance(env.getProject()).getTargetsFor(settings.getConfiguration());
        if (effectiveTarget == null) {
            effectiveTarget = (ExecutionTarget)((Object)ContainerUtil.find(allTargets, it -> it.isReady()));
        }
        if (effectiveTarget == null) {
            effectiveTarget = ContainerUtil.getFirstItem(allTargets);
        }
        if (effectiveTarget == null) {
            return false;
        }
        ExecutionEnvironment environment2 = builder2.target(effectiveTarget).build();
        environment2.setExecutionId(env.getExecutionId());
        if (!environment2.getRunner().canRun(executorId, environment2.getRunProfile())) {
            return false;
        }
        RunConfigurationBeforeRunProvider.beforeRun(environment2);
        return RunConfigurationBeforeRunProvider.doRunTask(executorId, environment2, environment2.getRunner());
    }

    public static boolean doRunTask(final String executorId, final ExecutionEnvironment environment2, ProgramRunner<?> runner) {
        final Semaphore targetDone = new Semaphore();
        final Ref<Boolean> result2 = new Ref<Boolean>(false);
        Disposable disposable2 = Disposer.newDisposable();
        environment2.getProject().getMessageBus().connect(disposable2).subscribe(ExecutionManager.EXECUTION_TOPIC, new ExecutionListener(){

            @Override
            public void processStartScheduled(@NotNull String executorIdLocal, @NotNull ExecutionEnvironment environmentLocal) {
                if (executorIdLocal == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (environmentLocal == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (executorId.equals(executorIdLocal) && environment2.equals(environmentLocal)) {
                    targetDone.down();
                }
            }

            @Override
            public void processNotStarted(@NotNull String executorIdLocal, @NotNull ExecutionEnvironment environmentLocal) {
                if (executorIdLocal == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (environmentLocal == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (executorId.equals(executorIdLocal) && environment2.equals(environmentLocal)) {
                    Boolean skipRun = environment2.getUserData(ExecutionManagerImpl.EXECUTION_SKIP_RUN);
                    if (skipRun != null && skipRun.booleanValue()) {
                        result2.set(true);
                    }
                    targetDone.up();
                }
            }

            @Override
            public void processTerminated(@NotNull String executorIdLocal, @NotNull ExecutionEnvironment environmentLocal, @NotNull ProcessHandler handler2, int exitCode) {
                if (executorIdLocal == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (environmentLocal == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (handler2 == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (executorId.equals(executorIdLocal) && environment2.equals(environmentLocal)) {
                    result2.set(exitCode == 0);
                    targetDone.up();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executorIdLocal";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "environmentLocal";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "handler";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/execution/impl/RunConfigurationBeforeRunProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processStartScheduled";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processNotStarted";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        try {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                try {
                    runner.execute(environment2);
                }
                catch (ExecutionException e) {
                    targetDone.up();
                    LOG.error(e);
                }
            }, ModalityState.NON_MODAL);
        }
        catch (Exception e) {
            LOG.error(e);
            Disposer.dispose(disposable2);
            return false;
        }
        targetDone.waitFor();
        Disposer.dispose(disposable2);
        return result2.get();
    }

    private static void beforeRun(@NotNull ExecutionEnvironment environment2) {
        if (environment2 == null) {
            RunConfigurationBeforeRunProvider.$$$reportNull$$$0(15);
        }
        for (RunConfigurationBeforeRunProviderDelegate delegate : RunConfigurationBeforeRunProviderDelegate.EP_NAME.getExtensionList()) {
            delegate.beforeRun(environment2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/RunConfigurationBeforeRunProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/RunConfigurationBeforeRunProvider";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "configureTask";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableConfigurations";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canExecuteTask";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "executeTask";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doExecuteTask";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "beforeRun";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class RunConfigurableBeforeRunTask
    extends BeforeRunTask<RunConfigurableBeforeRunTask> {
        @Nullable
        private TypeNameTarget myTypeNameTarget;
        @Nullable
        private Pair<RunnerAndConfigurationSettings, ExecutionTarget> mySettingsWithTarget;

        RunConfigurableBeforeRunTask() {
            super(ID);
        }

        @Override
        public void writeExternal(@NotNull Element element2) {
            if (element2 == null) {
                RunConfigurableBeforeRunTask.$$$reportNull$$$0(0);
            }
            super.writeExternal(element2);
            if (this.myTypeNameTarget != null) {
                element2.setAttribute("run_configuration_name", this.myTypeNameTarget.getName());
                element2.setAttribute("run_configuration_type", this.myTypeNameTarget.getType());
                if (this.myTypeNameTarget.getTargetId() != null) {
                    element2.setAttribute("run_configuration_target", this.myTypeNameTarget.getTargetId());
                }
            }
        }

        @Override
        public void readExternal(@NotNull Element element2) {
            if (element2 == null) {
                RunConfigurableBeforeRunTask.$$$reportNull$$$0(1);
            }
            super.readExternal(element2);
            String name = element2.getAttributeValue("run_configuration_name");
            String type = element2.getAttributeValue("run_configuration_type");
            String targetId = element2.getAttributeValue("run_configuration_target");
            if (name != null && type != null) {
                this.myTypeNameTarget = new TypeNameTarget(type, name, targetId);
            }
            this.mySettingsWithTarget = null;
        }

        boolean isMySettings(@NotNull RunnerAndConfigurationSettings settings) {
            if (settings == null) {
                RunConfigurableBeforeRunTask.$$$reportNull$$$0(2);
            }
            if (this.mySettingsWithTarget != null) {
                return this.mySettingsWithTarget.first == settings;
            }
            return this.myTypeNameTarget != null && settings.getType().getId().equals(this.myTypeNameTarget.getType()) && settings.getName().equals(this.myTypeNameTarget.getName());
        }

        void init() {
            if (this.mySettingsWithTarget != null) {
                return;
            }
            if (this.myTypeNameTarget != null) {
                RunnerAndConfigurationSettings settings = RunManagerImpl.getInstanceImpl(RunConfigurationBeforeRunProvider.this.myProject).findConfigurationByTypeAndName(this.myTypeNameTarget.getType(), this.myTypeNameTarget.getName());
                ExecutionTarget target2 = ((ExecutionTargetManagerImpl)ExecutionTargetManager.getInstance(RunConfigurationBeforeRunProvider.this.myProject)).findTargetByIdFor(settings != null ? settings.getConfiguration() : null, this.myTypeNameTarget.getTargetId());
                this.setSettingsWithTarget(settings, target2);
            }
        }

        public void setSettingsWithTarget(@Nullable RunnerAndConfigurationSettings settings, @Nullable ExecutionTarget target2) {
            Pair<RunnerAndConfigurationSettings, ExecutionTarget> pair = this.mySettingsWithTarget = settings == null ? null : Pair.create(settings, target2);
            this.myTypeNameTarget = settings == null ? null : new TypeNameTarget(settings.getType().getId(), settings.getName(), target2 == null ? null : target2.getId());
        }

        @Nullable
        public RunnerAndConfigurationSettings getSettings() {
            return Pair.getFirst(this.getSettingsWithTarget());
        }

        @Nullable
        public Pair<RunnerAndConfigurationSettings, ExecutionTarget> getSettingsWithTarget() {
            this.init();
            return this.mySettingsWithTarget;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RunConfigurableBeforeRunTask that = (RunConfigurableBeforeRunTask)o;
            return Comparing.equal(this.myTypeNameTarget, that.myTypeNameTarget);
        }

        @Override
        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + (this.myTypeNameTarget != null ? this.myTypeNameTarget.hashCode() : 0);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/impl/RunConfigurationBeforeRunProvider$RunConfigurableBeforeRunTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeExternal";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "readExternal";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isMySettings";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

