/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.ProjectRunConfigurationConfigurable;
import com.intellij.execution.impl.RunConfigurable;
import com.intellij.execution.impl.RunDialogBase;
import com.intellij.execution.impl.SingleConfigurationConfigurable;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.util.ui.UIUtil;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.plaf.basic.ComboPopup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunDialog
extends DialogWrapper
implements RunDialogBase {
    private final Project myProject;
    private final RunConfigurable myConfigurable;
    private JComponent myCenterPanel;
    private final Executor myExecutor;

    public RunDialog(Project project2, Executor executor) {
        super(project2, true);
        this.myProject = project2;
        this.myExecutor = executor;
        this.setTitle(executor.getId());
        this.setOKButtonText(executor.getActionName());
        this.myConfigurable = new ProjectRunConfigurationConfigurable(project2, this);
        this.init();
        this.myConfigurable.reset();
    }

    @Override
    protected Action @NotNull [] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), new ApplyAction(), this.getHelpAction()};
        if (actionArray == null) {
            RunDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    @Override
    protected String getHelpId() {
        return "reference.dialogs.rundebug";
    }

    @Override
    protected String getDimensionServiceKey() {
        return "#com.intellij.execution.impl.RunDialog";
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return IdeFocusTraversalPolicy.getPreferredFocusedComponent(this.myCenterPanel);
    }

    @Override
    protected void doOKAction() {
        try {
            this.myConfigurable.apply();
        }
        catch (ConfigurationException e) {
            Messages.showMessageDialog(this.myProject, e.getMessage(), ExecutionBundle.message("invalid.data.dialog.title", new Object[0]), Messages.getErrorIcon());
            return;
        }
        super.doOKAction();
    }

    @Override
    protected JComponent createCenterPanel() {
        this.myCenterPanel = this.myConfigurable.createComponent();
        return this.myCenterPanel;
    }

    @Override
    protected void dispose() {
        this.myConfigurable.disposeUIResources();
        super.dispose();
    }

    public static boolean editConfiguration(Project project2, @NotNull RunnerAndConfigurationSettings configuration, String title) {
        if (configuration == null) {
            RunDialog.$$$reportNull$$$0(1);
        }
        return RunDialog.editConfiguration(project2, configuration, title, null);
    }

    public static boolean editConfiguration(@NotNull ExecutionEnvironment environment2, @NotNull String title) {
        if (environment2 == null) {
            RunDialog.$$$reportNull$$$0(2);
        }
        if (title == null) {
            RunDialog.$$$reportNull$$$0(3);
        }
        return RunDialog.editConfiguration(environment2.getProject(), environment2.getRunnerAndConfigurationSettings(), title, environment2.getExecutor());
    }

    public static boolean editConfiguration(Project project2, @NotNull RunnerAndConfigurationSettings configuration, String title, final @Nullable Executor executor) {
        if (configuration == null) {
            RunDialog.$$$reportNull$$$0(4);
        }
        SingleConfigurationConfigurable configurable2 = SingleConfigurationConfigurable.editSettings(configuration, executor);
        SingleConfigurableEditor dialog2 = new SingleConfigurableEditor(project2, configurable2, DialogWrapper.IdeModalityType.IDE){
            {
                super(arg0, arg1, arg2);
                if (executor != null) {
                    this.setOKButtonText(executor.getActionName());
                }
            }
        };
        dialog2.setTitle(title);
        return dialog2.showAndGet();
    }

    public static SingleConfigurableEditor editShortenClasspathSetting(RunnerAndConfigurationSettings settings, String title) {
        SingleConfigurationConfigurable configurable2 = SingleConfigurationConfigurable.editSettings(settings, null);
        SingleConfigurableEditor dialog2 = new SingleConfigurableEditor(settings.getConfiguration().getProject(), configurable2, DialogWrapper.IdeModalityType.IDE){

            @Override
            public JComponent getPreferredFocusedComponent() {
                List<LabeledComponent> labeledComponents = UIUtil.findComponentsOfType(this.getContentPanel(), LabeledComponent.class);
                String shortenLabelText = ExecutionBundle.message("application.configuration.shorten.command.line.label", new Object[0]).replace("\u001b", "");
                for (LabeledComponent component2 : labeledComponents) {
                    Object cp;
                    if (!shortenLabelText.equals(component2.getRawText()) || !((cp = component2.getComponent()) instanceof ComboBox)) continue;
                    ApplicationManager.getApplication().invokeLater(() -> {
                        ComboPopup popup2 = ((ComboBox)cp).getPopup();
                        if (popup2 != null && cp.isShowing()) {
                            popup2.show();
                        }
                    });
                    return cp;
                }
                return super.getPreferredFocusedComponent();
            }
        };
        dialog2.setTitle(title);
        return dialog2;
    }

    @Override
    public Executor getExecutor() {
        return this.myExecutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/RunDialog";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/RunDialog";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "editConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ApplyAction
    extends AbstractAction {
        ApplyAction() {
            super(ExecutionBundle.message("apply.action.name", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                RunDialog.this.myConfigurable.apply();
            }
            catch (ConfigurationException e) {
                Messages.showMessageDialog(RunDialog.this.myProject, e.getMessage(), ExecutionBundle.message("invalid.data.dialog.title", new Object[0]), Messages.getErrorIcon());
            }
        }
    }
}

