/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl.statistics;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationOptions;
import com.intellij.execution.configurations.UnknownConfigurationType;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomWhiteListRule;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.components.StoredProperty;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TObjectIntHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;

public class RunConfigurationTypeUsagesCollector
extends ProjectUsagesCollector {
    private static final String ID_FIELD = "id";
    private static final String FACTORY_FIELD = "factory";

    @NotNull
    public String getGroupId() {
        return "run.configuration.type";
    }

    public int getVersion() {
        return 6;
    }

    @NotNull
    public CancellablePromise<Set<MetricEvent>> getMetrics(@NotNull Project project2, @NotNull ProgressIndicator indicator) {
        if (project2 == null) {
            RunConfigurationTypeUsagesCollector.$$$reportNull$$$0(0);
        }
        if (indicator == null) {
            RunConfigurationTypeUsagesCollector.$$$reportNull$$$0(1);
        }
        AsyncPromise result2 = new AsyncPromise();
        UIUtil.invokeLaterIfNeeded(() -> {
            try {
                TObjectIntHashMap<Template> templates = new TObjectIntHashMap<Template>();
                if (project2.isDisposed()) {
                    result2.setResult(Collections.emptySet());
                    return;
                }
                RunManager runManager = RunManager.getInstance(project2);
                for (RunnerAndConfigurationSettings settings : runManager.getAllSettings()) {
                    ProgressManager.checkCanceled();
                    RunConfiguration runConfiguration = settings.getConfiguration();
                    ConfigurationFactory configurationFactory = runConfiguration.getFactory();
                    if (configurationFactory == null) continue;
                    ConfigurationType configurationType = configurationFactory.getType();
                    FeatureUsageData data2 = RunConfigurationTypeUsagesCollector.newFeatureUsageData(configurationType, configurationFactory);
                    RunConfigurationTypeUsagesCollector.fillSettings(data2, settings, runConfiguration);
                    Template template2 = new Template("configured.in.project", data2);
                    RunConfigurationTypeUsagesCollector.addOrIncrement(templates, template2);
                    RunConfigurationTypeUsagesCollector.collectRunConfigurationFeatures(runConfiguration, templates);
                }
                HashSet metrics = new HashSet();
                templates.forEachEntry((template, value2) -> {
                    metrics.add(((Template)template).createMetricEvent(value2));
                    return true;
                });
                result2.setResult(metrics);
            }
            catch (Throwable t) {
                result2.setError(t);
                throw t;
            }
        });
        AsyncPromise asyncPromise = result2;
        if (asyncPromise == null) {
            RunConfigurationTypeUsagesCollector.$$$reportNull$$$0(2);
        }
        return asyncPromise;
    }

    private static void addOrIncrement(TObjectIntHashMap<Template> templates, Template template) {
        if (templates.containsKey(template)) {
            templates.increment(template);
        } else {
            templates.put(template, 1);
        }
    }

    private static void collectRunConfigurationFeatures(RunConfiguration runConfiguration, TObjectIntHashMap<Template> templates) {
        if (runConfiguration instanceof RunConfigurationBase) {
            PluginInfo info = PluginInfoDetectorKt.getPluginInfo(runConfiguration.getClass());
            if (!info.isSafeToReport()) {
                return;
            }
            Object state = ((RunConfigurationBase)runConfiguration).getState();
            if (state instanceof RunConfigurationOptions) {
                RunConfigurationOptions runConfigurationOptions = (RunConfigurationOptions)state;
                List<StoredProperty<Object>> properties = runConfigurationOptions.__getProperties();
                for (StoredProperty<Object> property : properties) {
                    boolean featureUsed;
                    String name = property.getName();
                    if (name == null || name.equals("isAllowRunningInParallel") || name.equals("isNameGenerated")) continue;
                    Object value2 = property.getValue(runConfigurationOptions);
                    if (value2 instanceof Boolean) {
                        featureUsed = (Boolean)value2;
                    } else if (value2 instanceof String) {
                        featureUsed = StringUtil.isNotEmpty((String)value2);
                    } else if (value2 instanceof Collection) {
                        featureUsed = ((Collection)value2).size() > 0;
                    } else {
                        if (!(value2 instanceof Map)) continue;
                        boolean bl = featureUsed = ((Map)value2).size() > 0;
                    }
                    if (!featureUsed) continue;
                    FeatureUsageData data2 = new FeatureUsageData().addData(ID_FIELD, runConfiguration.getType().getId()).addPluginInfo(info).addData("featureName", name);
                    RunConfigurationTypeUsagesCollector.addOrIncrement(templates, new Template("feature.used", data2));
                }
            }
        }
    }

    @NotNull
    public static FeatureUsageData newFeatureUsageData(@NotNull ConfigurationType configuration, @Nullable ConfigurationFactory factory) {
        if (configuration == null) {
            RunConfigurationTypeUsagesCollector.$$$reportNull$$$0(3);
        }
        String id2 = configuration instanceof UnknownConfigurationType ? "unknown" : configuration.getId();
        FeatureUsageData data2 = new FeatureUsageData().addData(ID_FIELD, id2);
        if (factory != null && configuration.getConfigurationFactories().length > 1) {
            data2.addData(FACTORY_FIELD, factory.getId());
        }
        FeatureUsageData featureUsageData = data2;
        if (featureUsageData == null) {
            RunConfigurationTypeUsagesCollector.$$$reportNull$$$0(4);
        }
        return featureUsageData;
    }

    private static void fillSettings(@NotNull FeatureUsageData data2, @NotNull RunnerAndConfigurationSettings settings, @NotNull RunConfiguration runConfiguration) {
        if (data2 == null) {
            RunConfigurationTypeUsagesCollector.$$$reportNull$$$0(5);
        }
        if (settings == null) {
            RunConfigurationTypeUsagesCollector.$$$reportNull$$$0(6);
        }
        if (runConfiguration == null) {
            RunConfigurationTypeUsagesCollector.$$$reportNull$$$0(7);
        }
        data2.addData("shared", settings.isShared()).addData("edit_before_run", settings.isEditBeforeRun()).addData("activate_before_run", settings.isActivateToolWindowBeforeRun()).addData("parallel", runConfiguration.isAllowRunningInParallel()).addData("temporary", settings.isTemporary());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/statistics/RunConfigurationTypeUsagesCollector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/statistics/RunConfigurationTypeUsagesCollector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "newFeatureUsageData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "newFeatureUsageData";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fillSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RunConfigurationUtilValidator
    extends CustomWhiteListRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "run_config_id".equals(ruleId) || "run_config_factory".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            if (data2 == null) {
                RunConfigurationUtilValidator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                RunConfigurationUtilValidator.$$$reportNull$$$0(1);
            }
            if (RunConfigurationUtilValidator.isThirdPartyValue((String)data2) || "unknown".equals(data2)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    RunConfigurationUtilValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            String configurationId = this.getEventDataField(context, RunConfigurationTypeUsagesCollector.ID_FIELD);
            String factoryId = this.getEventDataField(context, RunConfigurationTypeUsagesCollector.FACTORY_FIELD);
            if (configurationId == null) {
                ValidationResultType validationResultType = ValidationResultType.REJECTED;
                if (validationResultType == null) {
                    RunConfigurationUtilValidator.$$$reportNull$$$0(3);
                }
                return validationResultType;
            }
            if (StringUtil.equals(data2, configurationId) || StringUtil.equals(data2, factoryId)) {
                Pair<ConfigurationType, ConfigurationFactory> configurationAndFactory = RunConfigurationUtilValidator.findConfigurationAndFactory(configurationId, factoryId);
                ConfigurationType configuration = configurationAndFactory.getFirst();
                ConfigurationFactory factory = configurationAndFactory.getSecond();
                if (configuration != null && (StringUtil.isEmpty(factoryId) || factory != null)) {
                    PluginInfo info = PluginInfoDetectorKt.getPluginInfo(configuration.getClass());
                    context.setPluginInfo(info);
                    ValidationResultType validationResultType = info.isDevelopedByJetBrains() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
                    if (validationResultType == null) {
                        RunConfigurationUtilValidator.$$$reportNull$$$0(4);
                    }
                    return validationResultType;
                }
            }
            ValidationResultType validationResultType = ValidationResultType.REJECTED;
            if (validationResultType == null) {
                RunConfigurationUtilValidator.$$$reportNull$$$0(5);
            }
            return validationResultType;
        }

        @NotNull
        private static Pair<ConfigurationType, ConfigurationFactory> findConfigurationAndFactory(@NotNull String configurationId, @Nullable String factoryId) {
            ConfigurationType configuration;
            if (configurationId == null) {
                RunConfigurationUtilValidator.$$$reportNull$$$0(6);
            }
            if ((configuration = RunConfigurationUtilValidator.findRunConfigurationById(configurationId)) == null) {
                Pair<ConfigurationType, ConfigurationFactory> pair = Pair.empty();
                if (pair == null) {
                    RunConfigurationUtilValidator.$$$reportNull$$$0(7);
                }
                return pair;
            }
            ConfigurationFactory factory = StringUtil.isEmpty(factoryId) ? null : RunConfigurationUtilValidator.findFactoryById(configuration, factoryId);
            Pair<ConfigurationType, ConfigurationFactory> pair = Pair.create(configuration, factory);
            if (pair == null) {
                RunConfigurationUtilValidator.$$$reportNull$$$0(8);
            }
            return pair;
        }

        @Nullable
        private static ConfigurationType findRunConfigurationById(@NotNull String configuration) {
            ConfigurationType[] types;
            if (configuration == null) {
                RunConfigurationUtilValidator.$$$reportNull$$$0(9);
            }
            for (ConfigurationType type : types = ConfigurationType.CONFIGURATION_TYPE_EP.getExtensions()) {
                if (!StringUtil.equals(type.getId(), configuration)) continue;
                return type;
            }
            return null;
        }

        @Nullable
        private static ConfigurationFactory findFactoryById(@NotNull ConfigurationType configuration, @NotNull String factoryId) {
            if (configuration == null) {
                RunConfigurationUtilValidator.$$$reportNull$$$0(10);
            }
            if (factoryId == null) {
                RunConfigurationUtilValidator.$$$reportNull$$$0(11);
            }
            for (ConfigurationFactory factory : configuration.getConfigurationFactories()) {
                if (!StringUtil.equals(factory.getId(), factoryId)) continue;
                return factory;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/impl/statistics/RunConfigurationTypeUsagesCollector$RunConfigurationUtilValidator";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurationId";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factoryId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/impl/statistics/RunConfigurationTypeUsagesCollector$RunConfigurationUtilValidator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findConfigurationAndFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "findConfigurationAndFactory";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "findRunConfigurationById";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "findFactoryById";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Template {
        private final String myKey;
        private final FeatureUsageData myData;

        private Template(String key, FeatureUsageData data2) {
            this.myKey = key;
            this.myData = data2;
        }

        @NotNull
        private MetricEvent createMetricEvent(int count) {
            MetricEvent metricEvent = MetricEventFactoryKt.newCounterMetric((String)this.myKey, (int)count, (FeatureUsageData)this.myData);
            if (metricEvent == null) {
                Template.$$$reportNull$$$0(0);
            }
            return metricEvent;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Template template = (Template)o;
            return Objects.equals(this.myKey, template.myKey) && Objects.equals(this.myData, template.myData);
        }

        public int hashCode() {
            return Objects.hash(this.myKey, this.myData);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/statistics/RunConfigurationTypeUsagesCollector$Template", "createMetricEvent"));
        }
    }
}

