/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.lineMarker;

import com.intellij.execution.Executor;
import com.intellij.execution.actions.BaseRunConfigurationAction;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.lineMarker.ExecutorActionKt;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.extensions.ExtensionPointName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\b\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\u0013\u0010\u0014\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0012J\u001d\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u0007H\u0016J\b\u0010\u001e\u001a\u00020\u0010H\u0016J\b\u0010\u001f\u001a\u00020\u0010H\u0016J\b\u0010 \u001a\u00020\u0010H\u0016J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006#"}, d2={"Lcom/intellij/execution/lineMarker/ExecutorAction;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "origin", "Lcom/intellij/openapi/actionSystem/AnAction;", "executor", "Lcom/intellij/execution/Executor;", "order", "", "(Lcom/intellij/openapi/actionSystem/AnAction;Lcom/intellij/execution/Executor;I)V", "getOrigin", "()Lcom/intellij/openapi/actionSystem/AnAction;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "canBePerformed", "", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "disableIfNoVisibleChildren", "equals", "other", "", "getActionName", "", "dataContext", "getChildren", "", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "hashCode", "hideIfNoVisibleChildren", "isDumbAware", "isPopup", "update", "Companion", "intellij.platform.execution.impl"})
public final class ExecutorAction
extends ActionGroup {
    @NotNull
    private final AnAction origin;
    private final Executor executor;
    private final int order;
    public static final Companion Companion = new Companion(null);

    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataContext, (String)"e.dataContext");
        String name = this.getActionName(dataContext);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(name != null);
        this.origin.update(e);
        if (name != null) {
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"e.presentation");
            presentation2.setText(name);
        }
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        this.origin.actionPerformed(e);
    }

    @Override
    public boolean canBePerformed(@NotNull DataContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return !(this.origin instanceof ActionGroup) || ((ActionGroup)this.origin).canBePerformed(context);
    }

    @Override
    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray;
        AnAction anAction = this.origin;
        if (!(anAction instanceof ActionGroup)) {
            anAction = null;
        }
        if ((anActionArray = (AnAction[])anAction) == null || (anActionArray = anActionArray.getChildren(e)) == null) {
            anActionArray = AnAction.EMPTY_ARRAY;
            Intrinsics.checkExpressionValueIsNotNull((Object)AnAction.EMPTY_ARRAY, (String)"AnAction.EMPTY_ARRAY");
        }
        return anActionArray;
    }

    @Override
    public boolean isDumbAware() {
        return this.origin.isDumbAware();
    }

    @Override
    public boolean isPopup() {
        return !(this.origin instanceof ActionGroup) || ((ActionGroup)this.origin).isPopup();
    }

    @Override
    public boolean hideIfNoVisibleChildren() {
        return this.origin instanceof ActionGroup && ((ActionGroup)this.origin).hideIfNoVisibleChildren();
    }

    @Override
    public boolean disableIfNoVisibleChildren() {
        return !(this.origin instanceof ActionGroup) || ((ActionGroup)this.origin).disableIfNoVisibleChildren();
    }

    @Nullable
    public final String getActionName(@NotNull DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        List list2 = ExecutorAction.Companion.getConfigurations(dataContext);
        if (list2.isEmpty()) {
            return null;
        }
        RunConfiguration runConfiguration = ((ConfigurationFromContext)list2.get(this.order < list2.size() ? this.order : 0)).getConfiguration();
        if (runConfiguration == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.execution.configurations.LocatableConfiguration");
        }
        LocatableConfiguration configuration = (LocatableConfiguration)runConfiguration;
        return this.executor.getStartActionText(BaseRunConfigurationAction.suggestRunActionName(configuration));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExecutorAction)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.origin, (Object)((ExecutorAction)other).origin) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.executor, (Object)((ExecutorAction)other).executor) ^ true) {
            return false;
        }
        return this.order == ((ExecutorAction)other).order;
    }

    public int hashCode() {
        int result2 = this.origin.hashCode();
        result2 = 31 * result2 + this.executor.hashCode();
        result2 = 31 * result2 + this.order;
        return result2;
    }

    @NotNull
    public final AnAction getOrigin() {
        return this.origin;
    }

    private ExecutorAction(AnAction origin, Executor executor, int order) {
        this.origin = origin;
        this.executor = executor;
        this.order = order;
        this.copyFrom(this.origin);
    }

    public /* synthetic */ ExecutorAction(AnAction origin, Executor executor, int order, DefaultConstructorMarker $constructor_marker) {
        this(origin, executor, order);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final AnAction[] getActions(int order) {
        return Companion.getActions(order);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final AnAction[] getActions() {
        return com.intellij.execution.lineMarker.ExecutorAction$Companion.getActions$default(Companion, 0, 1, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<AnAction> getActionList(int order) {
        return Companion.getActionList(order);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<AnAction> getActionList() {
        return com.intellij.execution.lineMarker.ExecutorAction$Companion.getActionList$default(Companion, 0, 1, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007J\u001d\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/execution/lineMarker/ExecutorAction$Companion;", "", "()V", "computeConfigurations", "", "Lcom/intellij/execution/actions/ConfigurationFromContext;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getActionList", "Lcom/intellij/openapi/actionSystem/AnAction;", "order", "", "getActions", "", "(I)[Lcom/intellij/openapi/actionSystem/AnAction;", "getConfigurations", "intellij.platform.execution.impl"})
    public static final class Companion {
        @JvmStatic
        @JvmOverloads
        @NotNull
        public final AnAction[] getActions(int order) {
            Collection $this$toTypedArray$iv = this.getActionList(order);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            AnAction[] anActionArray = thisCollection$iv.toArray(new AnAction[0]);
            if (anActionArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return anActionArray;
        }

        public static /* synthetic */ AnAction[] getActions$default(Companion companion, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            return companion.getActions(n);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final AnAction[] getActions() {
            return com.intellij.execution.lineMarker.ExecutorAction$Companion.getActions$default(this, 0, 1, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final List<AnAction> getActionList(int order) {
            ActionManager actionManager = ActionManager.getInstance();
            AnAction createAction2 = actionManager.getAction("CreateRunConfiguration");
            ExtensionPointName<Executor> extensionPointName = Executor.EXECUTOR_EXTENSION_NAME;
            Intrinsics.checkExpressionValueIsNotNull(extensionPointName, (String)"Executor.EXECUTOR_EXTENSION_NAME");
            List<Executor> list2 = extensionPointName.getExtensionList();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Executor.EXECUTOR_EXTENSION_NAME.extensionList");
            List<Executor> extensions2 = list2;
            ArrayList<AnAction> result2 = new ArrayList<AnAction>(extensions2.size() + (createAction2 == null ? 0 : 1));
            Iterable $this$mapNotNullTo$iv = extensions2;
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv.iterator();
            while (iterator2.hasNext()) {
                ExecutorAction executorAction;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator2.next();
                boolean bl = false;
                Executor executor = (Executor)element$iv;
                boolean bl2 = false;
                Executor executor2 = executor;
                Intrinsics.checkExpressionValueIsNotNull((Object)executor2, (String)"executor");
                if (actionManager.getAction(executor2.getContextActionId()) != null) {
                    AnAction anAction;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    AnAction it = anAction;
                    boolean bl5 = false;
                    executorAction = new ExecutorAction(it, executor, order, null);
                } else {
                    executorAction = null;
                }
                if (executorAction == null) continue;
                ExecutorAction executorAction2 = executorAction;
                boolean bl6 = false;
                boolean bl7 = false;
                ExecutorAction it$iv = executorAction2;
                boolean bl8 = false;
                ((Collection)result2).add(it$iv);
            }
            if (createAction2 != null) {
                result2.add(createAction2);
            }
            return result2;
        }

        public static /* synthetic */ List getActionList$default(Companion companion, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            return companion.getActionList(n);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final List<AnAction> getActionList() {
            return com.intellij.execution.lineMarker.ExecutorAction$Companion.getActionList$default(this, 0, 1, null);
        }

        private final List<ConfigurationFromContext> getConfigurations(DataContext dataContext) {
            List<ConfigurationFromContext> result2 = (List<ConfigurationFromContext>)DataManager.getInstance().loadFromDataContext(dataContext, ExecutorActionKt.access$getCONFIGURATION_CACHE$p());
            if (result2 == null) {
                result2 = this.computeConfigurations(dataContext);
                DataManager.getInstance().saveInDataContext(dataContext, ExecutorActionKt.access$getCONFIGURATION_CACHE$p(), result2);
            }
            return result2;
        }

        private final List<ConfigurationFromContext> computeConfigurations(DataContext dataContext) {
            ConfigurationContext configurationContext = ConfigurationContext.getFromContext(dataContext);
            Intrinsics.checkExpressionValueIsNotNull((Object)configurationContext, (String)"ConfigurationContext.getFromContext(dataContext)");
            ConfigurationContext originalContext = configurationContext;
            List<ConfigurationFromContext> list2 = originalContext.getConfigurationsFromContext();
            if (list2 == null) {
                return CollectionsKt.emptyList();
            }
            return list2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

