/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.lineMarker;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.lineMarker.LineMarkerActionWrapper;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.editor.markup.MarkupEditorFilterFactory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunLineMarkerProvider
extends LineMarkerProviderDescriptor {
    private static final Comparator<RunLineMarkerContributor.Info> COMPARATOR = (a, b) -> {
        if (b.shouldReplace((RunLineMarkerContributor.Info)a)) {
            return 1;
        }
        if (a.shouldReplace((RunLineMarkerContributor.Info)b)) {
            return -1;
        }
        return 0;
    };
    private static final Key<Boolean> HAS_ANYTHING_RUNNABLE = Key.create("HAS_ANYTHING_RUNNABLE");

    @Override
    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element2) {
        RunLineMarkerContributor.Info info2;
        if (element2 == null) {
            RunLineMarkerProvider.$$$reportNull$$$0(0);
        }
        List<RunLineMarkerContributor> contributors = RunLineMarkerContributor.EXTENSION.allForLanguageOrAny(element2.getLanguage());
        Icon icon2 = null;
        SmartList<RunLineMarkerContributor.Info> infos = null;
        for (RunLineMarkerContributor contributor : contributors) {
            info2 = contributor.getInfo(element2);
            if (info2 == null) continue;
            if (icon2 == null) {
                icon2 = info2.icon;
            }
            if (infos == null) {
                infos = new SmartList<RunLineMarkerContributor.Info>();
            }
            infos.add(info2);
        }
        if (icon2 == null) {
            return null;
        }
        if (infos.size() > 1) {
            Collections.sort(infos, COMPARATOR);
            RunLineMarkerContributor.Info first = (RunLineMarkerContributor.Info)infos.get(0);
            Iterator it = infos.iterator();
            while (it.hasNext()) {
                info2 = (RunLineMarkerContributor.Info)it.next();
                if (info2 == first || !first.shouldReplace(info2)) continue;
                it.remove();
            }
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        for (RunLineMarkerContributor.Info info2 : infos) {
            for (AnAction action2 : info2.actions) {
                actionGroup.add(new LineMarkerActionWrapper(element2, action2));
            }
            if (info2 == infos.get(infos.size() - 1)) continue;
            actionGroup.add(new Separator());
        }
        SmartList<RunLineMarkerContributor.Info> finalInfos = infos;
        Function<PsiElement, String> tooltipProvider = element1 -> {
            StringBuilder tooltip = new StringBuilder();
            for (RunLineMarkerContributor.Info info : finalInfos) {
                String string;
                if (info.tooltipProvider == null || (string = info.tooltipProvider.apply((PsiElement)element1)) == null) continue;
                if (tooltip.length() != 0) {
                    tooltip.append("\n");
                }
                tooltip.append(string);
            }
            return tooltip.length() == 0 ? null : tooltip.toString();
        };
        return new RunLineMarkerInfo(element2, icon2, tooltipProvider, actionGroup);
    }

    @Override
    @NotNull
    public String getName() {
        String string = ExecutionBundle.message("run.line.marker.name", new Object[0]);
        if (string == null) {
            RunLineMarkerProvider.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return AllIcons.RunConfigurations.TestState.Run;
    }

    @NotNull
    public static ThreeState hadAnythingRunnable(@NotNull VirtualFile file2) {
        Boolean data2;
        if (file2 == null) {
            RunLineMarkerProvider.$$$reportNull$$$0(2);
        }
        ThreeState threeState = (data2 = file2.getUserData(HAS_ANYTHING_RUNNABLE)) == null ? ThreeState.UNSURE : ThreeState.fromBoolean(data2);
        if (threeState == null) {
            RunLineMarkerProvider.$$$reportNull$$$0(3);
        }
        return threeState;
    }

    public static void markRunnable(@NotNull VirtualFile file2, boolean isRunnable) {
        if (file2 == null) {
            RunLineMarkerProvider.$$$reportNull$$$0(4);
        }
        file2.putUserData(HAS_ANYTHING_RUNNABLE, isRunnable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/lineMarker/RunLineMarkerProvider";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/lineMarker/RunLineMarkerProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "hadAnythingRunnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hadAnythingRunnable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "markRunnable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class RunLineMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        private final DefaultActionGroup myActionGroup;

        RunLineMarkerInfo(PsiElement element2, Icon icon2, Function<PsiElement, String> tooltipProvider, DefaultActionGroup actionGroup) {
            super(element2, element2.getTextRange(), icon2, 11, tooltipProvider, null, GutterIconRenderer.Alignment.CENTER);
            this.myActionGroup = actionGroup;
        }

        @Override
        public GutterIconRenderer createGutterRenderer() {
            return new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>((LineMarkerInfo)this){

                @Override
                public AnAction getClickAction() {
                    return null;
                }

                @Override
                public boolean isNavigateAction() {
                    return true;
                }

                @Override
                public ActionGroup getPopupMenuActions() {
                    return myActionGroup;
                }
            };
        }

        @Override
        @NotNull
        public MarkupEditorFilter getEditorFilter() {
            MarkupEditorFilter markupEditorFilter = MarkupEditorFilterFactory.createIsNotDiffFilter();
            if (markupEditorFilter == null) {
                RunLineMarkerInfo.$$$reportNull$$$0(0);
            }
            return markupEditorFilter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/lineMarker/RunLineMarkerProvider$RunLineMarkerInfo", "getEditorFilter"));
        }
    }
}

