/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.RunnerMediator;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.remote.RemoteProcess;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KillableProcessHandler
extends OSProcessHandler
implements KillableProcess {
    private static final Logger LOG = Logger.getInstance(KillableProcessHandler.class);
    private static final Key<Boolean> MEDIATOR_KEY = Key.create("KillableProcessHandler.Mediator.Process");
    private boolean myShouldKillProcessSoftly;
    private final boolean myMediatedProcess;
    private boolean myShouldKillProcessSoftlyWithWinP;

    public KillableProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            KillableProcessHandler.$$$reportNull$$$0(0);
        }
        super(commandLine);
        this.myShouldKillProcessSoftly = true;
        this.myShouldKillProcessSoftlyWithWinP = SystemInfo.isWin10OrNewer && Registry.is("use.winp.for.graceful.process.termination");
        this.myMediatedProcess = MEDIATOR_KEY.get((UserDataHolder)commandLine) == Boolean.TRUE;
    }

    public KillableProcessHandler(@NotNull GeneralCommandLine commandLine, boolean withMediator) throws ExecutionException {
        if (commandLine == null) {
            KillableProcessHandler.$$$reportNull$$$0(1);
        }
        this(KillableProcessHandler.mediate(commandLine, withMediator, false));
    }

    public KillableProcessHandler(@NotNull Process process2, String commandLine) {
        if (process2 == null) {
            KillableProcessHandler.$$$reportNull$$$0(2);
        }
        super(process2, commandLine);
        this.myShouldKillProcessSoftly = true;
        this.myShouldKillProcessSoftlyWithWinP = SystemInfo.isWin10OrNewer && Registry.is("use.winp.for.graceful.process.termination");
        this.myMediatedProcess = false;
    }

    public KillableProcessHandler(@NotNull Process process2, String commandLine, @NotNull Charset charset) {
        if (process2 == null) {
            KillableProcessHandler.$$$reportNull$$$0(3);
        }
        if (charset == null) {
            KillableProcessHandler.$$$reportNull$$$0(4);
        }
        this(process2, commandLine, charset, null);
    }

    public KillableProcessHandler(@NotNull Process process2, String commandLine, @NotNull Charset charset, @Nullable Set<File> filesToDelete) {
        if (process2 == null) {
            KillableProcessHandler.$$$reportNull$$$0(5);
        }
        if (charset == null) {
            KillableProcessHandler.$$$reportNull$$$0(6);
        }
        super(process2, commandLine, charset, filesToDelete);
        this.myShouldKillProcessSoftly = true;
        this.myShouldKillProcessSoftlyWithWinP = SystemInfo.isWin10OrNewer && Registry.is("use.winp.for.graceful.process.termination");
        this.myMediatedProcess = false;
    }

    @NotNull
    protected static GeneralCommandLine mediate(@NotNull GeneralCommandLine commandLine, boolean withMediator, boolean showConsole) {
        if (commandLine == null) {
            KillableProcessHandler.$$$reportNull$$$0(7);
        }
        if (withMediator && SystemInfo.isWindows && MEDIATOR_KEY.get((UserDataHolder)commandLine) == null) {
            boolean mediatorInjected = RunnerMediator.injectRunnerCommand(commandLine, showConsole);
            MEDIATOR_KEY.set((UserDataHolder)commandLine, (Boolean)mediatorInjected);
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            KillableProcessHandler.$$$reportNull$$$0(8);
        }
        return generalCommandLine;
    }

    public boolean shouldKillProcessSoftly() {
        return this.myShouldKillProcessSoftly;
    }

    public void setShouldKillProcessSoftly(boolean shouldKillProcessSoftly) {
        this.myShouldKillProcessSoftly = shouldKillProcessSoftly;
    }

    private boolean canKillProcessSoftly() {
        if (KillableProcessHandler.processCanBeKilledByOS((Process)this.myProcess)) {
            if (SystemInfo.isWindows) {
                return this.myMediatedProcess || this.myShouldKillProcessSoftlyWithWinP;
            }
            if (SystemInfo.isUnix) {
                return true;
            }
        }
        return false;
    }

    protected void destroyProcessImpl() {
        try {
            this.myProcess.getOutputStream().flush();
        }
        catch (IOException e) {
            LOG.warn(e);
        }
        finally {
            this.doDestroyProcess();
        }
    }

    protected void notifyProcessTerminated(int exitCode) {
        try {
            super.closeStreams();
        }
        finally {
            super.notifyProcessTerminated(exitCode);
        }
    }

    protected void doDestroyProcess() {
        boolean gracefulTerminationAttempted;
        boolean bl = gracefulTerminationAttempted = this.shouldKillProcessSoftly() && this.canKillProcessSoftly() && this.destroyProcessGracefully();
        if (!gracefulTerminationAttempted) {
            super.doDestroyProcess();
        }
    }

    @ApiStatus.Experimental
    public void setShouldKillProcessSoftlyWithWinP(boolean shouldKillProcessSoftlyWithWinP) {
        this.myShouldKillProcessSoftlyWithWinP = shouldKillProcessSoftlyWithWinP;
    }

    protected boolean destroyProcessGracefully() {
        if (SystemInfo.isWindows) {
            if (this.myMediatedProcess) {
                return RunnerMediator.destroyProcess(this.myProcess, true);
            }
            if (this.myShouldKillProcessSoftlyWithWinP && !Registry.is("disable.winp")) {
                try {
                    if (!this.myProcess.isAlive()) {
                        OSProcessUtil.logSkippedActionWithTerminatedProcess((Process)this.myProcess, (String)"destroy", (String)this.getCommandLine());
                        return true;
                    }
                    return OSProcessUtil.createWinProcess((Process)this.myProcess).sendCtrlC();
                }
                catch (Throwable e) {
                    if (!this.myProcess.isAlive()) {
                        OSProcessUtil.logSkippedActionWithTerminatedProcess((Process)this.myProcess, (String)"destroy", (String)this.getCommandLine());
                        return true;
                    }
                    LOG.error("Failed to send Ctrl+C, fallback to default termination: " + this.getCommandLine(), e);
                }
            }
        } else if (SystemInfo.isUnix) {
            return UnixProcessManager.sendSigIntToProcessTree(this.myProcess);
        }
        return false;
    }

    @Override
    public boolean canKillProcess() {
        return KillableProcessHandler.processCanBeKilledByOS((Process)this.getProcess()) || this.getProcess() instanceof RemoteProcess;
    }

    @Override
    public void killProcess() {
        if (KillableProcessHandler.processCanBeKilledByOS((Process)this.getProcess())) {
            this.killProcessTree(this.getProcess());
        } else if (this.getProcess() instanceof RemoteProcess) {
            ((RemoteProcess)this.getProcess()).killProcessTree();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/KillableProcessHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/KillableProcessHandler";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "mediate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mediate";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

