/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.Platform;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.StatusBar;
import org.jetbrains.annotations.NotNull;

public class ProcessTerminatedListener
extends ProcessAdapter {
    protected static final String EXIT_CODE_ENTRY = "$EXIT_CODE$";
    protected static final String EXIT_CODE_REGEX = "\\$EXIT_CODE\\$";
    private static final Key<ProcessTerminatedListener> KEY = new Key("processTerminatedListener");
    private final String myProcessFinishedMessage;
    private final Project myProject;

    private ProcessTerminatedListener(Project project2, String processFinishedMessage) {
        this.myProject = project2;
        this.myProcessFinishedMessage = processFinishedMessage;
    }

    public static void attach(ProcessHandler processHandler2, Project project2, String message) {
        ProcessTerminatedListener previousListener = processHandler2.getUserData(KEY);
        if (previousListener != null) {
            processHandler2.removeProcessListener(previousListener);
            if (project2 == null) {
                project2 = previousListener.myProject;
            }
        }
        ProcessTerminatedListener listener2 = new ProcessTerminatedListener(project2, message);
        processHandler2.addProcessListener(listener2);
        processHandler2.putUserData(KEY, listener2);
    }

    public static void attach(ProcessHandler processHandler2, Project project2) {
        String message = IdeBundle.message("finished.with.exit.code.text.message", EXIT_CODE_ENTRY);
        ProcessTerminatedListener.attach(processHandler2, project2, "\n" + message + "\n");
    }

    public static void attach(ProcessHandler processHandler2) {
        ProcessTerminatedListener.attach(processHandler2, null);
    }

    @Override
    public void processTerminated(@NotNull ProcessEvent event) {
        if (event == null) {
            ProcessTerminatedListener.$$$reportNull$$$0(0);
        }
        ProcessHandler processHandler2 = event.getProcessHandler();
        processHandler2.removeProcessListener(this);
        String message = this.myProcessFinishedMessage.replaceAll(EXIT_CODE_REGEX, ProcessTerminatedListener.stringifyExitCode(Platform.current(), event.getExitCode()));
        processHandler2.notifyTextAvailable(message, ProcessOutputTypes.SYSTEM);
        if (this.myProject != null) {
            ApplicationManager.getApplication().invokeLater(() -> StatusBar.Info.set(message, this.myProject), this.myProject.getDisposed());
        }
    }

    @NotNull
    public static String stringifyExitCode(@NotNull Platform platform, int exitCode) {
        if (platform == null) {
            ProcessTerminatedListener.$$$reportNull$$$0(1);
        }
        StringBuilder result2 = new StringBuilder();
        result2.append(exitCode);
        if (platform == Platform.WINDOWS && exitCode >= -1073741824 && exitCode < -805306368) {
            result2.append(" (0x").append(StringUtil.toUpperCase(Integer.toHexString(exitCode)));
            if (exitCode == -1073741510) {
                result2.append(": interrupted by Ctrl+C");
            }
            result2.append(')');
        } else if (platform == Platform.UNIX && exitCode >= 129 && exitCode <= 159) {
            String[] signals = new String[]{"HUP", "INT", "QUIT", "ILL", "TRAP", "ABRT", "EMT", "FPE", "KILL", "BUS", "SEGV", "SYS", "PIPE", "ALRM", "TERM", "URG", "STOP", "TSTP", "CONT", "CHLD", "TTIN", "TTOU", "IO", "XCPU", "XFSZ", "VTALRM", "PROF", "WINCH", "INFO", "USR1", "USR2"};
            int signal = exitCode - 128;
            result2.append(" (interrupted by signal ").append(signal).append(": SIG").append(signals[signal - 1]).append(')');
        }
        String string = result2.toString();
        if (string == null) {
            ProcessTerminatedListener.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platform";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/ProcessTerminatedListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/ProcessTerminatedListener";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "stringifyExitCode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processTerminated";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "stringifyExitCode";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

