/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.sun.jna.Platform;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunnerMediator {
    private static final Logger LOG = Logger.getInstance(RunnerMediator.class);
    private static final char IAC = '\u0005';
    private static final char BRK = '\u0003';
    private static final char C = '\u0005';
    private static final String RUNNERW = "runnerw.exe";
    private static final String RUNNERW_64 = "runnerw64.exe";
    private static final String IDEA_RUNNERW = "IDEA_RUNNERW";

    public static RunnerMediator getInstance() {
        return new RunnerMediator();
    }

    private static void sendCtrlEventThroughStream(@NotNull Process process2, char event) {
        if (process2 == null) {
            RunnerMediator.$$$reportNull$$$0(0);
        }
        OutputStream os = process2.getOutputStream();
        PrintWriter pw = new PrintWriter(os);
        pw.print('\u0005');
        pw.print(event);
        pw.flush();
    }

    @NotNull
    public ProcessHandler createProcess(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            RunnerMediator.$$$reportNull$$$0(1);
        }
        return new KillableColoredProcessHandler(commandLine, true){

            @Override
            protected boolean destroyProcessGracefully() {
                if (SystemInfo.isWindows) {
                    return RunnerMediator.destroyProcess(this.myProcess, false);
                }
                return super.destroyProcessGracefully();
            }
        };
    }

    @Nullable
    private static String getRunnerPath() {
        String[] names2;
        String[] stringArray;
        if (!SystemInfo.isWindows) {
            throw new IllegalStateException("There is no need of runner under unix based OS");
        }
        String path2 = System.getenv(IDEA_RUNNERW);
        if (path2 != null) {
            if (new File(path2).exists()) {
                return path2;
            }
            LOG.warn("Cannot locate runnerw.exe by IDEA_RUNNERW=" + path2);
        }
        if (Platform.is64Bit()) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = RUNNERW_64;
            stringArray = stringArray2;
            stringArray2[1] = RUNNERW;
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = RUNNERW;
        }
        for (String name : names2 = stringArray) {
            File runnerw = PathManager.findBinFile(name);
            if (runnerw == null || !runnerw.exists()) continue;
            return runnerw.getPath();
        }
        LOG.warn("Cannot locate runnerw.exe in " + PathManager.getBinPath());
        return null;
    }

    static boolean injectRunnerCommand(@NotNull GeneralCommandLine commandLine, boolean showConsole) {
        String path2;
        if (commandLine == null) {
            RunnerMediator.$$$reportNull$$$0(2);
        }
        if ((path2 = RunnerMediator.getRunnerPath()) != null) {
            commandLine.getParametersList().addAt(0, commandLine.getExePath());
            if (showConsole) {
                commandLine.getParametersList().addAt(0, "/C");
            }
            commandLine.setExePath(path2);
            return true;
        }
        return false;
    }

    public static boolean destroyProcess(@NotNull Process process2) {
        if (process2 == null) {
            RunnerMediator.$$$reportNull$$$0(3);
        }
        return RunnerMediator.destroyProcess(process2, false);
    }

    static boolean destroyProcess(@NotNull Process process2, boolean softKill) {
        if (process2 == null) {
            RunnerMediator.$$$reportNull$$$0(4);
        }
        try {
            if (SystemInfo.isWindows) {
                RunnerMediator.sendCtrlEventThroughStream(process2, softKill ? (char)'\u0005' : '\u0003');
                return true;
            }
            if (SystemInfo.isUnix) {
                if (softKill) {
                    return UnixProcessManager.sendSigIntToProcessTree(process2);
                }
                return UnixProcessManager.sendSigKillToProcessTree(process2);
            }
            return false;
        }
        catch (Exception e) {
            LOG.error("Couldn't terminate the process", e);
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/process/RunnerMediator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "sendCtrlEventThroughStream";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createProcess";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "injectRunnerCommand";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "destroyProcess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

