/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi;

import com.intellij.execution.rmi.RemoteObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.concurrent.atomic.AtomicLong;

public interface RemoteDeadHand
extends Remote {
    public static final String BINDING_NAME = "_DEAD_HAND_";
    public static final long PING_TIMEOUT = 20000L;

    public long ping(String var1) throws RemoteException;

    public static class TwoMinutesTurkish
    extends RemoteObject
    implements RemoteDeadHand {
        private static final TwoMinutesTurkish ourCook;
        private static final Remote ourHand;
        private static final AtomicLong ourAskedThatManyTimes;

        public long ping(String id2) throws RemoteException {
            ourAskedThatManyTimes.incrementAndGet();
            return 20000L;
        }

        public static void startCooking(String host, int port) throws Exception {
            Registry registry = LocateRegistry.getRegistry(host, port);
            registry.bind(RemoteDeadHand.BINDING_NAME, ourHand);
        }

        static {
            Remote remote;
            ourCook = new TwoMinutesTurkish();
            ourAskedThatManyTimes = new AtomicLong();
            try {
                remote = UnicastRemoteObject.exportObject((Remote)ourCook, 0);
            }
            catch (RemoteException e) {
                throw new IllegalStateException(e);
            }
            ourHand = remote;
        }
    }
}

