/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi;

import java.lang.ref.WeakReference;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.server.Unreferenced;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteObject
implements Remote,
Unreferenced {
    private final WeakReference<RemoteObject> myWeakRef;
    private RemoteObject myParent;
    private final Map<RemoteObject, Remote> myChildren = new ConcurrentHashMap<RemoteObject, Remote>();

    public RemoteObject() {
        this.myWeakRef = new WeakReference<RemoteObject>(this);
    }

    public WeakReference<RemoteObject> getWeakRef() {
        return this.myWeakRef;
    }

    @Contract(value="!null->!null")
    public synchronized <T extends Remote> T export(@Nullable T child2) throws RemoteException {
        if (child2 == null) {
            return null;
        }
        Remote result2 = UnicastRemoteObject.exportObject(child2, 0);
        this.myChildren.put((RemoteObject)child2, result2);
        ((RemoteObject)child2).myParent = this;
        return (T)result2;
    }

    @Contract(value="!null->!null")
    public <T extends Remote> T export2(@Nullable T child2) throws RemoteException {
        return this.export(child2);
    }

    public synchronized void unexportChildren() throws RemoteException {
        ArrayList<RemoteObject> childrenRefs = new ArrayList<RemoteObject>(this.myChildren.keySet());
        this.myChildren.clear();
        for (RemoteObject child2 : childrenRefs) {
            child2.unreferenced();
        }
    }

    public synchronized void unexportChildren(@NotNull Collection<? extends WeakReference<RemoteObject>> children2) throws RemoteException {
        if (children2 == null) {
            RemoteObject.$$$reportNull$$$0(0);
        }
        if (children2.isEmpty()) {
            return;
        }
        ArrayList<RemoteObject> list2 = new ArrayList<RemoteObject>(children2.size());
        for (WeakReference<RemoteObject> weakReference : children2) {
            RemoteObject element2 = (RemoteObject)weakReference.get();
            if (element2 == null) continue;
            list2.add(element2);
        }
        this.myChildren.keySet().removeAll(list2);
        for (RemoteObject remoteObject : list2) {
            remoteObject.unreferenced();
        }
    }

    @Override
    public synchronized void unreferenced() {
        if (this.myParent != null) {
            this.myParent.myChildren.remove(this);
            this.myParent = null;
            try {
                this.unexportChildren();
                UnicastRemoteObject.unexportObject(this, false);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    public Throwable wrapException(Throwable ex) {
        boolean foreignException = false;
        for (Throwable each = ex; each != null; each = each.getCause()) {
            if (each.getClass().getName().startsWith("java.") || this.isKnownException(each)) continue;
            foreignException = true;
            break;
        }
        if (foreignException) {
            RuntimeException wrapper2 = new RuntimeException(ex.toString());
            wrapper2.setStackTrace(ex.getStackTrace());
            wrapper2.initCause(this.wrapException(ex.getCause()));
            ex = wrapper2;
        }
        return ex;
    }

    protected boolean isKnownException(Throwable ex) {
        return false;
    }

    protected Iterable<RemoteObject> getExportedChildren() {
        return this.myChildren.keySet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/execution/rmi/RemoteObject", "unexportChildren"));
    }
}

