/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.rmi.RemoteDeadHand;
import com.intellij.execution.rmi.RemoteServer;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.execution.runners.DefaultProgramRunnerKt;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RemoteProcessSupport<Target, EntryPoint, Parameters> {
    public static final Logger LOG = Logger.getInstance(RemoteProcessSupport.class);
    private final Class<EntryPoint> myValueClass;
    private final HashMap<Pair<Target, Parameters>, Info> myProcMap;

    public RemoteProcessSupport(@NotNull Class<EntryPoint> valueClass) {
        if (valueClass == null) {
            RemoteProcessSupport.$$$reportNull$$$0(0);
        }
        this.myProcMap = new HashMap();
        this.myValueClass = valueClass;
    }

    protected abstract void fireModificationCountChanged();

    protected abstract String getName(@NotNull Target var1);

    protected void logText(@NotNull Parameters configuration, @NotNull ProcessEvent event, @NotNull Key outputType) {
        if (configuration == null) {
            RemoteProcessSupport.$$$reportNull$$$0(1);
        }
        if (event == null) {
            RemoteProcessSupport.$$$reportNull$$$0(2);
        }
        if (outputType == null) {
            RemoteProcessSupport.$$$reportNull$$$0(3);
        }
        String text2 = StringUtil.notNullize(event.getText());
        if (outputType == ProcessOutputTypes.STDERR) {
            LOG.warn(text2.trim());
        } else {
            LOG.debug(text2.trim());
        }
    }

    public void stopAll() {
        this.stopAll(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAll(boolean wait) {
        ArrayList<Info> infos = new ArrayList<Info>();
        HashMap<Pair<Target, Parameters>, Info> hashMap = this.myProcMap;
        synchronized (hashMap) {
            for (Info o : this.myProcMap.values()) {
                if (o.handler == null) continue;
                infos.add(o);
            }
        }
        if (infos.isEmpty()) {
            return;
        }
        Future<?> future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> {
            RemoteProcessSupport.destroyProcessesImpl(infos);
            if (wait) {
                for (Info o : infos) {
                    o.handler.waitFor();
                }
            }
        });
        if (wait) {
            try {
                future2.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (java.util.concurrent.ExecutionException e) {
                LOG.warn(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Parameters> getActiveConfigurations(@NotNull Target target2) {
        if (target2 == null) {
            RemoteProcessSupport.$$$reportNull$$$0(4);
        }
        ArrayList result2 = new ArrayList();
        HashMap<Pair<Target, Parameters>, Info> hashMap = this.myProcMap;
        synchronized (hashMap) {
            for (Pair<Target, Parameters> pair : this.myProcMap.keySet()) {
                if (pair.first != target2) continue;
                result2.add(pair.second);
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Pair<Target, Parameters>> getActiveConfigurations() {
        HashMap<Pair<Target, Parameters>, Info> hashMap = this.myProcMap;
        synchronized (hashMap) {
            return new HashSet<Pair<Target, Parameters>>(this.myProcMap.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryPoint acquire(@NotNull Target target2, @NotNull Parameters configuration) throws Exception {
        RunningInfo info;
        if (target2 == null) {
            RemoteProcessSupport.$$$reportNull$$$0(5);
        }
        if (configuration == null) {
            RemoteProcessSupport.$$$reportNull$$$0(6);
        }
        ApplicationManagerEx.getApplicationEx().assertTimeConsuming();
        Ref<Object> ref = Ref.create(null);
        Pair<Target, Parameters> key = Pair.create(target2, configuration);
        if (!this.getExistingInfo(ref, key)) {
            this.startProcess(target2, configuration, key);
            if (ref.isNull()) {
                try {
                    Ref<Object> ref2 = ref;
                    synchronized (ref2) {
                        while (ref.isNull()) {
                            ref.wait(1000L);
                            ProgressManager.checkCanceled();
                        }
                    }
                }
                catch (InterruptedException e) {
                    ProgressManager.checkCanceled();
                }
            }
        }
        if ((info = (RunningInfo)ref.get()) instanceof FailedInfo) {
            FailedInfo o = (FailedInfo)info;
            String message = o.cause != null && StringUtil.isEmptyOrSpaces(o.stderr) ? o.cause.getMessage() : o.stderr;
            throw new ExecutionException(message, o.cause);
        }
        if (info == null || info.handler == null) {
            throw new ExecutionException("Unable to acquire remote proxy for: " + this.getName(target2));
        }
        return this.acquire(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Future<?> release(@NotNull Target target2, @Nullable Parameters configuration) {
        if (target2 == null) {
            RemoteProcessSupport.$$$reportNull$$$0(7);
        }
        ArrayList<Info> infos = new ArrayList<Info>();
        HashMap<Pair<Target, Parameters>, Info> hashMap = this.myProcMap;
        synchronized (hashMap) {
            for (Pair<Target, Parameters> key : this.myProcMap.keySet()) {
                if (key.first != target2 || configuration != null && key.second != configuration) continue;
                Info o = this.myProcMap.get(key);
                if (o.handler == null) continue;
                infos.add(o);
            }
        }
        Future<Object> future2 = infos.isEmpty() ? CompletableFuture.completedFuture(null) : ApplicationManager.getApplication().executeOnPooledThread(() -> {
            RemoteProcessSupport.destroyProcessesImpl(infos);
            this.fireModificationCountChanged();
            for (Info o : infos) {
                o.handler.waitFor();
            }
        });
        if (future2 == null) {
            RemoteProcessSupport.$$$reportNull$$$0(8);
        }
        return future2;
    }

    private static void destroyProcessesImpl(@NotNull List<Info> infos) {
        if (infos == null) {
            RemoteProcessSupport.$$$reportNull$$$0(9);
        }
        for (Info o : infos) {
            LOG.info("Terminating: " + o);
            o.handler.destroyProcess();
        }
    }

    private void startProcess(@NotNull Target target2, @NotNull Parameters configuration, @NotNull Pair<Target, Parameters> key) {
        ProcessHandler processHandler2;
        if (target2 == null) {
            RemoteProcessSupport.$$$reportNull$$$0(10);
        }
        if (configuration == null) {
            RemoteProcessSupport.$$$reportNull$$$0(11);
        }
        if (key == null) {
            RemoteProcessSupport.$$$reportNull$$$0(12);
        }
        ProgramRunner<RunnerSettings> runner = new ProgramRunner<RunnerSettings>(){

            @Override
            @NotNull
            public String getRunnerId() {
                return "MyRunner";
            }

            @Override
            public void execute(@NotNull ExecutionEnvironment environment2) throws ExecutionException {
                if (environment2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                ExecutionManager.getInstance(environment2.getProject()).startRunProfile(environment2, state -> DefaultProgramRunnerKt.executeState(state, environment2, this));
            }

            @Override
            public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
                if (executorId == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (profile == null) {
                    1.$$$reportNull$$$0(2);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "environment";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executorId";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "profile";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/execution/rmi/RemoteProcessSupport$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "execute";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "canRun";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        try {
            RunProfileState state = this.getRunProfileState(target2, configuration, executor);
            ExecutionResult result2 = state.execute(executor, runner);
            processHandler2 = result2.getProcessHandler();
        }
        catch (Throwable e) {
            this.dropProcessInfo(key, e, null);
            return;
        }
        processHandler2.addProcessListener(this.getProcessListener(key));
        processHandler2.startNotify();
    }

    protected abstract RunProfileState getRunProfileState(@NotNull Target var1, @NotNull Parameters var2, @NotNull Executor var3) throws ExecutionException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getExistingInfo(@NotNull Ref<RunningInfo> ref, @NotNull Pair<Target, Parameters> key) {
        Info info;
        if (ref == null) {
            RemoteProcessSupport.$$$reportNull$$$0(13);
        }
        if (key == null) {
            RemoteProcessSupport.$$$reportNull$$$0(14);
        }
        Object object = this.myProcMap;
        synchronized (object) {
            info = this.myProcMap.get(key);
            try {
                while (info != null && (!(info instanceof RunningInfo) || info.handler.isProcessTerminating() || info.handler.isProcessTerminated())) {
                    this.myProcMap.wait(1000L);
                    ProgressManager.checkCanceled();
                    info = this.myProcMap.get(key);
                }
            }
            catch (InterruptedException e) {
                ProgressManager.checkCanceled();
            }
            if (info == null) {
                this.myProcMap.put(key, new PendingInfo(ref, null));
            }
        }
        if (info instanceof RunningInfo) {
            object = ref;
            synchronized (object) {
                ref.set((RunningInfo)info);
                ref.notifyAll();
            }
        }
        return info != null;
    }

    private EntryPoint acquire(RunningInfo port) throws Exception {
        Object result2;
        port.entryPointHardRef = result2 = RemoteUtil.executeWithClassLoader(() -> {
            Registry registry = LocateRegistry.getRegistry(RemoteProcessSupport.getLocalHost(), port.port);
            Remote remote = Objects.requireNonNull(registry.lookup(port.name));
            if (this.myValueClass.isInstance(remote)) {
                EntryPoint entryPoint = this.myValueClass.cast(remote);
                return RemoteUtil.substituteClassLoader(entryPoint, this.myValueClass.getClassLoader());
            }
            return RemoteUtil.castToLocal(remote, this.myValueClass);
        }, this.getClass().getClassLoader());
        return (EntryPoint)result2;
    }

    private ProcessListener getProcessListener(final @NotNull Pair<Target, Parameters> key) {
        if (key == null) {
            RemoteProcessSupport.$$$reportNull$$$0(15);
        }
        return new ProcessListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                ProcessHandler processHandler2 = event.getProcessHandler();
                processHandler2.putUserData(ProcessHandler.SILENTLY_DESTROY_ON_CLOSE, Boolean.TRUE);
                HashMap hashMap = RemoteProcessSupport.this.myProcMap;
                synchronized (hashMap) {
                    Info o = (Info)RemoteProcessSupport.this.myProcMap.get(key);
                    if (o instanceof PendingInfo) {
                        RemoteProcessSupport.this.myProcMap.put(key, new PendingInfo(((PendingInfo)o).ref, processHandler2));
                    }
                }
                RemoteProcessSupport.this.sendDataAfterStart(processHandler2);
            }

            @Override
            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (RemoteProcessSupport.this.dropProcessInfo(key, null, event.getProcessHandler())) {
                    RemoteProcessSupport.this.fireModificationCountChanged();
                    RemoteProcessSupport.this.onProcessTerminated(event);
                }
            }

            @Override
            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                if (event == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (RemoteProcessSupport.this.dropProcessInfo(key, null, event.getProcessHandler())) {
                    RemoteProcessSupport.this.fireModificationCountChanged();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                PendingInfo info;
                if (event == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (outputType == null) {
                    2.$$$reportNull$$$0(4);
                }
                String text2 = StringUtil.notNullize(event.getText());
                RemoteProcessSupport.this.logText(key.second, event, outputType);
                RunningInfo result2 = null;
                Object object = RemoteProcessSupport.this.myProcMap;
                synchronized (object) {
                    Info o = (Info)RemoteProcessSupport.this.myProcMap.get(key);
                    if (o instanceof PendingInfo) {
                        info = (PendingInfo)o;
                        if (outputType == ProcessOutputTypes.STDOUT) {
                            String prefix = "Port/ID:";
                            if (text2.startsWith(prefix)) {
                                String pair = text2.substring(prefix.length()).trim();
                                int idx = pair.indexOf("/");
                                result2 = new RunningInfo(info.handler, Integer.parseInt(pair.substring(0, idx)), pair.substring(idx + 1));
                                RemoteProcessSupport.this.myProcMap.put(key, result2);
                                RemoteProcessSupport.this.myProcMap.notifyAll();
                            }
                        } else if (outputType == ProcessOutputTypes.STDERR) {
                            info.stderr.append(text2);
                        }
                    } else {
                        info = null;
                    }
                }
                if (result2 != null) {
                    object = info.ref;
                    synchronized (object) {
                        info.ref.set(result2);
                        info.ref.notifyAll();
                    }
                    RemoteProcessSupport.this.fireModificationCountChanged();
                    try {
                        RemoteDeadHand.TwoMinutesTurkish.startCooking(RemoteProcessSupport.getLocalHost(), result2.port);
                    }
                    catch (Throwable e) {
                        LOG.warn("The cook failed to start due to " + ExceptionUtil.getRootCause(e));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/execution/rmi/RemoteProcessSupport$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startNotified";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processWillTerminate";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    protected void onProcessTerminated(ProcessEvent event) {
    }

    protected void sendDataAfterStart(ProcessHandler handler2) {
    }

    @NotNull
    private static String getLocalHost() {
        String string = ObjectUtils.notNull(System.getProperty("java.rmi.server.hostname"), "127.0.0.1");
        if (string == null) {
            RemoteProcessSupport.$$$reportNull$$$0(16);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dropProcessInfo(Pair<Target, Parameters> key, @Nullable Throwable error, @Nullable ProcessHandler handler2) {
        Info info;
        HashMap<Pair<Target, Parameters>, Info> hashMap = this.myProcMap;
        synchronized (hashMap) {
            info = this.myProcMap.get(key);
            if (info != null && (handler2 == null || info.handler == handler2)) {
                this.myProcMap.remove(key);
                this.myProcMap.notifyAll();
            } else {
                info = null;
            }
        }
        if (info instanceof PendingInfo) {
            PendingInfo pendingInfo = (PendingInfo)info;
            if (error != null || pendingInfo.stderr.length() > 0 || pendingInfo.ref.isNull()) {
                pendingInfo.ref.set(new FailedInfo(error, pendingInfo.stderr.toString()));
            }
            Ref<RunningInfo> ref = pendingInfo.ref;
            synchronized (ref) {
                pendingInfo.ref.notifyAll();
            }
        }
        return info != null;
    }

    static {
        RemoteServer.setupRMI();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueClass";
                break;
            }
            case 1: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/rmi/RemoteProcessSupport";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/rmi/RemoteProcessSupport";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "release";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalHost";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "logText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getActiveConfigurations";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "acquire";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "release";
                break;
            }
            case 8: 
            case 16: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "destroyProcessesImpl";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "startProcess";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getExistingInfo";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getProcessListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FailedInfo
    extends RunningInfo {
        final Throwable cause;
        final String stderr;

        FailedInfo(Throwable cause, String stderr) {
            super(null, -1, null);
            this.cause = cause;
            this.stderr = stderr;
        }

        @Override
        public String toString() {
            return "FailedInfo{" + this.cause + '}';
        }
    }

    private static class RunningInfo
    extends Info {
        final int port;
        final String name;
        Object entryPointHardRef;

        RunningInfo(ProcessHandler handler2, int port, String name) {
            super(handler2);
            this.port = port;
            this.name = name;
        }

        public String toString() {
            return this.port + "/" + this.name;
        }
    }

    private static class PendingInfo
    extends Info {
        final Ref<RunningInfo> ref;
        final StringBuilder stderr = new StringBuilder();

        PendingInfo(Ref<RunningInfo> ref, ProcessHandler handler2) {
            super(handler2);
            this.ref = ref;
        }

        public String toString() {
            return "PendingInfo{" + this.ref.get() + '}';
        }
    }

    private static class Info {
        final ProcessHandler handler;

        Info(ProcessHandler handler2) {
            this.handler = handler2;
        }
    }
}

