/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi;

import com.intellij.execution.rmi.CastableArgument;
import com.intellij.execution.rmi.RemoteCastable;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentFactoryMap;
import gnu.trove.THashMap;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.Remote;
import java.rmi.ServerError;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteUtil {
    private static final ConcurrentMap<Couple<Class<?>>, Map<Method, Method>> ourRemoteToLocalMap = ConcurrentFactoryMap.createMap(key -> {
        THashMap<Method, Method> map2 = new THashMap<Method, Method>();
        for (Method method2 : ((Class)key.second).getMethods()) {
            Method m = null;
            block1: for (Method candidate : ((Class)key.first).getMethods()) {
                if (candidate.getParameterCount() != method2.getParameterCount() || !candidate.getName().equals(method2.getName())) continue;
                Class<?>[] cpts = candidate.getParameterTypes();
                Class<?>[] mpts = method2.getParameterTypes();
                for (int i = 0; i < mpts.length; ++i) {
                    Class<?> mpt = mpts[i];
                    Class<?> cpt = RemoteUtil.castArgumentClassToLocal(cpts[i]);
                    if (!cpt.isAssignableFrom(mpt)) continue block1;
                }
                m = candidate;
                break;
            }
            if (m == null) continue;
            map2.put(method2, m);
        }
        return map2;
    });

    RemoteUtil() {
    }

    @NotNull
    public static <T> T castToRemoteNotNull(Object object, Class<T> clazz) {
        T t = Objects.requireNonNull(RemoteUtil.castToRemote(object, clazz));
        if (t == null) {
            RemoteUtil.$$$reportNull$$$0(0);
        }
        return t;
    }

    @Nullable
    public static <T> T castToRemote(@Nullable Object object, @NotNull Class<T> clazz) {
        RemoteInvocationHandler rih;
        if (clazz == null) {
            RemoteUtil.$$$reportNull$$$0(1);
        }
        if (object == null || !Proxy.isProxyClass(object.getClass())) {
            return null;
        }
        if (clazz.isInstance(object)) {
            return (T)object;
        }
        InvocationHandler handler2 = Proxy.getInvocationHandler(object);
        if (handler2 instanceof RemoteInvocationHandler && clazz.isInstance((rih = (RemoteInvocationHandler)handler2).myRemote)) {
            return (T)rih.myRemote;
        }
        return null;
    }

    @NotNull
    public static <T> T castToLocal(@Nullable Object remote, @NotNull Class<T> clazz) {
        if (clazz == null) {
            RemoteUtil.$$$reportNull$$$0(2);
        }
        if (clazz.isInstance(remote)) {
            Object object = remote;
            if (object == null) {
                RemoteUtil.$$$reportNull$$$0(3);
            }
            return (T)object;
        }
        ClassLoader loader = clazz.getClassLoader();
        Object object = Proxy.newProxyInstance(loader, new Class[]{clazz}, (InvocationHandler)new RemoteInvocationHandler(remote, clazz, loader));
        if (object == null) {
            RemoteUtil.$$$reportNull$$$0(4);
        }
        return (T)object;
    }

    private static Class<?> tryFixReturnType(Object result2, Class<?> returnType, ClassLoader loader) throws Exception {
        if (returnType.isInterface()) {
            return returnType;
        }
        if (result2 instanceof RemoteCastable) {
            String className = ((RemoteCastable)result2).getCastToClassName();
            return Class.forName(className, true, loader);
        }
        return returnType;
    }

    private static Class<?> castArgumentClassToLocal(@NotNull Class<?> remote) {
        if (remote == null) {
            RemoteUtil.$$$reportNull$$$0(5);
        }
        try {
            Type[] generics;
            if (!CastableArgument.class.isAssignableFrom(remote)) {
                return remote;
            }
            for (Type generic : generics = remote.getGenericInterfaces()) {
                Type rawType;
                if (!(generic instanceof ParameterizedType) || (rawType = ((ParameterizedType)generic).getRawType()) != CastableArgument.class) continue;
                return (Class)((ParameterizedType)generic).getActualTypeArguments()[0];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return remote;
    }

    private static Object @Nullable [] fixArgs(Object @Nullable [] args, @NotNull Method method2) {
        if (method2 == null) {
            RemoteUtil.$$$reportNull$$$0(6);
        }
        if (args == null) {
            return null;
        }
        if (method2.getParameterCount() != args.length) {
            return args;
        }
        Object[] result2 = new Object[args.length];
        try {
            Class<?>[] methodArgs = method2.getParameterTypes();
            for (int i = 0; i < args.length; ++i) {
                result2[i] = RemoteUtil.fixArg(args[i], methodArgs[i]);
            }
        }
        catch (Exception e) {
            return args;
        }
        return result2;
    }

    @Nullable
    private static Object fixArg(@Nullable Object arg, @NotNull Class<?> fieldClass) {
        if (fieldClass == null) {
            RemoteUtil.$$$reportNull$$$0(7);
        }
        if (arg == null) {
            return null;
        }
        if (!fieldClass.isPrimitive() && Proxy.isProxyClass(arg.getClass())) {
            boolean isCastableArg;
            InvocationHandler handler2 = Proxy.getInvocationHandler(arg);
            RemoteInvocationHandler remoteHandler = ObjectUtils.tryCast(handler2, RemoteInvocationHandler.class);
            boolean bl = isCastableArg = remoteHandler != null && CastableArgument.class.isAssignableFrom(remoteHandler.myRemote.getClass());
            if (isCastableArg && remoteHandler.myClazz == fieldClass) {
                return remoteHandler.myRemote;
            }
        }
        return arg;
    }

    public static <T> T substituteClassLoader(final @NotNull T remote, final @Nullable ClassLoader classLoader) throws Exception {
        if (remote == null) {
            RemoteUtil.$$$reportNull$$$0(8);
        }
        return (T)RemoteUtil.executeWithClassLoader(() -> {
            Object proxy = Proxy.newProxyInstance(classLoader, remote.getClass().getInterfaces(), new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method2, Object[] args) throws Throwable {
                    return RemoteUtil.executeWithClassLoader(() -> RemoteUtil.invokeRemote(method2, method2, remote, args, classLoader, true), classLoader);
                }
            });
            return proxy;
        }, classLoader);
    }

    private static Object invokeRemote(@NotNull Method localMethod, @NotNull Method remoteMethod, @NotNull Object remoteObj, Object @Nullable [] args, @Nullable ClassLoader loader, boolean substituteClassLoader) throws Exception {
        if (localMethod == null) {
            RemoteUtil.$$$reportNull$$$0(9);
        }
        if (remoteMethod == null) {
            RemoteUtil.$$$reportNull$$$0(10);
        }
        if (remoteObj == null) {
            RemoteUtil.$$$reportNull$$$0(11);
        }
        boolean canThrowError = false;
        try {
            Object result2 = remoteMethod.invoke(remoteObj, args);
            canThrowError = true;
            return RemoteUtil.handleRemoteResult(result2, localMethod.getReturnType(), loader, substituteClassLoader);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ServerError) {
                cause = ObjectUtils.chooseNotNull(cause.getCause(), cause);
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (canThrowError && cause instanceof Error || cause instanceof LinkageError) {
                throw (Error)cause;
            }
            if (cause instanceof Exception && RemoteUtil.canThrow(cause, localMethod)) {
                throw (Exception)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static <T> T handleRemoteResult(Object value2, Class<? super T> clazz, Object requestor) throws Exception {
        return RemoteUtil.handleRemoteResult(value2, clazz, requestor.getClass().getClassLoader(), false);
    }

    private static <T> T handleRemoteResult(Object value2, Class<?> methodReturnType, ClassLoader classLoader, boolean substituteClassLoader) throws Exception {
        Object result2;
        if (value2 instanceof Remote) {
            result2 = value2 instanceof RemoteCastable ? RemoteUtil.castToLocal(value2, RemoteUtil.tryFixReturnType(value2, methodReturnType, classLoader)) : (substituteClassLoader ? RemoteUtil.substituteClassLoader(value2, classLoader) : value2);
        } else if (value2 instanceof List && methodReturnType.isInterface()) {
            result2 = Arrays.asList((Object[])RemoteUtil.handleRemoteResult(((List)value2).toArray(), Object.class, classLoader, substituteClassLoader));
        } else if (value2 instanceof Object[]) {
            Object[] array = (Object[])value2;
            for (int i = 0; i < array.length; ++i) {
                array[i] = RemoteUtil.handleRemoteResult(array[i], Object.class, classLoader, substituteClassLoader);
            }
            result2 = array;
        } else {
            result2 = value2;
        }
        return (T)result2;
    }

    private static boolean canThrow(@NotNull Throwable cause, @NotNull Method method2) {
        if (cause == null) {
            RemoteUtil.$$$reportNull$$$0(12);
        }
        if (method2 == null) {
            RemoteUtil.$$$reportNull$$$0(13);
        }
        for (Class<?> each : method2.getExceptionTypes()) {
            if (!each.isInstance(cause)) continue;
            return true;
        }
        return false;
    }

    public static <T> T executeWithClassLoader(ThrowableComputable<T, ? extends Exception> action2, ClassLoader classLoader) throws Exception {
        return ClassLoaderUtil.computeWithClassLoader(classLoader, action2);
    }

    @NotNull
    public static Throwable unwrap(@NotNull Throwable e) {
        if (e == null) {
            RemoteUtil.$$$reportNull$$$0(14);
        }
        for (Throwable candidate = e; candidate != null; candidate = candidate.getCause()) {
            Class<?> clazz = candidate.getClass();
            if (clazz == InvocationTargetException.class || clazz == UndeclaredThrowableException.class) continue;
            Throwable throwable = candidate;
            if (throwable == null) {
                RemoteUtil.$$$reportNull$$$0(15);
            }
            return throwable;
        }
        Throwable throwable = e;
        if (throwable == null) {
            RemoteUtil.$$$reportNull$$$0(16);
        }
        return throwable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/rmi/RemoteUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localMethod";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteMethod";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteObj";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "castToRemoteNotNull";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/rmi/RemoteUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "castToLocal";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrap";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "castToRemote";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "castToLocal";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "castArgumentClassToLocal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fixArgs";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fixArg";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "substituteClassLoader";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "invokeRemote";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "canThrow";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "unwrap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RemoteInvocationHandler
    implements InvocationHandler {
        private final Object myRemote;
        private final Class<?> myClazz;
        private final ClassLoader myLoader;

        RemoteInvocationHandler(Object remote, Class<?> clazz, ClassLoader loader) {
            this.myRemote = remote;
            this.myClazz = clazz;
            this.myLoader = loader;
        }

        @Override
        public Object invoke(Object proxy, Method method2, Object[] args) throws Throwable {
            if (method2.getDeclaringClass() == Object.class) {
                if ("equals".equals(method2.getName())) {
                    return proxy == args[0];
                }
                if ("hashCode".equals(method2.getName())) {
                    return this.hashCode();
                }
                return method2.invoke(this.myRemote, args);
            }
            Method remoteMethod = (Method)((Map)ourRemoteToLocalMap.get(Couple.of(this.myRemote.getClass(), this.myClazz))).get(method2);
            if (remoteMethod == null) {
                throw new NoSuchMethodError(method2.getName() + " in " + this.myRemote.getClass());
            }
            return RemoteUtil.invokeRemote(method2, remoteMethod, this.myRemote, RemoteUtil.fixArgs(args, method2), this.myLoader, false);
        }
    }
}

