/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentProvider;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 *2\u00020\u0001:\u0001*B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\"\u001a\u00020\u0000J\u0014\u0010#\u001a\u00020\u00032\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%H\u0007J\u0006\u0010&\u001a\u00020'J\u0010\u0010\u000e\u001a\u00020\u00002\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00002\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016J\u0012\u0010\u0017\u001a\u00020\u00002\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018J\u001a\u0010(\u001a\u00020\u00002\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010)\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00002\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u0010\u0010\u001d\u001a\u00020\u00002\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\n \u001f*\u0004\u0018\u00010\u001e0\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/execution/runners/ExecutionEnvironmentBuilder;", "", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "(Lcom/intellij/execution/runners/ExecutionEnvironment;)V", "project", "Lcom/intellij/openapi/project/Project;", "executor", "Lcom/intellij/execution/Executor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/Executor;)V", "assignNewId", "", "configurationSettings", "Lcom/intellij/execution/configurations/ConfigurationPerRunnerSettings;", "contentToReuse", "Lcom/intellij/execution/ui/RunContentDescriptor;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "executionId", "", "Ljava/lang/Long;", "runProfile", "Lcom/intellij/execution/configurations/RunProfile;", "runner", "Lcom/intellij/execution/runners/ProgramRunner;", "runnerAndConfigurationSettings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "runnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "target", "Lcom/intellij/execution/ExecutionTarget;", "kotlin.jvm.PlatformType", "userData", "Lcom/intellij/openapi/util/UserDataHolderBase;", "activeTarget", "build", "callback", "Lcom/intellij/execution/runners/ProgramRunner$Callback;", "buildAndExecute", "", "runnerAndSettings", "settings", "Companion", "intellij.platform.lang"})
public final class ExecutionEnvironmentBuilder {
    private RunProfile runProfile;
    private ExecutionTarget target;
    private RunnerSettings runnerSettings;
    private ConfigurationPerRunnerSettings configurationSettings;
    private RunContentDescriptor contentToReuse;
    private RunnerAndConfigurationSettings runnerAndConfigurationSettings;
    private ProgramRunner<?> runner;
    private boolean assignNewId;
    private Long executionId;
    private DataContext dataContext;
    private final UserDataHolderBase userData;
    private final Project project;
    private Executor executor;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ExecutionEnvironmentBuilder target(@Nullable ExecutionTarget target2) {
        if (target2 != null) {
            this.target = target2;
        }
        return this;
    }

    @NotNull
    public final ExecutionEnvironmentBuilder activeTarget() {
        this.target = ExecutionTargetManager.getActiveTarget(this.project);
        return this;
    }

    @NotNull
    public final ExecutionEnvironmentBuilder runnerAndSettings(@NotNull ProgramRunner<?> runner, @NotNull RunnerAndConfigurationSettings settings) {
        Intrinsics.checkParameterIsNotNull(runner, (String)"runner");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        this.runnerAndConfigurationSettings = settings;
        this.runProfile = settings.getConfiguration();
        this.runnerSettings = settings.getRunnerSettings(runner);
        this.configurationSettings = settings.getConfigurationSettings(runner);
        this.runner = runner;
        return this;
    }

    @NotNull
    public final ExecutionEnvironmentBuilder runnerSettings(@Nullable RunnerSettings runnerSettings2) {
        this.runnerSettings = runnerSettings2;
        return this;
    }

    @NotNull
    public final ExecutionEnvironmentBuilder contentToReuse(@Nullable RunContentDescriptor contentToReuse) {
        this.contentToReuse = contentToReuse;
        return this;
    }

    @NotNull
    public final ExecutionEnvironmentBuilder runProfile(@NotNull RunProfile runProfile) {
        Intrinsics.checkParameterIsNotNull((Object)runProfile, (String)"runProfile");
        this.runProfile = runProfile;
        return this;
    }

    @NotNull
    public final ExecutionEnvironmentBuilder runner(@NotNull ProgramRunner<?> runner) {
        Intrinsics.checkParameterIsNotNull(runner, (String)"runner");
        this.runner = runner;
        return this;
    }

    @NotNull
    public final ExecutionEnvironmentBuilder dataContext(@Nullable DataContext dataContext) {
        this.dataContext = dataContext;
        return this;
    }

    @NotNull
    public final ExecutionEnvironmentBuilder executor(@NotNull Executor executor) {
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        this.executor = executor;
        return this;
    }

    @NotNull
    public final ExecutionEnvironmentBuilder executionId(long executionId) {
        this.executionId = executionId;
        this.assignNewId = false;
        return this;
    }

    @JvmOverloads
    @NotNull
    public final ExecutionEnvironment build(@Nullable ProgramRunner.Callback callback2) {
        ExecutionEnvironment environment2 = null;
        ExecutionEnvironmentProvider environmentProvider = this.project.getService(ExecutionEnvironmentProvider.class);
        if (environmentProvider != null) {
            RunProfile runProfile = this.runProfile;
            if (runProfile == null) {
                Intrinsics.throwNpe();
            }
            environment2 = environmentProvider.createExecutionEnvironment(this.project, runProfile, this.executor, this.target, this.runnerSettings, this.configurationSettings, this.runnerAndConfigurationSettings);
        }
        if (environment2 == null && this.runner == null) {
            String string = this.executor.getId();
            RunProfile runProfile = this.runProfile;
            if (runProfile == null) {
                Intrinsics.throwNpe();
            }
            this.runner = ProgramRunner.getRunner(string, runProfile);
        }
        if (environment2 == null && this.runner == null) {
            throw (Throwable)new IllegalStateException("Runner must be specified");
        }
        if (environment2 == null) {
            RunProfile runProfile = this.runProfile;
            if (runProfile == null) {
                Intrinsics.throwNpe();
            }
            ProgramRunner<?> programRunner = this.runner;
            if (programRunner == null) {
                Intrinsics.throwNpe();
            }
            environment2 = new ExecutionEnvironment(runProfile, this.executor, this.target, this.project, this.runnerSettings, this.configurationSettings, this.contentToReuse, this.runnerAndConfigurationSettings, programRunner, callback2);
        }
        if (this.assignNewId) {
            environment2.assignNewExecutionId();
        }
        if (this.executionId != null) {
            Long l = this.executionId;
            if (l == null) {
                Intrinsics.throwNpe();
            }
            environment2.setExecutionId(l);
        }
        if (this.dataContext != null) {
            DataContext dataContext = this.dataContext;
            if (dataContext == null) {
                Intrinsics.throwNpe();
            }
            environment2.setDataContext(dataContext);
        }
        this.userData.copyUserDataTo(environment2);
        return environment2;
    }

    public static /* synthetic */ ExecutionEnvironment build$default(ExecutionEnvironmentBuilder executionEnvironmentBuilder, ProgramRunner.Callback callback2, int n, Object object) {
        if ((n & 1) != 0) {
            callback2 = null;
        }
        return executionEnvironmentBuilder.build(callback2);
    }

    @JvmOverloads
    @NotNull
    public final ExecutionEnvironment build() {
        return ExecutionEnvironmentBuilder.build$default(this, null, 1, null);
    }

    public final void buildAndExecute() throws ExecutionException {
        ExecutionEnvironment environment2 = ExecutionEnvironmentBuilder.build$default(this, null, 1, null);
        ProgramRunner<?> programRunner = this.runner;
        if (programRunner == null) {
            Intrinsics.throwNpe();
        }
        programRunner.execute(environment2);
    }

    public ExecutionEnvironmentBuilder(@NotNull Project project2, @NotNull Executor executor) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        this.project = project2;
        this.executor = executor;
        this.target = DefaultExecutionTarget.INSTANCE;
        this.userData = new UserDataHolderBase();
    }

    public ExecutionEnvironmentBuilder(@NotNull ExecutionEnvironment env) {
        Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
        Project project2 = env.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"env.project");
        Executor executor = env.getExecutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)executor, (String)"env.executor");
        this(project2, executor);
        this.target = env.getExecutionTarget();
        this.runnerAndConfigurationSettings = env.getRunnerAndConfigurationSettings();
        this.runProfile = env.getRunProfile();
        this.runnerSettings = env.getRunnerSettings();
        this.configurationSettings = env.getConfigurationSettings();
        this.runner = env.getRunner();
        this.contentToReuse = env.getContentToReuse();
        env.copyUserDataTo(this.userData);
    }

    public static final /* synthetic */ void access$setRunner$p(ExecutionEnvironmentBuilder $this, ProgramRunner programRunner) {
        $this.runner = programRunner;
    }

    @JvmStatic
    @NotNull
    public static final ExecutionEnvironmentBuilder create(@NotNull Project project2, @NotNull Executor executor, @NotNull RunProfile runProfile) throws ExecutionException {
        return Companion.create(project2, executor, runProfile);
    }

    @JvmStatic
    @Nullable
    public static final ExecutionEnvironmentBuilder createOrNull(@NotNull Project project2, @NotNull Executor executor, @NotNull RunProfile runProfile) {
        return Companion.createOrNull(project2, executor, runProfile);
    }

    @JvmStatic
    @Nullable
    public static final ExecutionEnvironmentBuilder createOrNull(@NotNull Executor executor, @NotNull RunnerAndConfigurationSettings settings) {
        return Companion.createOrNull(executor, settings);
    }

    @JvmStatic
    @Nullable
    public static final ExecutionEnvironmentBuilder createOrNull(@NotNull Executor executor, @NotNull RunConfiguration configuration) {
        return Companion.createOrNull(executor, configuration);
    }

    @JvmStatic
    @NotNull
    public static final ExecutionEnvironmentBuilder create(@NotNull Executor executor, @NotNull RunnerAndConfigurationSettings settings) throws ExecutionException {
        return Companion.create(executor, settings);
    }

    @JvmStatic
    @NotNull
    public static final ExecutionEnvironmentBuilder create(@NotNull Executor executor, @NotNull RunConfiguration configuration) {
        return Companion.create(executor, configuration);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0007J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0007J\"\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/execution/runners/ExecutionEnvironmentBuilder$Companion;", "", "()V", "create", "Lcom/intellij/execution/runners/ExecutionEnvironmentBuilder;", "executor", "Lcom/intellij/execution/Executor;", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "runProfile", "Lcom/intellij/execution/configurations/RunProfile;", "createOrNull", "intellij.platform.lang"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ExecutionEnvironmentBuilder create(@NotNull Project project2, @NotNull Executor executor, @NotNull RunProfile runProfile) throws ExecutionException {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
            Intrinsics.checkParameterIsNotNull((Object)runProfile, (String)"runProfile");
            ExecutionEnvironmentBuilder executionEnvironmentBuilder = this.createOrNull(project2, executor, runProfile);
            if (executionEnvironmentBuilder == null) {
                throw (Throwable)new ExecutionException("Cannot find runner for " + runProfile.getName());
            }
            return executionEnvironmentBuilder;
        }

        @JvmStatic
        @Nullable
        public final ExecutionEnvironmentBuilder createOrNull(@NotNull Project project2, @NotNull Executor executor, @NotNull RunProfile runProfile) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
            Intrinsics.checkParameterIsNotNull((Object)runProfile, (String)"runProfile");
            ProgramRunner<RunnerSettings> programRunner = ProgramRunner.getRunner(executor.getId(), runProfile);
            if (programRunner == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull(programRunner, (String)"ProgramRunner.getRunner(\u2026unProfile) ?: return null");
            ProgramRunner<RunnerSettings> runner = programRunner;
            return new ExecutionEnvironmentBuilder(project2, executor).runner(runner).runProfile(runProfile);
        }

        @JvmStatic
        @Nullable
        public final ExecutionEnvironmentBuilder createOrNull(@NotNull Executor executor, @NotNull RunnerAndConfigurationSettings settings) {
            ExecutionEnvironmentBuilder executionEnvironmentBuilder;
            ExecutionEnvironmentBuilder builder2;
            Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
            Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
            RunConfiguration runConfiguration = settings.getConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)runConfiguration, (String)"settings.configuration");
            ExecutionEnvironmentBuilder executionEnvironmentBuilder2 = builder2 = this.createOrNull(executor, runConfiguration);
            if (executionEnvironmentBuilder2 != null) {
                ProgramRunner programRunner = builder2.runner;
                if (programRunner == null) {
                    Intrinsics.throwNpe();
                }
                executionEnvironmentBuilder = executionEnvironmentBuilder2.runnerAndSettings(programRunner, settings);
            } else {
                executionEnvironmentBuilder = null;
            }
            return executionEnvironmentBuilder;
        }

        @JvmStatic
        @Nullable
        public final ExecutionEnvironmentBuilder createOrNull(@NotNull Executor executor, @NotNull RunConfiguration configuration) {
            ExecutionEnvironmentBuilder builder2;
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
                Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
                Project project2 = configuration.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"configuration.project");
                ExecutionEnvironmentBuilder executionEnvironmentBuilder = builder2 = this.createOrNull(project2, executor, configuration);
                if (executionEnvironmentBuilder == null) break block0;
                executionEnvironmentBuilder.runProfile(configuration);
            }
            return builder2;
        }

        @JvmStatic
        @NotNull
        public final ExecutionEnvironmentBuilder create(@NotNull Executor executor, @NotNull RunnerAndConfigurationSettings settings) throws ExecutionException {
            Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
            Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
            RunConfiguration runConfiguration = settings.getConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)runConfiguration, (String)"settings.configuration");
            RunConfiguration configuration = runConfiguration;
            Project project2 = configuration.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"configuration.project");
            ExecutionEnvironmentBuilder builder2 = this.create(project2, executor, configuration);
            ProgramRunner programRunner = builder2.runner;
            if (programRunner == null) {
                Intrinsics.throwNpe();
            }
            return builder2.runnerAndSettings(programRunner, settings);
        }

        @JvmStatic
        @NotNull
        public final ExecutionEnvironmentBuilder create(@NotNull Executor executor, @NotNull RunConfiguration configuration) {
            Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
            Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
            Project project2 = configuration.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"configuration.project");
            return new ExecutionEnvironmentBuilder(project2, executor).runProfile(configuration);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

