/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.content.Content;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExecutionUtil {
    private static final Logger LOG = Logger.getInstance(ExecutionUtil.class);
    private static final NotificationGroup ourNotificationGroup = NotificationGroup.logOnlyGroup("Execution");

    private ExecutionUtil() {
    }

    public static void handleExecutionError(@NotNull Project project2, @NotNull String toolWindowId, @NotNull RunProfile runProfile, @NotNull ExecutionException e) {
        if (project2 == null) {
            ExecutionUtil.$$$reportNull$$$0(0);
        }
        if (toolWindowId == null) {
            ExecutionUtil.$$$reportNull$$$0(1);
        }
        if (runProfile == null) {
            ExecutionUtil.$$$reportNull$$$0(2);
        }
        if (e == null) {
            ExecutionUtil.$$$reportNull$$$0(3);
        }
        ExecutionUtil.handleExecutionError(project2, toolWindowId, runProfile.getName(), (Throwable)e);
    }

    public static void handleExecutionError(@NotNull ExecutionEnvironment environment2, @NotNull ExecutionException e) {
        if (environment2 == null) {
            ExecutionUtil.$$$reportNull$$$0(4);
        }
        if (e == null) {
            ExecutionUtil.$$$reportNull$$$0(5);
        }
        ExecutionUtil.handleExecutionError(environment2.getProject(), RunContentManager.getInstance(environment2.getProject()).getToolWindowIdByEnvironment(environment2), environment2.getRunProfile().getName(), (Throwable)e);
    }

    public static void handleExecutionError(@NotNull Project project2, @NotNull String toolWindowId, @NotNull String taskName, @NotNull Throwable e) {
        if (project2 == null) {
            ExecutionUtil.$$$reportNull$$$0(6);
        }
        if (toolWindowId == null) {
            ExecutionUtil.$$$reportNull$$$0(7);
        }
        if (taskName == null) {
            ExecutionUtil.$$$reportNull$$$0(8);
        }
        if (e == null) {
            ExecutionUtil.$$$reportNull$$$0(9);
        }
        if (e instanceof RunCanceledByUserException) {
            return;
        }
        LOG.debug(e);
        String description = e.getMessage();
        HyperlinkListener listener2 = null;
        if (ExecutionUtil.isProcessNotCreated(e) && !PropertiesComponent.getInstance(project2).isTrueValue("dynamic.classpath")) {
            description = "Command line is too long. In order to reduce its length classpath file can be used.<br>Would you like to enable classpath file mode for all run configurations of your project?<br><a href=\"\">Enable</a>";
            listener2 = event -> PropertiesComponent.getInstance(project2).setValue("dynamic.classpath", "true");
        }
        ExecutionUtil.handleExecutionError(project2, toolWindowId, taskName, e, description, listener2);
    }

    public static boolean isProcessNotCreated(@NotNull Throwable e) {
        if (e == null) {
            ExecutionUtil.$$$reportNull$$$0(10);
        }
        if (e instanceof ProcessNotCreatedException) {
            String description = e.getMessage();
            return (description.contains("87") || description.contains("111") || description.contains("206")) && ((ProcessNotCreatedException)e).getCommandLine().getCommandLineString().length() > 32768;
        }
        return false;
    }

    public static void handleExecutionError(@NotNull Project project2, @NotNull String toolWindowId, @NotNull String taskName, @NotNull Throwable e, @Nullable String description, @Nullable HyperlinkListener listener2) {
        if (project2 == null) {
            ExecutionUtil.$$$reportNull$$$0(11);
        }
        if (toolWindowId == null) {
            ExecutionUtil.$$$reportNull$$$0(12);
        }
        if (taskName == null) {
            ExecutionUtil.$$$reportNull$$$0(13);
        }
        if (e == null) {
            ExecutionUtil.$$$reportNull$$$0(14);
        }
        String title = ExecutionBundle.message("error.running.configuration.message", taskName);
        if (StringUtil.isEmptyOrSpaces(description)) {
            LOG.warn("Execution error without description", e);
            description = "Unknown error";
        }
        String fullMessage = title + ":<br>" + description;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.error(fullMessage, e);
        }
        if (listener2 == null) {
            listener2 = ExceptionUtil.findCause(e, HyperlinkListener.class);
        }
        HyperlinkListener _listener = listener2;
        String _description = description;
        UIUtil.invokeLaterIfNeeded(() -> {
            if (project2.isDisposed()) {
                return;
            }
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance(project2);
            if (toolWindowManager.canShowNotification(toolWindowId)) {
                toolWindowManager.notifyByBalloon(toolWindowId, MessageType.ERROR, fullMessage, null, _listener);
            } else {
                Messages.showErrorDialog(project2, UIUtil.toHtml(fullMessage), "");
            }
            NotificationListener notificationListener = _listener == null ? null : (notification, event) -> {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    notification.expire();
                    _listener.hyperlinkUpdate(event);
                }
            };
            ourNotificationGroup.createNotification(title, _description, NotificationType.ERROR, notificationListener).notify(project2);
        });
    }

    public static void restartIfActive(@NotNull RunContentDescriptor descriptor2) {
        ProcessHandler processHandler2;
        if (descriptor2 == null) {
            ExecutionUtil.$$$reportNull$$$0(15);
        }
        if ((processHandler2 = descriptor2.getProcessHandler()) != null && processHandler2.isStartNotified() && !processHandler2.isProcessTerminating() && !processHandler2.isProcessTerminated()) {
            ExecutionUtil.restart(descriptor2);
        }
    }

    public static void restart(@NotNull RunContentDescriptor descriptor2) {
        if (descriptor2 == null) {
            ExecutionUtil.$$$reportNull$$$0(16);
        }
        ExecutionUtil.restart(descriptor2.getComponent());
    }

    public static void restart(@NotNull Content content2) {
        if (content2 == null) {
            ExecutionUtil.$$$reportNull$$$0(17);
        }
        ExecutionUtil.restart(content2.getComponent());
    }

    private static void restart(@Nullable JComponent component2) {
        ExecutionEnvironment environment2;
        if (component2 != null && (environment2 = LangDataKeys.EXECUTION_ENVIRONMENT.getData(DataManager.getInstance().getDataContext(component2))) != null) {
            ExecutionUtil.restart(environment2);
        }
    }

    public static void restart(@NotNull ExecutionEnvironment environment2) {
        ExecutionManager executionManager;
        if (environment2 == null) {
            ExecutionUtil.$$$reportNull$$$0(18);
        }
        if (!(executionManager = ExecutionManager.getInstance(environment2.getProject())).isStarting(environment2)) {
            executionManager.restartRunProfile(environment2);
        }
    }

    public static void runConfiguration(@NotNull RunnerAndConfigurationSettings configuration, @NotNull Executor executor) {
        if (configuration == null) {
            ExecutionUtil.$$$reportNull$$$0(19);
        }
        if (executor == null) {
            ExecutionUtil.$$$reportNull$$$0(20);
        }
        ExecutionUtil.doRunConfiguration(configuration, executor, null, null, null);
    }

    public static void runConfiguration(@NotNull RunnerAndConfigurationSettings configuration, @NotNull Executor executor, @NotNull ExecutionTarget target2) {
        if (configuration == null) {
            ExecutionUtil.$$$reportNull$$$0(21);
        }
        if (executor == null) {
            ExecutionUtil.$$$reportNull$$$0(22);
        }
        if (target2 == null) {
            ExecutionUtil.$$$reportNull$$$0(23);
        }
        ExecutionUtil.doRunConfiguration(configuration, executor, target2, null, null);
    }

    public static void runConfiguration(@NotNull RunnerAndConfigurationSettings configuration, @NotNull Executor executor, @NotNull ExecutionTarget target2, long executionId) {
        if (configuration == null) {
            ExecutionUtil.$$$reportNull$$$0(24);
        }
        if (executor == null) {
            ExecutionUtil.$$$reportNull$$$0(25);
        }
        if (target2 == null) {
            ExecutionUtil.$$$reportNull$$$0(26);
        }
        ExecutionUtil.doRunConfiguration(configuration, executor, target2, executionId, null);
    }

    public static void runConfiguration(@NotNull RunnerAndConfigurationSettings configuration, @NotNull Executor executor, long executionId) {
        if (configuration == null) {
            ExecutionUtil.$$$reportNull$$$0(27);
        }
        if (executor == null) {
            ExecutionUtil.$$$reportNull$$$0(28);
        }
        ExecutionUtil.doRunConfiguration(configuration, executor, null, executionId, null);
    }

    public static void doRunConfiguration(@NotNull RunnerAndConfigurationSettings configuration, @NotNull Executor executor, @Nullable ExecutionTarget targetOrNullForDefault, @Nullable Long executionId, @Nullable DataContext dataContext) {
        ExecutionEnvironmentBuilder builder2;
        if (configuration == null) {
            ExecutionUtil.$$$reportNull$$$0(29);
        }
        if (executor == null) {
            ExecutionUtil.$$$reportNull$$$0(30);
        }
        if ((builder2 = ExecutionUtil.createEnvironment(executor, configuration)) == null) {
            return;
        }
        if (targetOrNullForDefault != null) {
            builder2.target(targetOrNullForDefault);
        } else {
            builder2.activeTarget();
        }
        if (executionId != null) {
            builder2.executionId(executionId);
        }
        if (dataContext != null) {
            builder2.dataContext(dataContext);
        }
        ExecutionManager.getInstance(configuration.getConfiguration().getProject()).restartRunProfile(builder2.build());
    }

    @Nullable
    public static ExecutionEnvironmentBuilder createEnvironment(@NotNull Executor executor, @NotNull RunnerAndConfigurationSettings settings) {
        if (executor == null) {
            ExecutionUtil.$$$reportNull$$$0(31);
        }
        if (settings == null) {
            ExecutionUtil.$$$reportNull$$$0(32);
        }
        try {
            return ExecutionEnvironmentBuilder.create(executor, settings);
        }
        catch (ExecutionException e) {
            RunConfiguration configuration = settings.getConfiguration();
            Project project2 = configuration.getProject();
            RunContentManager manager = RunContentManager.getInstance(project2);
            String toolWindowId = manager.getContentDescriptorToolWindowId(configuration);
            if (toolWindowId == null) {
                toolWindowId = executor.getToolWindowId();
            }
            ExecutionUtil.handleExecutionError(project2, toolWindowId, configuration.getName(), (Throwable)e);
            return null;
        }
    }

    @NotNull
    public static Icon getLiveIndicator(@Nullable Icon base) {
        return ExecutionUtil.getLiveIndicator(base, 13, 13);
    }

    @NotNull
    public static Icon getLiveIndicator(@Nullable Icon base, int emptyIconWidth, int emptyIconHeight) {
        return ExecutionUtil.getIndicator(base, emptyIconWidth, emptyIconHeight, Color.GREEN);
    }

    @NotNull
    public static Icon getIndicator(final @Nullable Icon base, final int emptyIconWidth, final int emptyIconHeight, final Color color) {
        return new LayeredIcon(new Icon[]{base, new Icon(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                int iSize = JBUIScale.scale(4);
                Graphics2D g2d = (Graphics2D)g.create();
                try {
                    GraphicsUtil.setupAAPainting(g2d);
                    g2d.setColor(color);
                    Ellipse2D.Double shape = new Ellipse2D.Double(x + this.getIconWidth() - iSize, y + this.getIconHeight() - iSize, iSize, iSize);
                    g2d.fill(shape);
                    g2d.setColor(ColorUtil.withAlpha(Color.BLACK, 0.4));
                    g2d.draw(shape);
                }
                finally {
                    g2d.dispose();
                }
            }

            @Override
            public int getIconWidth() {
                return base != null ? base.getIconWidth() : emptyIconWidth;
            }

            @Override
            public int getIconHeight() {
                return base != null ? base.getIconHeight() : emptyIconHeight;
            }
        }});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runProfile";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 19: 
            case 21: 
            case 24: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 20: 
            case 22: 
            case 25: 
            case 28: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/runners/ExecutionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleExecutionError";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isProcessNotCreated";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "restartIfActive";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "restart";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "runConfiguration";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "doRunConfiguration";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[2] = "createEnvironment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

