/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.macro.MacroManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FakeRerunAction
extends AnAction {
    @Override
    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            FakeRerunAction.$$$reportNull$$$0(0);
        }
        Presentation presentation = event.getPresentation();
        ExecutionEnvironment environment2 = this.getEnvironment(event);
        if (environment2 != null) {
            presentation.setText(ExecutionBundle.messagePointer("rerun.configuration.action.name", StringUtil.escapeMnemonics(environment2.getRunProfile().getName())));
            presentation.setIcon("TouchBarGeneral".equals(event.getPlace()) || ExecutionManagerImpl.isProcessRunning(this.getDescriptor(event)) ? AllIcons.Actions.Restart : environment2.getExecutor().getIcon());
            presentation.setEnabled(this.isEnabled(event));
            return;
        }
        presentation.setEnabled(false);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent event) {
        ExecutionEnvironment environment2;
        if (event == null) {
            FakeRerunAction.$$$reportNull$$$0(1);
        }
        if ((environment2 = this.getEnvironment(event)) != null) {
            MacroManager.getInstance().cacheMacrosPreview(event.getDataContext());
            ExecutionUtil.restart(environment2);
        }
    }

    @Nullable
    protected RunContentDescriptor getDescriptor(AnActionEvent event) {
        return event.getData(LangDataKeys.RUN_CONTENT_DESCRIPTOR);
    }

    @Nullable
    protected ExecutionEnvironment getEnvironment(@NotNull AnActionEvent event) {
        ExecutionEnvironment environment2;
        if (event == null) {
            FakeRerunAction.$$$reportNull$$$0(2);
        }
        if ((environment2 = event.getData(LangDataKeys.EXECUTION_ENVIRONMENT)) == null) {
            JComponent component2;
            RunContentDescriptor contentDescriptor;
            Project project2 = event.getProject();
            RunContentManager runContentManager = project2 == null ? null : RunContentManager.getInstanceIfCreated(project2);
            RunContentDescriptor runContentDescriptor = contentDescriptor = runContentManager == null ? null : runContentManager.getSelectedContent();
            if (contentDescriptor != null && (component2 = contentDescriptor.getComponent()) != null) {
                environment2 = LangDataKeys.EXECUTION_ENVIRONMENT.getData(DataManager.getInstance().getDataContext(component2));
            }
        }
        return environment2;
    }

    protected boolean isEnabled(AnActionEvent event) {
        RunContentDescriptor descriptor2 = this.getDescriptor(event);
        ProcessHandler processHandler2 = descriptor2 == null ? null : descriptor2.getProcessHandler();
        ExecutionEnvironment environment2 = this.getEnvironment(event);
        Project project2 = FakeRerunAction.getEventProject(event);
        if (environment2 == null || project2 == null) {
            return false;
        }
        RunnerAndConfigurationSettings settings = environment2.getRunnerAndConfigurationSettings();
        return !(DumbService.isDumb(project2) && settings != null && !settings.getType().isDumbAware() || ExecutionManager.getInstance(project2).isStarting(environment2) || processHandler2 != null && processHandler2.isProcessTerminating());
    }

    @Override
    public boolean isDumbAware() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "com/intellij/execution/runners/FakeRerunAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getEnvironment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

