/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.SettingsEditor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ProgramRunner<Settings extends RunnerSettings> {
    public static final ExtensionPointName<ProgramRunner<? extends RunnerSettings>> PROGRAM_RUNNER_EP = new ExtensionPointName("com.intellij.programRunner");

    @Nullable
    public static ProgramRunner<?> findRunnerById(@NotNull String id2) {
        if (id2 == null) {
            ProgramRunner.$$$reportNull$$$0(0);
        }
        return PROGRAM_RUNNER_EP.findFirstSafe(it -> id2.equals(it.getRunnerId()));
    }

    @Nullable
    public static ProgramRunner<RunnerSettings> getRunner(@NotNull String executorId, @NotNull RunProfile settings) {
        if (executorId == null) {
            ProgramRunner.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            ProgramRunner.$$$reportNull$$$0(2);
        }
        return PROGRAM_RUNNER_EP.findFirstSafe(it -> it.canRun(executorId, settings));
    }

    @NotNull
    @NonNls
    public String getRunnerId();

    public boolean canRun(@NotNull String var1, @NotNull RunProfile var2);

    @Nullable
    default public Settings createConfigurationData(@NotNull ConfigurationInfoProvider settingsProvider) {
        if (settingsProvider == null) {
            ProgramRunner.$$$reportNull$$$0(3);
        }
        return null;
    }

    default public void checkConfiguration(RunnerSettings settings, @Nullable ConfigurationPerRunnerSettings configurationPerRunnerSettings2) throws RuntimeConfigurationException {
    }

    @Deprecated
    default public void onProcessStarted(RunnerSettings settings, ExecutionResult executionResult) {
    }

    @Nullable
    default public SettingsEditor<Settings> getSettingsEditor(Executor executor, RunConfiguration configuration) {
        return null;
    }

    public void execute(@NotNull ExecutionEnvironment var1) throws ExecutionException;

    @Deprecated
    default public void execute(@NotNull ExecutionEnvironment environment2, @Nullable Callback callback2) throws ExecutionException {
        if (environment2 == null) {
            ProgramRunner.$$$reportNull$$$0(4);
        }
        if (callback2 != null) {
            environment2.setCallback(callback2);
        }
        this.execute(environment2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/runners/ProgramRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findRunnerById";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getRunner";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createConfigurationData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Callback {
        public void processStarted(RunContentDescriptor var1);
    }
}

