/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.services.ServiceModel;
import com.intellij.execution.services.ServiceView;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewDragHelper;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.ui.PopupHandler;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ServiceViewActionProvider {
    @NonNls
    private static final String SERVICE_VIEW_ITEM_TOOLBAR = "ServiceViewItemToolbar";
    @NonNls
    static final String SERVICE_VIEW_ITEM_POPUP = "ServiceViewItemPopup";
    @NonNls
    private static final String SERVICE_VIEW_TREE_TOOLBAR = "ServiceViewTreeToolbar";
    private static final ServiceViewActionProvider ourInstance = new ServiceViewActionProvider();
    private static final AnAction EMPTY_ACTION = new DumbAwareAction(EmptyIcon.ICON_16){

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                2.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(false);
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                2.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/execution/services/ServiceViewActionProvider$2";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    ServiceViewActionProvider() {
    }

    static ServiceViewActionProvider getInstance() {
        return ourInstance;
    }

    ActionToolbar createServiceToolbar(@NotNull JComponent component2) {
        if (component2 == null) {
            ServiceViewActionProvider.$$$reportNull$$$0(0);
        }
        ActionGroup actions = (ActionGroup)ActionManager.getInstance().getAction(SERVICE_VIEW_ITEM_TOOLBAR);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ServicesToolbar", actions, false);
        toolbar.setTargetComponent(component2);
        return toolbar;
    }

    JComponent wrapServiceToolbar(@NotNull ActionToolbar toolbar) {
        if (toolbar == null) {
            ServiceViewActionProvider.$$$reportNull$$$0(1);
        }
        final JPanel wrapper2 = new JPanel(new BorderLayout());
        wrapper2.add((Component)toolbar.getComponent(), "Center");
        toolbar.getComponent().addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                wrapper2.setVisible(true);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                wrapper2.setVisible(false);
            }
        });
        ActionToolbar prototypeToolbar = ServiceViewActionProvider.createPrototypeToolbar();
        JLabel spacer = new JLabel();
        spacer.setPreferredSize(new Dimension(prototypeToolbar.getComponent().getPreferredSize().width, 0));
        wrapper2.add((Component)spacer, "South");
        return wrapper2;
    }

    void installPopupHandler(@NotNull JComponent component2) {
        if (component2 == null) {
            ServiceViewActionProvider.$$$reportNull$$$0(2);
        }
        ActionGroup actions = (ActionGroup)ActionManager.getInstance().getAction(SERVICE_VIEW_ITEM_POPUP);
        PopupHandler.installPopupHandler(component2, actions, "ServicesPopup", ActionManager.getInstance());
    }

    ActionToolbar createMasterComponentToolbar(@NotNull JComponent component2) {
        if (component2 == null) {
            ServiceViewActionProvider.$$$reportNull$$$0(3);
        }
        DefaultActionGroup group = new DefaultActionGroup();
        if (component2 instanceof JTree) {
            ServiceViewTreeExpander treeExpander = new ServiceViewTreeExpander((JTree)component2);
            AnAction expandAllAction = CommonActionsManager.getInstance().createExpandAllAction(treeExpander, component2);
            group.add(expandAllAction);
            AnAction collapseAllAction = CommonActionsManager.getInstance().createCollapseAllAction(treeExpander, component2);
            group.add(collapseAllAction);
            group.addSeparator();
        }
        group.addSeparator();
        AnAction treeActions = ActionManager.getInstance().getAction(SERVICE_VIEW_TREE_TOOLBAR);
        treeActions.registerCustomShortcutSet(component2, null);
        group.add(treeActions);
        ActionToolbar treeActionsToolBar = ActionManager.getInstance().createActionToolbar("ServicesToolbar", group, true);
        treeActionsToolBar.setTargetComponent(component2);
        return treeActionsToolBar;
    }

    List<AnAction> getAdditionalGearActions() {
        AnAction showServicesActions = ActionManager.getInstance().getAction("ServiceView.ShowServices");
        return showServicesActions == null ? Collections.emptyList() : Collections.singletonList(showServicesActions);
    }

    @Nullable
    static ServiceView getSelectedView(@NotNull AnActionEvent e) {
        if (e == null) {
            ServiceViewActionProvider.$$$reportNull$$$0(4);
        }
        return ServiceViewActionProvider.getSelectedView(e.getData(PlatformDataKeys.CONTEXT_COMPONENT));
    }

    @Nullable
    static ServiceView getSelectedView(@NotNull DataProvider provider) {
        if (provider == null) {
            ServiceViewActionProvider.$$$reportNull$$$0(5);
        }
        return ServiceViewActionProvider.getSelectedView(ObjectUtils.tryCast(provider.getData(PlatformDataKeys.CONTEXT_COMPONENT.getName()), Component.class));
    }

    @Nullable
    private static ServiceView getSelectedView(@Nullable Component contextComponent) {
        while (contextComponent != null && !(contextComponent instanceof ServiceView)) {
            contextComponent = contextComponent.getParent();
        }
        return (ServiceView)contextComponent;
    }

    private static ActionToolbar createPrototypeToolbar() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(EMPTY_ACTION);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("toolbar", actionGroup, false);
        toolbar.updateActionsImmediately();
        return toolbar;
    }

    private static AnAction @NotNull [] doGetActions(@Nullable AnActionEvent e, boolean toolbar) {
        ServiceViewDescriptor descriptor2;
        if (e == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                ServiceViewActionProvider.$$$reportNull$$$0(6);
            }
            return AnAction.EMPTY_ARRAY;
        }
        Project project2 = e.getProject();
        if (project2 == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                ServiceViewActionProvider.$$$reportNull$$$0(7);
            }
            return AnAction.EMPTY_ARRAY;
        }
        ServiceView serviceView = ServiceViewActionProvider.getSelectedView(e);
        if (serviceView == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                ServiceViewActionProvider.$$$reportNull$$$0(8);
            }
            return AnAction.EMPTY_ARRAY;
        }
        List<ServiceModel.ServiceViewItem> selectedItems = serviceView.getSelectedItems();
        if (selectedItems.isEmpty()) {
            if (AnAction.EMPTY_ARRAY == null) {
                ServiceViewActionProvider.$$$reportNull$$$0(9);
            }
            return AnAction.EMPTY_ARRAY;
        }
        if (selectedItems.size() == 1) {
            descriptor2 = selectedItems.get(0).getViewDescriptor();
        } else {
            ServiceViewContributor contributor = ServiceViewDragHelper.getTheOnlyRootContributor(selectedItems);
            ServiceViewDescriptor serviceViewDescriptor = descriptor2 = contributor == null ? null : contributor.getViewDescriptor(project2);
        }
        if (descriptor2 == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                ServiceViewActionProvider.$$$reportNull$$$0(10);
            }
            return AnAction.EMPTY_ARRAY;
        }
        ActionGroup group = toolbar ? descriptor2.getToolbarActions() : descriptor2.getPopupActions();
        AnAction[] anActionArray = group == null ? AnAction.EMPTY_ARRAY : group.getChildren(e);
        if (anActionArray == null) {
            ServiceViewActionProvider.$$$reportNull$$$0(11);
        }
        return anActionArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolbar";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/services/ServiceViewActionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/services/ServiceViewActionProvider";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createServiceToolbar";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "wrapServiceToolbar";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "installPopupHandler";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createMasterComponentToolbar";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedView";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ItemPopupActionGroup
    extends ActionGroup {
        @Override
        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = ServiceViewActionProvider.doGetActions(e, false);
            if (anActionArray == null) {
                ItemPopupActionGroup.$$$reportNull$$$0(0);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/services/ServiceViewActionProvider$ItemPopupActionGroup", "getChildren"));
        }
    }

    public static class ItemToolbarActionGroup
    extends ActionGroup {
        @Override
        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = ServiceViewActionProvider.doGetActions(e, true);
            if (anActionArray == null) {
                ItemToolbarActionGroup.$$$reportNull$$$0(0);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/services/ServiceViewActionProvider$ItemToolbarActionGroup", "getChildren"));
        }
    }

    private static class ServiceViewTreeExpander
    extends DefaultTreeExpander {
        private final TreeModel myTreeModel;
        private boolean myFlat;

        ServiceViewTreeExpander(JTree tree) {
            super(tree);
            this.myTreeModel = tree.getModel();
            this.myTreeModel.addTreeModelListener(new TreeModelAdapter(){

                @Override
                protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (type == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    myFlat = this.isFlat();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "type";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/execution/services/ServiceViewActionProvider$ServiceViewTreeExpander$1";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        @Override
        public boolean canExpand() {
            return super.canExpand() && !this.myFlat;
        }

        @Override
        public boolean canCollapse() {
            return super.canCollapse() && !this.myFlat;
        }

        private boolean isFlat() {
            Object root = this.myTreeModel.getRoot();
            if (root == null) {
                return false;
            }
            int childCount = this.myTreeModel.getChildCount(root);
            for (int i = 0; i < childCount; ++i) {
                Object child2 = this.myTreeModel.getChild(root, i);
                if (this.myTreeModel.isLeaf(child2)) continue;
                return false;
            }
            return true;
        }
    }
}

