/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.services.ServiceViewActionProvider;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.services.ServiceViewManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.AutoScrollFromSourceHandler;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.util.PlatformUtils;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

class ServiceViewSourceScrollHelper {
    private static final String AUTO_SCROLL_TO_SOURCE_PROPERTY = "service.view.auto.scroll.to.source";
    private static final String AUTO_SCROLL_FROM_SOURCE_PROPERTY = "service.view.auto.scroll.from.source";

    ServiceViewSourceScrollHelper() {
    }

    @NotNull
    static AutoScrollToSourceHandler createAutoScrollToSourceHandler(@NotNull Project project2) {
        if (project2 == null) {
            ServiceViewSourceScrollHelper.$$$reportNull$$$0(0);
        }
        return new ServiceViewAutoScrollToSourceHandler(project2);
    }

    static void installAutoScrollSupport(@NotNull Project project2, @NotNull ToolWindowEx toolWindow, @NotNull AutoScrollToSourceHandler toSourceHandler) {
        if (project2 == null) {
            ServiceViewSourceScrollHelper.$$$reportNull$$$0(1);
        }
        if (toolWindow == null) {
            ServiceViewSourceScrollHelper.$$$reportNull$$$0(2);
        }
        if (toSourceHandler == null) {
            ServiceViewSourceScrollHelper.$$$reportNull$$$0(3);
        }
        ServiceViewAutoScrollFromSourceHandler fromSourceHandler = new ServiceViewAutoScrollFromSourceHandler(project2, toolWindow);
        fromSourceHandler.install();
        DefaultActionGroup additionalGearActions = new DefaultActionGroup(toSourceHandler.createToggleAction(), fromSourceHandler.createToggleAction(), Separator.getInstance());
        List<AnAction> additionalProviderActions = ServiceViewActionProvider.getInstance().getAdditionalGearActions();
        for (AnAction action2 : additionalProviderActions) {
            additionalGearActions.add(action2);
        }
        toolWindow.setAdditionalGearActions(additionalGearActions);
        toolWindow.setTitleActions(new ScrollFromEditorAction(fromSourceHandler));
    }

    private static boolean isAutoScrollFromSourceEnabled(@NotNull Project project2) {
        if (project2 == null) {
            ServiceViewSourceScrollHelper.$$$reportNull$$$0(4);
        }
        return PropertiesComponent.getInstance(project2).getBoolean(AUTO_SCROLL_FROM_SOURCE_PROPERTY, PlatformUtils.isDataGrip());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSourceHandler";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/services/ServiceViewSourceScrollHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createAutoScrollToSourceHandler";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "installAutoScrollSupport";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isAutoScrollFromSourceEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ScrollFromEditorAction
    extends DumbAwareAction {
        private final ServiceViewAutoScrollFromSourceHandler myScrollFromHandler;

        ScrollFromEditorAction(ServiceViewAutoScrollFromSourceHandler scrollFromHandler) {
            super(ExecutionBundle.message("service.view.scroll.from.editor.action.name", new Object[0]), ExecutionBundle.message("service.view.scroll.from.editor.action.description", new Object[0]), AllIcons.General.Locate);
            this.myScrollFromHandler = scrollFromHandler;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            Project project2;
            if (e == null) {
                ScrollFromEditorAction.$$$reportNull$$$0(0);
            }
            if ((project2 = e.getProject()) == null) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setEnabledAndVisible(!ServiceViewSourceScrollHelper.isAutoScrollFromSourceEnabled(project2));
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project2;
            if (e == null) {
                ScrollFromEditorAction.$$$reportNull$$$0(1);
            }
            if ((project2 = e.getProject()) == null) {
                return;
            }
            FileEditorManager manager = FileEditorManager.getInstance(project2);
            FileEditor[] editors = manager.getSelectedEditors();
            this.select(Arrays.asList(editors).iterator());
        }

        private void select(Iterator<FileEditor> editors) {
            if (!editors.hasNext()) {
                return;
            }
            FileEditor editor = editors.next();
            this.myScrollFromHandler.select(editor).onError(r -> this.select(editors));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/execution/services/ServiceViewSourceScrollHelper$ScrollFromEditorAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ServiceViewAutoScrollFromSourceHandler
    extends AutoScrollFromSourceHandler {
        ServiceViewAutoScrollFromSourceHandler(@NotNull Project project2, @NotNull ToolWindow toolWindow) {
            if (project2 == null) {
                ServiceViewAutoScrollFromSourceHandler.$$$reportNull$$$0(0);
            }
            if (toolWindow == null) {
                ServiceViewAutoScrollFromSourceHandler.$$$reportNull$$$0(1);
            }
            super(project2, toolWindow.getComponent(), toolWindow.getContentManager());
        }

        @Override
        protected boolean isAutoScrollEnabled() {
            return ServiceViewSourceScrollHelper.isAutoScrollFromSourceEnabled(this.myProject);
        }

        @Override
        protected void setAutoScrollEnabled(boolean enabled) {
            PropertiesComponent.getInstance(this.myProject).setValue(ServiceViewSourceScrollHelper.AUTO_SCROLL_FROM_SOURCE_PROPERTY, enabled, PlatformUtils.isDataGrip());
        }

        @Override
        protected void selectElementFromEditor(@NotNull FileEditor editor) {
            if (editor == null) {
                ServiceViewAutoScrollFromSourceHandler.$$$reportNull$$$0(2);
            }
            this.select(editor);
        }

        private Promise<Void> select(@NotNull FileEditor editor) {
            VirtualFile virtualFile2;
            if (editor == null) {
                ServiceViewAutoScrollFromSourceHandler.$$$reportNull$$$0(3);
            }
            if ((virtualFile2 = FileEditorManagerEx.getInstanceEx(this.myProject).getFile(editor)) == null) {
                return Promises.rejectedPromise((String)"Virtual file is null");
            }
            return ((ServiceViewManagerImpl)ServiceViewManager.getInstance(this.myProject)).select(virtualFile2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWindow";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/services/ServiceViewSourceScrollHelper$ServiceViewAutoScrollFromSourceHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectElementFromEditor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "select";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ServiceViewAutoScrollToSourceHandler
    extends AutoScrollToSourceHandler {
        private final Project myProject;

        ServiceViewAutoScrollToSourceHandler(@NotNull Project project2) {
            if (project2 == null) {
                ServiceViewAutoScrollToSourceHandler.$$$reportNull$$$0(0);
            }
            this.myProject = project2;
        }

        @Override
        protected boolean isAutoScrollMode() {
            return PropertiesComponent.getInstance(this.myProject).getBoolean(ServiceViewSourceScrollHelper.AUTO_SCROLL_TO_SOURCE_PROPERTY);
        }

        @Override
        protected void setAutoScrollMode(boolean state) {
            PropertiesComponent.getInstance(this.myProject).setValue(ServiceViewSourceScrollHelper.AUTO_SCROLL_TO_SOURCE_PROPERTY, state);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/services/ServiceViewSourceScrollHelper$ServiceViewAutoScrollToSourceHandler", "<init>"));
        }
    }
}

