/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.startup;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ChooseRunConfigurationPopup;
import com.intellij.execution.actions.ExecutorProvider;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.execution.impl.NewRunConfigurationPopup;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.startup.ProjectStartupRunner;
import com.intellij.execution.startup.ProjectStartupTaskManager;
import com.intellij.execution.startup.ProjectStartupTasksTableModel;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableProvider;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.table.JBTable;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ProjectStartupConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private final Project myProject;
    private JBTable myTable;
    private ToolbarDecorator myDecorator;
    private ProjectStartupTasksTableModel myModel;

    ProjectStartupConfigurable(@NotNull Project project2) {
        if (project2 == null) {
            ProjectStartupConfigurable.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
    }

    @Override
    @NotNull
    public String getId() {
        return "preferences.startup.tasks";
    }

    @Override
    @Nls
    public String getDisplayName() {
        return ExecutionBundle.message("configurable.ProjectStartupConfigurable.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String getHelpTopic() {
        return "reference.settings.startup.tasks";
    }

    @Override
    @NotNull
    public JComponent createComponent() {
        this.myModel = new ProjectStartupTasksTableModel();
        this.myTable = new JBTable(this.myModel);
        this.myTable.getEmptyText().setText(ExecutionBundle.message("settings.project.startup.add.run.configurations.with.the.button", new Object[0]));
        new TableSpeedSearch(this.myTable);
        DefaultCellEditor defaultEditor = (DefaultCellEditor)this.myTable.getDefaultEditor(Object.class);
        defaultEditor.setClickCountToStart(1);
        this.myTable.getSelectionModel().setSelectionMode(0);
        DumbAwareAction.create(e -> {
            int row = this.myTable.getSelectedRow();
            if (row >= 0 && this.myModel.isCellEditable(row, 1)) {
                this.myModel.setValueAt(!Boolean.TRUE.equals(this.myTable.getValueAt(row, 1)), row, 1);
            }
        }).registerCustomShortcutSet(new CustomShortcutSet(32), this.myTable);
        this.myTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    ProjectStartupConfigurable.this.editRunConfiguration();
                }
            }
        });
        this.installRenderers();
        this.myDecorator = ToolbarDecorator.createDecorator(this.myTable).setAddAction(new AnActionButtonRunnable(){

            @Override
            public void run(AnActionButton button2) {
                ProjectStartupConfigurable.this.selectAndAddConfiguration(button2);
            }
        }).setEditAction(new AnActionButtonRunnable(){

            @Override
            public void run(AnActionButton button2) {
                ProjectStartupConfigurable.this.editRunConfiguration();
            }
        }).setEditActionUpdater(e -> this.myTable.getSelectedRow() >= 0).disableUpAction().disableDownAction();
        JPanel tasksPanel = this.myDecorator.createPanel();
        JLabel label2 = new JLabel(ExecutionBundle.message("settings.project.startup.run.tasks.and.tools.via.run.configurations", new Object[0]));
        label2.setForeground(UIUtil.getInactiveTextColor());
        label2.setHorizontalAlignment(4);
        JPanel wrapper2 = new JPanel(new BorderLayout());
        wrapper2.add((Component)new JLabel(ExecutionBundle.message("settings.project.startup.to.be.started.on.project.opening", new Object[0])), "West");
        wrapper2.add((Component)label2, "East");
        wrapper2.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        JPanel main2 = new JPanel(new BorderLayout());
        main2.add((Component)wrapper2, "North");
        main2.add((Component)tasksPanel, "Center");
        JPanel jPanel = main2;
        if (jPanel == null) {
            ProjectStartupConfigurable.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editRunConfiguration() {
        int row = this.myTable.getSelectedRow();
        if (row < 0) {
            return;
        }
        RunnerAndConfigurationSettings selected2 = this.myModel.getAllConfigurations().get(row);
        RunManager runManager = RunManager.getInstance(this.myProject);
        RunnerAndConfigurationSettings was = runManager.getSelectedConfiguration();
        try {
            runManager.setSelectedConfiguration(selected2);
            new EditConfigurationsDialog(this.myProject).showAndGet();
        }
        finally {
            runManager.setSelectedConfiguration(was);
        }
        this.myModel.fireTableDataChanged();
        this.refreshDataUpdateSelection(selected2);
    }

    private void refreshDataUpdateSelection(RunnerAndConfigurationSettings settings) {
        if (this.myTable.isEmpty()) {
            return;
        }
        this.myModel.reValidateConfigurations((Processor<? super RunnerAndConfigurationSettings>)new Processor<RunnerAndConfigurationSettings>(){
            private final RunManagerImpl runManager;
            {
                this.runManager = RunManagerImpl.getInstanceImpl(ProjectStartupConfigurable.this.myProject);
            }

            @Override
            public boolean process(RunnerAndConfigurationSettings settings) {
                return this.runManager.getConfigurationById(settings.getUniqueID()) != null;
            }
        });
        if (settings != null) {
            List<RunnerAndConfigurationSettings> configurations = this.myModel.getAllConfigurations();
            for (int i = 0; i < configurations.size(); ++i) {
                RunnerAndConfigurationSettings configuration = configurations.get(i);
                if (configuration != settings) continue;
                TableUtil.selectRows(this.myTable, new int[]{i});
                return;
            }
        }
        TableUtil.selectRows(this.myTable, new int[]{0});
        this.myTable.getSelectionModel().setLeadSelectionIndex(0);
    }

    private ChooseRunConfigurationPopup.ItemWrapper<Void> createNewWrapper(final AnActionButton button2) {
        return new ChooseRunConfigurationPopup.ItemWrapper<Void>(null){

            @Override
            public Icon getIcon() {
                return IconUtil.getAddIcon();
            }

            @Override
            public String getText() {
                return UIUtil.removeMnemonic(ExecutionBundle.message("add.new.run.configuration.action2.name", new Object[0]));
            }

            @Override
            public void perform(@NotNull Project project2, @NotNull Executor executor, @NotNull DataContext context) {
                if (project2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (executor == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (context == null) {
                    5.$$$reportNull$$$0(2);
                }
                RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(project2);
                List<ConfigurationType> typesToShow = ContainerUtil.filter(ConfigurationType.CONFIGURATION_TYPE_EP.getExtensionList(), configurationType -> {
                    ConfigurationFactory factory = runManager.getFactory((ConfigurationType)configurationType, null);
                    return factory != null && ProgramRunner.getRunner(executor.getId(), runManager.getConfigurationTemplate(factory).getConfiguration()) != null;
                });
                JBPopup popup2 = NewRunConfigurationPopup.createAddPopup(project2, typesToShow, "", factory -> ApplicationManager.getApplication().invokeLater(() -> {
                    EditConfigurationsDialog dialog2 = new EditConfigurationsDialog(project2, (ConfigurationFactory)factory);
                    if (dialog2.showAndGet()) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            RunnerAndConfigurationSettings configuration = RunManager.getInstance(project2).getSelectedConfiguration();
                            if (configuration != null) {
                                ProjectStartupConfigurable.this.addConfiguration(configuration);
                            }
                        }, project2.getDisposed());
                    }
                }, project2.getDisposed()), null, null, false);
                ProjectStartupConfigurable.this.showPopup(button2, popup2);
            }

            @Override
            public boolean available(Executor executor) {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "executor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/execution/startup/ProjectStartupConfigurable$5";
                objectArray[2] = "perform";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private void addConfiguration(RunnerAndConfigurationSettings configuration) {
        if (!ProjectStartupRunner.canBeRun(configuration)) {
            String message = ExecutionBundle.message("settings.project.startup.warning", configuration.getName());
            Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, MessageType.ERROR, null).setHideOnClickOutside(true).setFadeoutTime(3000L).setCloseButtonEnabled(true).createBalloon();
            RelativePoint rp = new RelativePoint(this.myDecorator.getActionsPanel(), new Point(5, 5));
            balloon.show(rp, Balloon.Position.atLeft);
            return;
        }
        this.myModel.addConfiguration(configuration);
        this.refreshDataUpdateSelection(configuration);
    }

    private void selectAndAddConfiguration(AnActionButton button2) {
        final Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        ArrayList<ChooseRunConfigurationPopup.ItemWrapper> wrappers = new ArrayList<ChooseRunConfigurationPopup.ItemWrapper>();
        wrappers.add(this.createNewWrapper(button2));
        List<ChooseRunConfigurationPopup.ItemWrapper> allSettings = ChooseRunConfigurationPopup.createSettingsList(this.myProject, new ExecutorProvider(){

            @Override
            public Executor getExecutor() {
                return executor;
            }
        }, false);
        HashSet<RunnerAndConfigurationSettings> existing = new HashSet<RunnerAndConfigurationSettings>(this.myModel.getAllConfigurations());
        for (ChooseRunConfigurationPopup.ItemWrapper setting : allSettings) {
            RunnerAndConfigurationSettings settings;
            if (!(setting.getValue() instanceof RunnerAndConfigurationSettings) || (settings = (RunnerAndConfigurationSettings)setting.getValue()).isTemporary() || !ProjectStartupRunner.canBeRun(settings) || existing.contains(settings)) continue;
            wrappers.add(setting);
        }
        JBPopup popup2 = JBPopupFactory.getInstance().createPopupChooserBuilder(wrappers).setRenderer(SimpleListCellRenderer.create((label2, value2, index) -> {
            label2.setIcon(value2.getIcon());
            label2.setText(value2.getText());
        })).setItemChosenCallback(at -> {
            if (at.getValue() instanceof RunnerAndConfigurationSettings) {
                RunnerAndConfigurationSettings added = (RunnerAndConfigurationSettings)at.getValue();
                this.addConfiguration(added);
            } else {
                at.perform(this.myProject, executor, button2.getDataContext());
            }
        }).createPopup();
        this.showPopup(button2, popup2);
    }

    private void showPopup(AnActionButton button2, JBPopup popup2) {
        RelativePoint point = button2.getPreferredPopupPoint();
        if (point != null) {
            popup2.show(point);
        } else {
            popup2.showInCenterOf(this.myDecorator.getActionsPanel());
        }
    }

    @Override
    public boolean isModified() {
        ProjectStartupTaskManager projectStartupTaskManager = ProjectStartupTaskManager.getInstance(this.myProject);
        HashSet<RunnerAndConfigurationSettings> shared = new HashSet<RunnerAndConfigurationSettings>(projectStartupTaskManager.getSharedConfigurations());
        ArrayList<RunnerAndConfigurationSettings> list2 = new ArrayList<RunnerAndConfigurationSettings>(shared);
        list2.addAll(projectStartupTaskManager.getLocalConfigurations());
        Collections.sort(list2, ProjectStartupTasksTableModel.RunnerAndConfigurationSettingsComparator.getInstance());
        if (!Comparing.equal(list2, this.myModel.getAllConfigurations())) {
            return true;
        }
        return !Comparing.equal(shared, this.myModel.getSharedConfigurations());
    }

    @Override
    public void apply() {
        ArrayList<RunnerAndConfigurationSettings> shared = new ArrayList<RunnerAndConfigurationSettings>();
        ArrayList<RunnerAndConfigurationSettings> local = new ArrayList<RunnerAndConfigurationSettings>();
        Set<RunnerAndConfigurationSettings> sharedSet = this.myModel.getSharedConfigurations();
        List<RunnerAndConfigurationSettings> allConfigurations = this.myModel.getAllConfigurations();
        for (RunnerAndConfigurationSettings configuration : allConfigurations) {
            if (sharedSet.contains(configuration)) {
                shared.add(configuration);
                continue;
            }
            local.add(configuration);
        }
        ProjectStartupTaskManager.getInstance(this.myProject).setStartupConfigurations(shared, local);
    }

    @Override
    public void reset() {
        ProjectStartupTaskManager projectStartupTaskManager = ProjectStartupTaskManager.getInstance(this.myProject);
        this.myModel.setData(projectStartupTaskManager.getSharedConfigurations(), projectStartupTaskManager.getLocalConfigurations());
        this.refreshDataUpdateSelection(null);
    }

    private void installRenderers() {
        TableColumn checkboxColumn = this.myTable.getColumnModel().getColumn(1);
        String header = checkboxColumn.getHeaderValue().toString();
        FontMetrics fm = this.myTable.getFontMetrics(this.myTable.getTableHeader().getFont());
        int width = -new JBCheckBox().getPreferredSize().width + fm.stringWidth(header + "ww");
        TableUtil.setupCheckboxColumn(checkboxColumn, width);
        checkboxColumn.setCellRenderer(new BooleanTableCellRenderer());
        this.myTable.getTableHeader().setResizingAllowed(false);
        this.myTable.getTableHeader().setReorderingAllowed(false);
        TableColumn nameColumn = this.myTable.getColumnModel().getColumn(0);
        nameColumn.setCellRenderer(new ColoredTableCellRenderer(){

            @Override
            protected void customizeCellRenderer(JTable table, @Nullable Object value2, boolean selected2, boolean hasFocus, int row, int column) {
                RunnerAndConfigurationSettings settings = ProjectStartupConfigurable.this.myModel.getAllConfigurations().get(row);
                this.setIcon(settings.getConfiguration().getIcon());
                this.append(settings.getName());
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/startup/ProjectStartupConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/startup/ProjectStartupConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class ProjectStartupConfigurableProvider
    extends ConfigurableProvider {
        private final Project myProject;

        ProjectStartupConfigurableProvider(@NotNull Project project2) {
            if (project2 == null) {
                ProjectStartupConfigurableProvider.$$$reportNull$$$0(0);
            }
            this.myProject = project2;
        }

        @Override
        public Configurable createConfigurable() {
            return new ProjectStartupConfigurable(this.myProject);
        }

        @Override
        public boolean canCreateConfigurable() {
            return !PlatformUtils.isDataGrip();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/startup/ProjectStartupConfigurable$ProjectStartupConfigurableProvider", "<init>"));
        }
    }
}

