/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.startup;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.startup.ProjectStartupConfigurationBase;
import com.intellij.execution.startup.ProjectStartupLocalConfiguration;
import com.intellij.execution.startup.ProjectStartupSharedConfiguration;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@Service
final class ProjectStartupTaskManager {
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.logOnlyGroup("Project Startup Tasks Messages");
    public static final String PREFIX = "Project Startup Tasks: ";
    private final Project myProject;
    private final ProjectStartupSharedConfiguration myShared;
    private final ProjectStartupLocalConfiguration myLocal;

    @NotNull
    public static ProjectStartupTaskManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            ProjectStartupTaskManager.$$$reportNull$$$0(0);
        }
        ProjectStartupTaskManager projectStartupTaskManager = project2.getService(ProjectStartupTaskManager.class);
        if (projectStartupTaskManager == null) {
            ProjectStartupTaskManager.$$$reportNull$$$0(1);
        }
        return projectStartupTaskManager;
    }

    ProjectStartupTaskManager(@NotNull Project project2) {
        if (project2 == null) {
            ProjectStartupTaskManager.$$$reportNull$$$0(2);
        }
        this.myProject = project2;
        this.myShared = this.myProject.getService(ProjectStartupSharedConfiguration.class);
        this.myLocal = this.myProject.getService(ProjectStartupLocalConfiguration.class);
        this.verifyState();
    }

    private void verifyState() {
        if (this.myShared.isEmpty()) {
            return;
        }
        Collection<RunnerAndConfigurationSettings> sharedConfigurations = this.getSharedConfigurations();
        ArrayList<RunnerAndConfigurationSettings> canNotBeShared = new ArrayList<RunnerAndConfigurationSettings>();
        Iterator<RunnerAndConfigurationSettings> iterator2 = sharedConfigurations.iterator();
        while (iterator2.hasNext()) {
            RunnerAndConfigurationSettings configuration = iterator2.next();
            if (configuration.isShared()) continue;
            iterator2.remove();
            canNotBeShared.add(configuration);
        }
        if (!canNotBeShared.isEmpty()) {
            canNotBeShared.addAll(this.getLocalConfigurations());
            this.setStartupConfigurations(sharedConfigurations, canNotBeShared);
        }
    }

    public Collection<RunnerAndConfigurationSettings> getSharedConfigurations() {
        return this.getConfigurations(this.myShared);
    }

    public Collection<RunnerAndConfigurationSettings> getLocalConfigurations() {
        return this.getConfigurations(this.myLocal);
    }

    private Collection<RunnerAndConfigurationSettings> getConfigurations(ProjectStartupConfigurationBase configuration) {
        if (configuration.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RunnerAndConfigurationSettings> result2 = new ArrayList<RunnerAndConfigurationSettings>();
        List<ProjectStartupConfigurationBase.ConfigurationDescriptor> list2 = configuration.getList();
        RunManagerImpl runManager = (RunManagerImpl)RunManager.getInstance(this.myProject);
        for (ProjectStartupConfigurationBase.ConfigurationDescriptor descriptor2 : list2) {
            RunnerAndConfigurationSettings settings = runManager.getConfigurationById(descriptor2.getId());
            if (settings != null && settings.getName().equals(descriptor2.getName())) {
                result2.add(settings);
                continue;
            }
            NOTIFICATION_GROUP.createNotification(ExecutionBundle.message("0.run.configuration.1.not.found.removed.from.list", PREFIX, descriptor2.getName()), MessageType.WARNING).notify(this.myProject);
        }
        return result2;
    }

    public void rename(String oldId, RunnerAndConfigurationSettings settings) {
        if (this.myShared.rename(oldId, settings)) {
            return;
        }
        this.myLocal.rename(oldId, settings);
    }

    public void delete(String id2) {
        if (this.myShared.deleteConfiguration(id2)) {
            return;
        }
        this.myLocal.deleteConfiguration(id2);
    }

    public void setStartupConfigurations(@NotNull Collection<? extends RunnerAndConfigurationSettings> shared, @NotNull Collection<? extends RunnerAndConfigurationSettings> local) {
        if (shared == null) {
            ProjectStartupTaskManager.$$$reportNull$$$0(3);
        }
        if (local == null) {
            ProjectStartupTaskManager.$$$reportNull$$$0(4);
        }
        this.myShared.setConfigurations(shared);
        this.myLocal.setConfigurations(local);
    }

    public boolean isEmpty() {
        return this.myShared.isEmpty() && this.myLocal.isEmpty();
    }

    public void checkOnChange(RunnerAndConfigurationSettings settings) {
        Collection<RunnerAndConfigurationSettings> sharedConfigurations;
        if (!settings.isShared() && (sharedConfigurations = this.getSharedConfigurations()).remove(settings)) {
            ArrayList<RunnerAndConfigurationSettings> localConfigurations = new ArrayList<RunnerAndConfigurationSettings>(this.getLocalConfigurations());
            localConfigurations.add(settings);
            this.setStartupConfigurations(sharedConfigurations, localConfigurations);
            NOTIFICATION_GROUP.createNotification(ExecutionBundle.message("0.configuration.was.made.not.shared", PREFIX, settings.getName()), MessageType.WARNING).notify(this.myProject);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/startup/ProjectStartupTaskManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shared";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "local";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/startup/ProjectStartupTaskManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setStartupConfigurations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

