/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import com.intellij.execution.testframework.ui.TestsOutputConsolePrinter;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.IOUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositePrintable
extends UserDataHolderBase
implements Printable,
Disposable {
    public static final String NEW_LINE = "\n";
    protected final List<Printable> myNestedPrintables = new ArrayList<Printable>();
    private final PrintablesWrapper myWrapper = new PrintablesWrapper();
    protected int myExceptionMark;
    private int myCurrentSize = 0;
    private String myOutputFile = null;
    private String myFrameworkOutputFile;
    private static final ExecutorService ourTestExecutorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor("Tests Executor");
    private static final Logger LOG = Logger.getInstance(PrintablesWrapper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        List<Printable> list2 = this.myNestedPrintables;
        synchronized (list2) {
            this.myWrapper.flush(this.myNestedPrintables);
            this.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushOutputFile() {
        List<Printable> list2 = this.myNestedPrintables;
        synchronized (list2) {
            ArrayList<Printable> printables = new ArrayList<Printable>(this.myNestedPrintables);
            CompositePrintable.invokeInAlarm(() -> this.printOutputFile(printables));
        }
    }

    public static void invokeInAlarm(Runnable runnable2) {
        CompositePrintable.invokeInAlarm(runnable2, !ApplicationManager.getApplication().isDispatchThread() || ApplicationManager.getApplication().isUnitTestMode());
    }

    public static void invokeInAlarm(Runnable runnable2, boolean sync) {
        if (sync) {
            runnable2.run();
        } else {
            ourTestExecutorService.execute(runnable2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printOn(Printer printer) {
        ArrayList<Printable> printables;
        List<Printable> list2 = this.myNestedPrintables;
        synchronized (list2) {
            printables = new ArrayList<Printable>(this.myNestedPrintables);
        }
        this.myWrapper.printOn(printer, printables);
    }

    public void printOwnPrintablesOn(Printer printer) {
        this.printOwnPrintablesOn(printer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printOwnPrintablesOn(@NotNull Printer printer, boolean skipFileContent) {
        List<Printable> printables;
        if (printer == null) {
            CompositePrintable.$$$reportNull$$$0(0);
        }
        List<Printable> list2 = this.myNestedPrintables;
        synchronized (list2) {
            printables = ContainerUtil.filter(this.myNestedPrintables, printable -> !(printable instanceof AbstractTestProxy));
        }
        this.myWrapper.printOn(printer, printables, skipFileContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLast(@NotNull Printable printable) {
        if (printable == null) {
            CompositePrintable.$$$reportNull$$$0(1);
        }
        List<Printable> list2 = this.myNestedPrintables;
        synchronized (list2) {
            this.myNestedPrintables.add(printable);
            if (this.myNestedPrintables.size() > 500) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(@NotNull Printable printable, int i) {
        if (printable == null) {
            CompositePrintable.$$$reportNull$$$0(2);
        }
        List<Printable> list2 = this.myNestedPrintables;
        synchronized (list2) {
            if (i >= this.myNestedPrintables.size()) {
                this.myNestedPrintables.add(printable);
            } else {
                this.myNestedPrintables.add(i, printable);
            }
            if (this.myNestedPrintables.size() > 500) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        List<Printable> list2 = this.myNestedPrintables;
        synchronized (list2) {
            this.myCurrentSize += this.myNestedPrintables.size();
            this.myNestedPrintables.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentSize() {
        List<Printable> list2 = this.myNestedPrintables;
        synchronized (list2) {
            return this.myCurrentSize + this.myNestedPrintables.size();
        }
    }

    @Override
    public void dispose() {
        this.clear();
        this.myWrapper.dispose();
    }

    public int getExceptionMark() {
        return this.myExceptionMark;
    }

    public void setExceptionMark(int exceptionMark) {
        this.myExceptionMark = exceptionMark;
    }

    public void setOutputFilePath(String outputFile) {
        this.myOutputFile = outputFile;
    }

    public void setFrameworkOutputFile(String frameworkOutputFile) {
        this.myFrameworkOutputFile = frameworkOutputFile;
    }

    public void printFromFrameworkOutputFile(Printer console) {
        if (this.myFrameworkOutputFile != null) {
            Runnable runnable2 = () -> {
                File inputFile = new File(this.myFrameworkOutputFile);
                if (inputFile.exists()) {
                    try {
                        String fileText = FileUtil.loadFile(inputFile);
                        console.print(fileText, ConsoleViewContentType.NORMAL_OUTPUT);
                    }
                    catch (IOException e) {
                        LOG.error(e);
                    }
                }
            };
            CompositePrintable.invokeInAlarm(runnable2);
        }
    }

    protected DiffHyperlink createHyperlink(String expected, String actual, String filePath2, String actualFilePath, boolean printOneLine) {
        return new DiffHyperlink(expected, actual, filePath2, actualFilePath, printOneLine);
    }

    private void printOutputFile(List<? extends Printable> currentPrintables) {
        if (this.myOutputFile != null && new File(this.myOutputFile).isFile()) {
            try (final PrintStream printStream = new PrintStream(new FileOutputStream(new File(this.myOutputFile), true));){
                for (Printable printable : currentPrintables) {
                    printable.printOn(new Printer(){

                        @Override
                        public void print(String text2, ConsoleViewContentType contentType) {
                            if (contentType != ConsoleViewContentType.SYSTEM_OUTPUT) {
                                printStream.print(text2);
                            }
                        }

                        @Override
                        public void printHyperlink(String text2, HyperlinkInfo info) {
                            printStream.print(text2);
                        }

                        @Override
                        public void onNewAvailable(@NotNull Printable printable) {
                            if (printable == null) {
                                1.$$$reportNull$$$0(0);
                            }
                        }

                        @Override
                        public void mark() {
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printable", "com/intellij/execution/testframework/CompositePrintable$1", "onNewAvailable"));
                        }
                    });
                }
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/testframework/CompositePrintable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "printOwnPrintablesOn";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addLast";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "insert";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class PrintablesWrapper {
        private static final String HYPERLINK = "hyperlink";
        private File myFile;
        private final MyFlushToFilePrinter myPrinter = new MyFlushToFilePrinter();
        private final Object myFileLock = new Object();

        private PrintablesWrapper() {
        }

        @Nullable
        private synchronized File getFile() {
            if (this.myFile == null) {
                try {
                    File tempFile = FileUtil.createTempFile("idea_test_", ".out");
                    if (tempFile.exists()) {
                        this.myFile = tempFile;
                        return this.myFile;
                    }
                }
                catch (IOException e) {
                    LOG.error(e);
                    return null;
                }
            }
            return this.myFile;
        }

        public synchronized void dispose() {
            if (this.myFile != null) {
                FileUtil.delete(this.myFile);
            }
        }

        public synchronized boolean hasOutput() {
            return this.myFile != null;
        }

        public void flush(List<? extends Printable> printables) {
            if (printables.isEmpty()) {
                return;
            }
            ArrayList<? extends Printable> currentPrintables = new ArrayList<Printable>(printables);
            Runnable request2 = () -> {
                Object object = this.myFileLock;
                synchronized (object) {
                    for (Printable printable : currentPrintables) {
                        printable.printOn(this.myPrinter);
                    }
                    this.myPrinter.close();
                }
                CompositePrintable.this.printOutputFile(currentPrintables);
            };
            CompositePrintable.invokeInAlarm(request2, ApplicationManager.getApplication().isUnitTestMode());
        }

        public void printOn(Printer console, List<? extends Printable> printables) {
            this.printOn(console, printables, false);
        }

        public void printOn(Printer console, List<? extends Printable> printables, boolean skipFileContent) {
            Runnable request2 = () -> {
                if (skipFileContent) {
                    this.readFileContentAndPrint(console, null, printables);
                    return;
                }
                File file2 = this.hasOutput() ? this.getFile() : null;
                Object object = this.myFileLock;
                synchronized (object) {
                    this.readFileContentAndPrint(console, file2, printables);
                }
            };
            CompositePrintable.invokeInAlarm(request2);
        }

        private void readFileContentAndPrint(Printer printer, @Nullable File file2, List<? extends Printable> nestedPrintables) {
            if (file2 != null) {
                int lineNum = 0;
                Map<String, ConsoleViewContentType> contentTypeByNameMap = ContainerUtil.newMapFromValues(ConsoleViewContentType.getRegisteredTypes().iterator(), contentType -> contentType.toString());
                try (DataInputStream reader = new DataInputStream(new BufferedInputStream(new FileInputStream(file2)));){
                    while (reader.available() > 0 && !this.wasPrintableChanged(printer)) {
                        String firstToken;
                        if (lineNum == CompositePrintable.this.getExceptionMark() && lineNum > 0) {
                            printer.mark();
                        }
                        if ((firstToken = IOUtil.readString(reader)) == null) {
                            break;
                        }
                        if (firstToken.equals(HYPERLINK)) {
                            CompositePrintable.this.createHyperlink(IOUtil.readString(reader), IOUtil.readString(reader), IOUtil.readString(reader), IOUtil.readString(reader), false).printOn(printer);
                        } else {
                            ConsoleViewContentType contentType2 = contentTypeByNameMap.getOrDefault(firstToken, ConsoleViewContentType.NORMAL_OUTPUT);
                            String text2 = IOUtil.readString(reader);
                            if (text2 != null) {
                                this.printText(printer, text2, contentType2);
                            }
                        }
                        ++lineNum;
                    }
                }
                catch (FileNotFoundException e) {
                    LOG.info(e);
                }
                catch (IOException e) {
                    LOG.error(e);
                }
            }
            for (int i = 0; i < nestedPrintables.size(); ++i) {
                if (i == CompositePrintable.this.getExceptionMark() && i > 0) {
                    printer.mark();
                }
                nestedPrintables.get(i).printOn(printer);
            }
        }

        private void printText(@NotNull Printer printer, @NotNull String text2, @NotNull ConsoleViewContentType contentType) {
            if (printer == null) {
                PrintablesWrapper.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                PrintablesWrapper.$$$reportNull$$$0(1);
            }
            if (contentType == null) {
                PrintablesWrapper.$$$reportNull$$$0(2);
            }
            if (ConsoleViewContentType.NORMAL_OUTPUT.equals(contentType)) {
                printer.printWithAnsiColoring(text2, ProcessOutputTypes.STDOUT);
            } else if (ConsoleViewContentType.ERROR_OUTPUT.equals(contentType)) {
                printer.printWithAnsiColoring(text2, ProcessOutputTypes.STDERR);
            } else {
                printer.print(text2, contentType);
            }
        }

        private boolean wasPrintableChanged(Printer printer) {
            return printer instanceof TestsOutputConsolePrinter && !((TestsOutputConsolePrinter)printer).isCurrent(CompositePrintable.this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "printer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "contentType";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/testframework/CompositePrintable$PrintablesWrapper";
            objectArray[2] = "printText";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class MyFlushToFilePrinter
        implements Printer {
            private DataOutputStream myFileWriter;

            private MyFlushToFilePrinter() {
            }

            private DataOutputStream getFileWriter() {
                if (this.myFileWriter == null) {
                    try {
                        File file2 = PrintablesWrapper.this.getFile();
                        LOG.assertTrue(file2 != null);
                        this.myFileWriter = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file2, true)));
                    }
                    catch (FileNotFoundException e) {
                        LOG.info(e);
                        return null;
                    }
                }
                return this.myFileWriter;
            }

            private void close() {
                if (this.myFileWriter != null) {
                    try {
                        this.myFileWriter.close();
                    }
                    catch (FileNotFoundException e) {
                        LOG.info(e);
                    }
                    catch (IOException e) {
                        LOG.error(e);
                    }
                    this.myFileWriter = null;
                }
            }

            @Override
            public void print(String text2, ConsoleViewContentType contentType) {
                try {
                    DataOutputStream writer = this.getFileWriter();
                    if (writer != null) {
                        IOUtil.writeString(contentType.toString(), writer);
                        IOUtil.writeString(text2, writer);
                    }
                }
                catch (FileNotFoundException e) {
                    LOG.info(e);
                }
                catch (IOException e) {
                    LOG.error(e);
                }
            }

            @Override
            public void printHyperlink(String text2, HyperlinkInfo info) {
                if (info instanceof DiffHyperlink.DiffHyperlinkInfo) {
                    DiffHyperlink diffHyperlink = ((DiffHyperlink.DiffHyperlinkInfo)info).getPrintable();
                    try {
                        DataOutputStream fileWriter = this.getFileWriter();
                        if (fileWriter != null) {
                            IOUtil.writeString(PrintablesWrapper.HYPERLINK, fileWriter);
                            IOUtil.writeString(diffHyperlink.getLeft(), fileWriter);
                            IOUtil.writeString(diffHyperlink.getRight(), fileWriter);
                            IOUtil.writeString(diffHyperlink.getFilePath(), fileWriter);
                            IOUtil.writeString(diffHyperlink.getActualFilePath(), fileWriter);
                        }
                    }
                    catch (FileNotFoundException e) {
                        LOG.info(e);
                    }
                    catch (IOException e) {
                        LOG.error(e);
                    }
                } else {
                    this.print(text2, ConsoleViewContentType.NORMAL_OUTPUT);
                }
            }

            @Override
            public void onNewAvailable(@NotNull Printable printable) {
                if (printable == null) {
                    MyFlushToFilePrinter.$$$reportNull$$$0(0);
                }
            }

            @Override
            public void mark() {
            }

            @Override
            public void printWithAnsiColoring(@NotNull String text2, @NotNull Key processOutputType) {
                if (text2 == null) {
                    MyFlushToFilePrinter.$$$reportNull$$$0(1);
                }
                if (processOutputType == null) {
                    MyFlushToFilePrinter.$$$reportNull$$$0(2);
                }
                this.print(text2, ConsoleViewContentType.getConsoleViewType(processOutputType));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "printable";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "processOutputType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/execution/testframework/CompositePrintable$PrintablesWrapper$MyFlushToFilePrinter";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onNewAvailable";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "printWithAnsiColoring";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

