/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.execution.testframework.ui.BaseTestProxyNodeDescriptor;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class FailedTestsNavigator
implements OccurenceNavigator {
    private TestFrameworkRunningModel myModel;

    @Override
    public boolean hasNextOccurence() {
        return this.myModel != null && this.getNextOccurenceInfo().hasNextOccurence();
    }

    @Override
    public boolean hasPreviousOccurence() {
        return this.myModel != null && this.getPreviousOccurenceInfo().hasNextOccurence();
    }

    @Override
    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        FailedTestInfo result2 = this.getNextOccurenceInfo();
        this.myModel.selectAndNotify(result2.getDefect());
        return new OccurenceNavigator.OccurenceInfo(TestsUIUtil.getOpenFileDescriptor(result2.myDefect, this.myModel), result2.getDefectNumber(), result2.getDefectsCount());
    }

    public void setModel(TestFrameworkRunningModel model) {
        this.myModel = model;
        Disposer.register(this.myModel, new Disposable(){

            @Override
            public void dispose() {
                FailedTestsNavigator.this.myModel = null;
            }
        });
    }

    @Override
    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        FailedTestInfo result2 = this.getPreviousOccurenceInfo();
        this.myModel.selectAndNotify(result2.getDefect());
        return new OccurenceNavigator.OccurenceInfo(TestsUIUtil.getOpenFileDescriptor(result2.myDefect, this.myModel), result2.getDefectNumber(), result2.getDefectsCount());
    }

    @Override
    @NotNull
    public String getNextOccurenceActionName() {
        String string = FailedTestsNavigator.getNextName();
        if (string == null) {
            FailedTestsNavigator.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPreviousOccurenceActionName() {
        String string = FailedTestsNavigator.getPreviousName();
        if (string == null) {
            FailedTestsNavigator.$$$reportNull$$$0(1);
        }
        return string;
    }

    private FailedTestInfo getNextOccurenceInfo() {
        return new NextFailedTestInfo().execute();
    }

    private FailedTestInfo getPreviousOccurenceInfo() {
        return new PreviousFailedTestInfo().execute();
    }

    static String getNextName() {
        return ExecutionBundle.message("next.faled.test.action.name", new Object[0]);
    }

    static String getPreviousName() {
        return ExecutionBundle.message("prev.faled.test.action.name", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/execution/testframework/FailedTestsNavigator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextOccurenceActionName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviousOccurenceActionName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class PreviousFailedTestInfo
    extends FailedTestInfo {
        private PreviousFailedTestInfo() {
        }

        @Override
        protected int nextIndex(int defectIndex) {
            return defectIndex - 1;
        }

        @Override
        protected int getBoundIndex() {
            return 0;
        }
    }

    private class NextFailedTestInfo
    extends FailedTestInfo {
        private NextFailedTestInfo() {
        }

        @Override
        protected int nextIndex(int defectIndex) {
            return defectIndex + 1;
        }

        @Override
        protected int getBoundIndex() {
            return this.getDefectsCount() - 1;
        }
    }

    protected abstract class FailedTestInfo {
        private AbstractTestProxy myDefect = null;
        private List<AbstractTestProxy> myAllTests;
        private List<AbstractTestProxy> myDefects;

        protected FailedTestInfo() {
        }

        public AbstractTestProxy getDefect() {
            return this.myDefect;
        }

        private int getDefectNumber() {
            return this.myDefect == null ? this.getDefectsCount() : this.myDefects.indexOf(this.myDefect) + 1;
        }

        public FailedTestInfo execute() {
            this.myAllTests = new ArrayList<AbstractTestProxy>();
            this.collectTests(this.myAllTests, (TreeNode)FailedTestsNavigator.this.myModel.getTreeView().getModel().getRoot());
            this.myDefects = Filter.DEFECTIVE_LEAF.select(this.myAllTests);
            if (this.myDefects.isEmpty()) {
                return this;
            }
            AbstractTestProxy selectedTest = FailedTestsNavigator.this.myModel.getTreeView().getSelectedTest();
            int selectionIndex = this.myAllTests.indexOf(selectedTest);
            if (selectionIndex == -1) {
                return this;
            }
            AbstractTestProxy defect = this.findNextDefect(selectionIndex);
            if (defect == null) {
                return this;
            }
            if (defect != selectedTest) {
                this.myDefect = defect;
                return this;
            }
            int defectIndex = this.myDefects.indexOf(defect);
            if (defectIndex == -1 || defectIndex == this.getBoundIndex()) {
                return this;
            }
            this.myDefect = this.myDefects.get(this.nextIndex(defectIndex));
            return this;
        }

        private void collectTests(List<? super AbstractTestProxy> tests, TreeNode node) {
            if (node == null) {
                return;
            }
            Object elementFor = TreeUtil.getUserObject(node);
            if (elementFor instanceof BaseTestProxyNodeDescriptor) {
                elementFor = ((BaseTestProxyNodeDescriptor)elementFor).getElement();
            }
            if (elementFor instanceof AbstractTestProxy) {
                tests.add((AbstractTestProxy)elementFor);
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.collectTests(tests, node.getChildAt(i));
            }
        }

        private AbstractTestProxy findNextDefect(int startIndex) {
            int i = this.nextIndex(startIndex);
            while (0 <= i && i < this.myAllTests.size()) {
                AbstractTestProxy nextDefect = this.myAllTests.get(i);
                if (Filter.DEFECTIVE_LEAF.shouldAccept(nextDefect)) {
                    return nextDefect;
                }
                i = this.nextIndex(i);
            }
            return null;
        }

        protected abstract int nextIndex(int var1);

        protected abstract int getBoundIndex();

        protected int getDefectsCount() {
            return this.myDefects.size();
        }

        private boolean hasNextOccurence() {
            return this.myDefect != null;
        }
    }
}

