/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.execution.testframework.ui.AbstractTestTreeBuilderBase;
import com.intellij.execution.testframework.ui.BaseTestProxyNodeDescriptor;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Comparing;
import java.util.Comparator;

public interface TestFrameworkRunningModel
extends Disposable {
    public TestConsoleProperties getProperties();

    public void setFilter(Filter<?> var1);

    public boolean isRunning();

    public TestTreeView getTreeView();

    public AbstractTestTreeBuilderBase<?> getTreeBuilder();

    public boolean hasTestSuites();

    public AbstractTestProxy getRoot();

    public void selectAndNotify(AbstractTestProxy var1);

    default public Comparator<NodeDescriptor<?>> createComparator() {
        TestConsoleProperties properties = this.getProperties();
        Comparator comparator2 = TestConsoleProperties.SORT_BY_DURATION.value(properties) && !this.isRunning() ? (o1, o2) -> {
            if (o1.getParentDescriptor() == o2.getParentDescriptor() && o1 instanceof BaseTestProxyNodeDescriptor && o2 instanceof BaseTestProxyNodeDescriptor) {
                Long d1 = ((AbstractTestProxy)((BaseTestProxyNodeDescriptor)o1).getElement()).getDuration();
                Long d2 = ((AbstractTestProxy)((BaseTestProxyNodeDescriptor)o2).getElement()).getDuration();
                return Comparing.compare(d2, d1);
            }
            return 0;
        } : (TestConsoleProperties.SORT_ALPHABETICALLY.value(properties) ? AlphaComparator.INSTANCE : null);
        return comparator2;
    }
}

