/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Location;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestRunnerBundle;
import com.intellij.execution.testframework.TestStatusListener;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.wm.AppIconScheme;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.ui.AppIcon;
import com.intellij.ui.SystemNotifications;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestsUIUtil {
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.logOnlyGroup("Test Runner");
    public static final Color PASSED_COLOR = new Color(0, 128, 0);
    private static final String TESTS = "tests";

    private TestsUIUtil() {
    }

    @Nullable
    public static Object getData(AbstractTestProxy testProxy, @NotNull String dataId, TestFrameworkRunningModel model) {
        RunProfile configuration;
        if (dataId == null) {
            TestsUIUtil.$$$reportNull$$$0(0);
        }
        TestConsoleProperties properties = model.getProperties();
        Project project2 = properties.getProject();
        if (testProxy == null) {
            return null;
        }
        if (AbstractTestProxy.DATA_KEY.is(dataId)) {
            return testProxy;
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            return TestsUIUtil.getOpenFileDescriptor(testProxy, model);
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            Location location2 = testProxy.getLocation(project2, properties.getScope());
            if (location2 != null) {
                Object element2 = location2.getPsiElement();
                return element2.isValid() ? element2 : null;
            }
            return null;
        }
        if (Location.DATA_KEY.is(dataId)) {
            return testProxy.getLocation(project2, properties.getScope());
        }
        if (RunConfiguration.DATA_KEY.is(dataId) && (configuration = properties.getConfiguration()) instanceof RunConfiguration) {
            return configuration;
        }
        return null;
    }

    public static boolean isMultipleSelectionImpossible(DataContext dataContext) {
        Component component2 = PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
        if (component2 instanceof JTree) {
            Object lastPathComponent;
            TreePath[] selectionPaths = ((JTree)component2).getSelectionPaths();
            if (selectionPaths == null || selectionPaths.length == 0) {
                return true;
            }
            if (selectionPaths.length == 1 && (lastPathComponent = selectionPaths[0].getLastPathComponent()) instanceof TreeNode && ((TreeNode)lastPathComponent).isLeaf()) {
                return true;
            }
        }
        return false;
    }

    public static Navigatable getOpenFileDescriptor(AbstractTestProxy testProxy, TestFrameworkRunningModel model) {
        TestConsoleProperties testConsoleProperties = model.getProperties();
        return TestsUIUtil.getOpenFileDescriptor(testProxy, testConsoleProperties, TestConsoleProperties.OPEN_FAILURE_LINE.value(testConsoleProperties));
    }

    private static Navigatable getOpenFileDescriptor(AbstractTestProxy proxy, TestConsoleProperties testConsoleProperties, boolean openFailureLine) {
        Project project2 = testConsoleProperties.getProject();
        if (proxy != null) {
            OpenFileDescriptor openFileDescriptor;
            Location location2 = proxy.getLocation(project2, testConsoleProperties.getScope());
            if (openFailureLine) {
                return proxy.getDescriptor(location2, testConsoleProperties);
            }
            OpenFileDescriptor openFileDescriptor2 = openFileDescriptor = location2 == null ? null : location2.getOpenFileDescriptor();
            if (openFileDescriptor != null && openFileDescriptor.getFile().isValid()) {
                return openFileDescriptor;
            }
        }
        return null;
    }

    public static void notifyByBalloon(@NotNull Project project2, boolean started, AbstractTestProxy root, TestConsoleProperties properties, @Nullable String comment) {
        if (project2 == null) {
            TestsUIUtil.$$$reportNull$$$0(1);
        }
        TestsUIUtil.notifyByBalloon(project2, root, properties, new TestResultPresentation(root, started, comment).getPresentation());
    }

    public static void notifyByBalloon(@NotNull Project project2, AbstractTestProxy root, TestConsoleProperties properties, TestResultPresentation testResultPresentation) {
        if (project2 == null) {
            TestsUIUtil.$$$reportNull$$$0(2);
        }
        if (project2.isDisposed()) {
            return;
        }
        if (properties == null) {
            return;
        }
        TestStatusListener.notifySuiteFinished(root, properties.getProject());
        String windowId = properties.getWindowId();
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance(project2);
        String title = testResultPresentation.getTitle();
        String text2 = testResultPresentation.getText();
        String balloonText = testResultPresentation.getBalloonText();
        MessageType type = testResultPresentation.getType();
        if (!Comparing.strEqual(toolWindowManager.getActiveToolWindowId(), windowId)) {
            String displayId = TestsUIUtil.getTestResultsNotificationDisplayId(windowId);
            NotificationGroup group = NotificationGroup.findRegisteredGroup(displayId);
            if (group == null) {
                group = NotificationGroup.toolWindowGroup(displayId, windowId);
            }
            group.createNotification(balloonText, type).notify(project2);
        }
        NOTIFICATION_GROUP.createNotification(balloonText, type).notify(project2);
        SystemNotifications.getInstance().notify("TestRunner", title, text2);
    }

    private static String getTestResultsNotificationDisplayId(@NotNull String toolWindowId) {
        if (toolWindowId == null) {
            TestsUIUtil.$$$reportNull$$$0(3);
        }
        return "Test Results: " + toolWindowId;
    }

    public static String getTestSummary(AbstractTestProxy proxy) {
        return new TestResultPresentation(proxy).getPresentation().getBalloonText();
    }

    public static String getTestShortSummary(AbstractTestProxy proxy) {
        return new TestResultPresentation(proxy).getPresentation().getText();
    }

    public static void showIconProgress(Project project2, int n, int maximum, int problemsCounter, boolean updateWithAttention) {
        AppIcon icon2 = AppIcon.getInstance();
        if (n < maximum || !updateWithAttention) {
            if ((!updateWithAttention || icon2.setProgress(project2, TESTS, AppIconScheme.Progress.TESTS, (double)n / (double)maximum, problemsCounter == 0)) && problemsCounter > 0) {
                icon2.setErrorBadge(project2, String.valueOf(problemsCounter));
            }
        } else if (icon2.hideProgress(project2, TESTS)) {
            if (problemsCounter > 0) {
                icon2.setErrorBadge(project2, String.valueOf(problemsCounter));
            } else {
                icon2.setOkBadge(project2, true);
            }
            icon2.requestAttention(project2, false);
        }
    }

    public static void clearIconProgress(Project project2) {
        AppIcon.getInstance().hideProgress(project2, TESTS);
        AppIcon.getInstance().setErrorBadge(project2, null);
    }

    static {
        NotificationGroup.toolWindowGroup(TestsUIUtil.getTestResultsNotificationDisplayId("Run"), "Run");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/testframework/TestsUIUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyByBalloon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getTestResultsNotificationDisplayId";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class TestResultPresentation {
        private final AbstractTestProxy myRoot;
        private final boolean myStarted;
        private final String myComment;
        private String myTitle;
        private String myText;
        private String myBalloonText;
        private MessageType myType;
        private int myFailedCount;
        private int myPassedCount;
        private int myNotStartedCount;
        private int myIgnoredCount;

        public TestResultPresentation(AbstractTestProxy root, boolean started, String comment) {
            this.myRoot = root;
            this.myStarted = started;
            this.myComment = comment;
        }

        public TestResultPresentation(AbstractTestProxy root) {
            this(root, true, null);
        }

        public String getTitle() {
            return this.myTitle;
        }

        public String getText() {
            return this.myText;
        }

        public String getBalloonText() {
            return this.myBalloonText;
        }

        public MessageType getType() {
            return this.myType;
        }

        @Deprecated
        public int getFailedCount() {
            return this.myFailedCount;
        }

        @Deprecated
        public int getPassedCount() {
            return this.myPassedCount;
        }

        @Deprecated
        public int getNotStartedCount() {
            return this.myNotStartedCount;
        }

        @Deprecated
        public int getIgnoredCount() {
            return this.myIgnoredCount;
        }

        public TestResultPresentation getPresentation() {
            List<? extends AbstractTestProxy> allTests = Filter.LEAF.select(this.myRoot.getAllTests());
            List<? extends AbstractTestProxy> failed = Filter.DEFECTIVE_LEAF.select(allTests);
            List<? extends AbstractTestProxy> notStarted = Filter.NOT_PASSED.select(allTests);
            notStarted.removeAll(failed);
            List<? extends AbstractTestProxy> ignored = Filter.IGNORED.select(allTests);
            notStarted.removeAll(ignored);
            failed.removeAll(ignored);
            int failedCount = failed.size();
            int notStartedCount = notStarted.size() + ignored.size();
            int passedCount = allTests.size() - failedCount - notStartedCount;
            return this.getPresentation(failedCount, passedCount, notStartedCount, ignored.size());
        }

        public TestResultPresentation getPresentation(int failedCount, int passedCount, int notStartedCount, int ignoredCount) {
            if (this.myRoot == null) {
                this.myTitle = this.myStarted ? TestRunnerBundle.message("test.interrupted.progress.text", new Object[0]) : ExecutionBundle.message("test.not.started.progress.text", new Object[0]);
                this.myBalloonText = this.myTitle;
                this.myText = "";
                this.myType = MessageType.WARNING;
            } else {
                this.myFailedCount = failedCount;
                this.myPassedCount = passedCount;
                this.myNotStartedCount = notStartedCount;
                this.myIgnoredCount = ignoredCount;
                if (failedCount > 0) {
                    this.myTitle = ExecutionBundle.message("junit.runing.info.tests.failed.label", new Object[0]);
                    this.myBalloonText = TestRunnerBundle.message("tests.failed.0.passed.1.ignored.2.not.started.3", failedCount, passedCount, ignoredCount, notStartedCount);
                    this.myText = TestRunnerBundle.message("0.failed.1.passed.2.ignored.3.not.started", failedCount, passedCount, ignoredCount, notStartedCount);
                    this.myType = MessageType.ERROR;
                } else if (ignoredCount > 0) {
                    this.myTitle = TestRunnerBundle.message("tests.ignored.error.message", new Object[0]);
                    this.myBalloonText = TestRunnerBundle.message("tests.ignored.0.passed.1", ignoredCount, passedCount);
                    this.myText = TestRunnerBundle.message("0.ignored.1.passed", ignoredCount, passedCount);
                    this.myType = MessageType.WARNING;
                } else if (notStartedCount > 0) {
                    this.myTitle = ExecutionBundle.message("junit.running.info.failed.to.start.error.message", new Object[0]);
                    this.myBalloonText = TestRunnerBundle.message("failed.to.start.0.passed.1", notStartedCount, passedCount);
                    this.myText = TestRunnerBundle.message("0.not.started.1.passed", notStartedCount, passedCount);
                    this.myType = MessageType.ERROR;
                } else {
                    this.myTitle = ExecutionBundle.message("junit.runing.info.tests.passed.label", new Object[0]);
                    this.myBalloonText = TestRunnerBundle.message("tests.passed.0", passedCount);
                    this.myText = TestRunnerBundle.message("0.passed", passedCount);
                    this.myType = MessageType.INFO;
                }
                if (this.myComment != null) {
                    this.myText = this.myText + " " + this.myComment;
                }
            }
            return this;
        }
    }
}

