/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.testframework.FailedTestsNavigator;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkPropertyListener;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.ToggleModelAction;
import com.intellij.execution.testframework.ToggleModelActionProvider;
import com.intellij.execution.testframework.actions.ScrollToTestSourceAction;
import com.intellij.execution.testframework.actions.TestFrameworkActions;
import com.intellij.execution.testframework.actions.TestTreeExpander;
import com.intellij.execution.testframework.autotest.AdjustAutotestDelayActionGroup;
import com.intellij.execution.testframework.export.ExportTestResultsAction;
import com.intellij.execution.testframework.ui.AbstractTestTreeBuilderBase;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.util.config.DumbAwareToggleBooleanProperty;
import com.intellij.util.config.DumbAwareToggleInvertedBooleanProperty;
import com.intellij.util.config.ToggleBooleanProperty;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolbarPanel
extends JPanel
implements OccurenceNavigator,
Disposable {
    private static final Logger LOG = Logger.getInstance(ToolbarPanel.class);
    protected final TestTreeExpander myTreeExpander = new TestTreeExpander();
    protected final FailedTestsNavigator myOccurenceNavigator;
    protected final ScrollToTestSourceAction myScrollToSource;
    @Nullable
    private ExportTestResultsAction myExportAction;
    private final ArrayList<ToggleModelAction> myActions = new ArrayList();

    public ToolbarPanel(TestConsoleProperties properties, JComponent parent) {
        super(new BorderLayout());
        RunProfile configuration;
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.addAction(new DumbAwareToggleInvertedBooleanProperty(ExecutionBundle.message("junit.run.hide.passed.action.name", new Object[0]), ExecutionBundle.message("junit.run.hide.passed.action.description", new Object[0]), AllIcons.RunConfigurations.ShowPassed, properties, TestConsoleProperties.HIDE_PASSED_TESTS));
        actionGroup.add(new DumbAwareToggleInvertedBooleanProperty("Show Ignored", "Show Ignored", AllIcons.RunConfigurations.ShowIgnored, properties, TestConsoleProperties.HIDE_IGNORED_TEST));
        actionGroup.addSeparator();
        actionGroup.addAction(new DumbAwareToggleBooleanProperty(ExecutionBundle.message("junit.runing.info.sort.alphabetically.action.name", new Object[0]), ExecutionBundle.message("junit.runing.info.sort.alphabetically.action.description", new Object[0]), AllIcons.ObjectBrowser.Sorted, properties, TestConsoleProperties.SORT_ALPHABETICALLY));
        SortByDurationAction sortByStatistics = new SortByDurationAction(properties);
        this.myActions.add(sortByStatistics);
        actionGroup.addAction(sortByStatistics);
        actionGroup.addSeparator();
        AnAction action2 = CommonActionsManager.getInstance().createExpandAllAction(this.myTreeExpander, parent);
        action2.getTemplatePresentation().setDescription(ExecutionBundle.messagePointer("junit.runing.info.expand.test.action.name", new Object[0]));
        actionGroup.add(action2);
        action2 = CommonActionsManager.getInstance().createCollapseAllAction(this.myTreeExpander, parent);
        action2.getTemplatePresentation().setDescription(ExecutionBundle.messagePointer("junit.runing.info.collapse.test.action.name", new Object[0]));
        actionGroup.add(action2);
        actionGroup.addSeparator();
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        this.myOccurenceNavigator = new FailedTestsNavigator();
        actionGroup.add(actionsManager.createPrevOccurenceAction(this.myOccurenceNavigator));
        actionGroup.add(actionsManager.createNextOccurenceAction(this.myOccurenceNavigator));
        for (ToggleModelActionProvider actionProvider : ToggleModelActionProvider.EP_NAME.getExtensionList()) {
            ToggleModelAction toggleModelAction = actionProvider.createToggleModelAction(properties);
            this.myActions.add(toggleModelAction);
            actionGroup.add(toggleModelAction);
        }
        AnAction[] importActions = properties.createImportActions();
        if (importActions != null) {
            actionGroup.addAll(importActions);
        }
        if ((configuration = properties.getConfiguration()) instanceof RunConfiguration) {
            this.myExportAction = ExportTestResultsAction.create(properties.getExecutor().getToolWindowId(), (RunConfiguration)configuration, parent);
            actionGroup.addAction(this.myExportAction);
        }
        DefaultActionGroup secondaryGroup = new DefaultActionGroup();
        secondaryGroup.setPopup(true);
        secondaryGroup.getTemplatePresentation().setIcon(AllIcons.General.GearPlain);
        secondaryGroup.add(new DumbAwareToggleBooleanProperty(ExecutionBundle.message("junit.runing.info.track.test.action.name", new Object[0]), ExecutionBundle.message("junit.runing.info.track.test.action.description", new Object[0]), null, properties, TestConsoleProperties.TRACK_RUNNING_TEST));
        secondaryGroup.add(new DumbAwareToggleBooleanProperty("Show Inline Statistics", "Toggle the visibility of the test duration in the tree", null, properties, TestConsoleProperties.SHOW_INLINE_STATISTICS));
        secondaryGroup.addSeparator();
        secondaryGroup.add(new DumbAwareToggleBooleanProperty(ExecutionBundle.message("junit.runing.info.scroll.to.stacktrace.action.name", new Object[0]), ExecutionBundle.message("junit.runing.info.scroll.to.stacktrace.action.description", new Object[0]), null, properties, TestConsoleProperties.SCROLL_TO_STACK_TRACE));
        secondaryGroup.add(new ToggleBooleanProperty(ExecutionBundle.message("junit.runing.info.open.source.at.exception.action.name", new Object[0]), ExecutionBundle.message("junit.runing.info.open.source.at.exception.action.description", new Object[0]), null, properties, TestConsoleProperties.OPEN_FAILURE_LINE));
        this.myScrollToSource = new ScrollToTestSourceAction(properties);
        secondaryGroup.add(this.myScrollToSource);
        secondaryGroup.add(new AdjustAutotestDelayActionGroup(parent));
        secondaryGroup.addSeparator();
        secondaryGroup.add(new DumbAwareToggleBooleanProperty(ExecutionBundle.message("junit.runing.info.select.first.failed.action.name", new Object[0]), null, null, properties, TestConsoleProperties.SELECT_FIRST_DEFECT));
        properties.appendAdditionalActions(secondaryGroup, parent, properties);
        actionGroup.add(secondaryGroup);
        this.add((Component)ActionManager.getInstance().createActionToolbar("TestTreeViewToolbar", actionGroup, true).getComponent(), "Center");
    }

    public void setModel(TestFrameworkRunningModel model) {
        TestFrameworkActions.installFilterAction(model);
        this.myScrollToSource.setModel(model);
        this.myTreeExpander.setModel(model);
        this.myOccurenceNavigator.setModel(model);
        if (this.myExportAction != null) {
            this.myExportAction.setModel(model);
        }
        for (ToggleModelAction action2 : this.myActions) {
            action2.setModel(model);
        }
        TestFrameworkActions.addPropertyListener(TestConsoleProperties.SORT_ALPHABETICALLY, ToolbarPanel.createComparatorPropertyListener(model), model, true);
        TestFrameworkActions.addPropertyListener(TestConsoleProperties.SORT_BY_DURATION, ToolbarPanel.createComparatorPropertyListener(model), model, true);
    }

    private static TestFrameworkPropertyListener<Boolean> createComparatorPropertyListener(final TestFrameworkRunningModel model) {
        return new TestFrameworkPropertyListener<Boolean>(){

            @Override
            public void onChanged(Boolean value2) {
                try {
                    AbstractTestTreeBuilderBase builder2 = (AbstractTestTreeBuilderBase)model.getClass().getMethod("getTreeBuilder", new Class[0]).invoke((Object)model, new Object[0]);
                    if (builder2 != null) {
                        builder2.setTestsComparator(model);
                    }
                }
                catch (Exception e) {
                    LOG.error(e);
                }
            }
        };
    }

    @Override
    public boolean hasNextOccurence() {
        return this.myOccurenceNavigator.hasNextOccurence();
    }

    @Override
    public boolean hasPreviousOccurence() {
        return this.myOccurenceNavigator.hasPreviousOccurence();
    }

    @Override
    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.myOccurenceNavigator.goNextOccurence();
    }

    @Override
    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.myOccurenceNavigator.goPreviousOccurence();
    }

    @Override
    @NotNull
    public String getNextOccurenceActionName() {
        String string = this.myOccurenceNavigator.getNextOccurenceActionName();
        if (string == null) {
            ToolbarPanel.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPreviousOccurenceActionName() {
        String string = this.myOccurenceNavigator.getPreviousOccurenceActionName();
        if (string == null) {
            ToolbarPanel.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public void dispose() {
        this.myScrollToSource.setModel(null);
        if (this.myExportAction != null) {
            this.myExportAction.setModel(null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/execution/testframework/ToolbarPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextOccurenceActionName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviousOccurenceActionName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SortByDurationAction
    extends ToggleModelAction
    implements DumbAware {
        private TestFrameworkRunningModel myModel;

        SortByDurationAction(TestConsoleProperties properties) {
            super(ExecutionBundle.message("junit.runing.info.sort.by.statistics.action.name", new Object[0]), ExecutionBundle.message("junit.runing.info.sort.by.statistics.action.description", new Object[0]), AllIcons.RunConfigurations.SortbyDuration, properties, TestConsoleProperties.SORT_BY_DURATION);
        }

        @Override
        protected boolean isEnabled() {
            TestFrameworkRunningModel model = this.myModel;
            return model != null && !model.isRunning();
        }

        @Override
        public void setModel(TestFrameworkRunningModel model) {
            this.myModel = model;
        }
    }
}

