/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.PredefinedLogFile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.WrappingRunConfiguration;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.search.GlobalSearchScope;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRerunFailedTestsAction
extends AnAction
implements AnAction.TransparentUpdate {
    private static final Logger LOG = Logger.getInstance(AbstractRerunFailedTestsAction.class);
    private TestFrameworkRunningModel myModel;
    private Getter<? extends TestFrameworkRunningModel> myModelProvider;
    protected TestConsoleProperties myConsoleProperties;

    protected AbstractRerunFailedTestsAction(@NotNull ComponentContainer componentContainer) {
        if (componentContainer == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(0);
        }
        ActionUtil.copyFrom(this, "RerunFailedTests");
        this.registerCustomShortcutSet(this.getShortcutSet(), componentContainer.getComponent());
    }

    public void init(TestConsoleProperties consoleProperties) {
        this.myConsoleProperties = consoleProperties;
    }

    public void setModel(TestFrameworkRunningModel model) {
        this.myModel = model;
    }

    public void setModelProvider(Getter<? extends TestFrameworkRunningModel> modelProvider) {
        this.myModelProvider = modelProvider;
    }

    @Override
    public final void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabled(this.isActive(e));
    }

    private boolean isActive(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(2);
        }
        if ((project2 = e.getProject()) == null) {
            return false;
        }
        TestFrameworkRunningModel model = this.getModel();
        if (model == null || model.getRoot() == null) {
            return false;
        }
        ExecutionEnvironment environment2 = e.getData(LangDataKeys.EXECUTION_ENVIRONMENT);
        if (environment2 == null) {
            return false;
        }
        RunnerAndConfigurationSettings settings = environment2.getRunnerAndConfigurationSettings();
        if (settings != null && !settings.getType().isDumbAware() && DumbService.isDumb(project2)) {
            return false;
        }
        Filter<?> filter2 = this.getFailuresFilter();
        for (AbstractTestProxy abstractTestProxy : model.getRoot().getAllTests()) {
            if (!filter2.shouldAccept(abstractTestProxy)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected List<AbstractTestProxy> getFailedTests(@NotNull Project project2) {
        TestFrameworkRunningModel model;
        if (project2 == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(3);
        }
        if ((model = this.getModel()) == null) {
            List<AbstractTestProxy> list2 = Collections.emptyList();
            if (list2 == null) {
                AbstractRerunFailedTestsAction.$$$reportNull$$$0(4);
            }
            return list2;
        }
        List<AbstractTestProxy> list3 = this.getFilter(project2, model.getProperties().getScope()).select(model.getRoot().getAllTests());
        if (list3 == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(5);
        }
        return list3;
    }

    @NotNull
    protected Filter getFilter(@NotNull Project project2, @NotNull GlobalSearchScope searchScope) {
        if (project2 == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(6);
        }
        if (searchScope == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(7);
        }
        Filter<?> filter2 = this.getFailuresFilter();
        if (filter2 == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(8);
        }
        return filter2;
    }

    protected Filter<?> getFailuresFilter() {
        return AbstractRerunFailedTestsAction.getFailuresFilter(this.myConsoleProperties);
    }

    public static Filter<?> getFailuresFilter(TestConsoleProperties consoleProperties) {
        if (TestConsoleProperties.INCLUDE_NON_STARTED_IN_RERUN_FAILED.value(consoleProperties)) {
            return Filter.NOT_PASSED.or(Filter.FAILED_OR_INTERRUPTED).and(Filter.IGNORED.not());
        }
        return Filter.FAILED_OR_INTERRUPTED.and(Filter.IGNORED.not());
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        ExecutionEnvironment environment2;
        if (e == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(9);
        }
        if ((environment2 = e.getData(LangDataKeys.EXECUTION_ENVIRONMENT)) == null) {
            return;
        }
        this.execute(e, environment2);
    }

    void execute(@NotNull AnActionEvent e, @NotNull ExecutionEnvironment environment2) {
        MyRunProfile profile;
        if (e == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(10);
        }
        if (environment2 == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(11);
        }
        if ((profile = this.getRunProfile(environment2)) == null) {
            return;
        }
        ExecutionEnvironmentBuilder environmentBuilder = new ExecutionEnvironmentBuilder(environment2).runProfile(profile);
        InputEvent event = e.getInputEvent();
        if (!(event instanceof MouseEvent) || !event.isShiftDown()) {
            AbstractRerunFailedTestsAction.performAction(environmentBuilder);
            return;
        }
        LinkedHashMap<Executor, ProgramRunner<RunnerSettings>> availableRunners = new LinkedHashMap<Executor, ProgramRunner<RunnerSettings>>();
        for (Executor ex : new Executor[]{DefaultRunExecutor.getRunExecutorInstance(), DefaultDebugExecutor.getDebugExecutorInstance()}) {
            ProgramRunner<RunnerSettings> runner = ProgramRunner.getRunner(ex.getId(), profile);
            if (runner == null) continue;
            availableRunners.put(ex, runner);
        }
        if (availableRunners.isEmpty()) {
            LOG.error(environment2.getExecutor().getActionName() + " is not available now");
        } else if (availableRunners.size() == 1) {
            AbstractRerunFailedTestsAction.performAction(environmentBuilder.runner((ProgramRunner)availableRunners.get(environment2.getExecutor())));
        } else {
            ArrayList model = new ArrayList(availableRunners.keySet());
            JBPopupFactory.getInstance().createPopupChooserBuilder(model).setSelectionMode(0).setSelectedValue(environment2.getExecutor(), true).setRenderer(new DefaultListCellRenderer(){

                @Override
                @NotNull
                public Component getListCellRendererComponent(@NotNull JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                    if (list2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Component component2 = super.getListCellRendererComponent((JList<?>)list2, value2, index, isSelected, cellHasFocus);
                    if (value2 instanceof Executor) {
                        this.setText(((Executor)value2).getActionName());
                        this.setIcon(((Executor)value2).getIcon());
                    }
                    Component component3 = component2;
                    if (component3 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return component3;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "list";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getListCellRendererComponent";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getListCellRendererComponent";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }).setTitle("Restart Failed Tests").setMovable(false).setResizable(false).setRequestFocus(true).setItemChosenCallback(value2 -> AbstractRerunFailedTestsAction.performAction(environmentBuilder.runner((ProgramRunner)availableRunners.get(value2)).executor((Executor)value2))).createPopup().showUnderneathOf(event.getComponent());
        }
    }

    private static void performAction(@NotNull ExecutionEnvironmentBuilder builder2) {
        if (builder2 == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(12);
        }
        ExecutionEnvironment environment2 = builder2.build();
        try {
            environment2.getRunner().execute(environment2);
        }
        catch (ExecutionException e) {
            LOG.error(e);
        }
        finally {
            ((MyRunProfile)environment2.getRunProfile()).clear();
        }
    }

    @Deprecated
    public MyRunProfile getRunProfile() {
        return null;
    }

    @Nullable
    protected MyRunProfile getRunProfile(@NotNull ExecutionEnvironment environment2) {
        if (environment2 == null) {
            AbstractRerunFailedTestsAction.$$$reportNull$$$0(13);
        }
        return this.getRunProfile();
    }

    @Nullable
    public TestFrameworkRunningModel getModel() {
        if (this.myModel != null) {
            return this.myModel;
        }
        if (this.myModelProvider != null) {
            return this.myModelProvider.get();
        }
        return null;
    }

    @Override
    public boolean isDumbAware() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentContainer";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFailedTests";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isActive";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFailedTests";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFilter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "performAction";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRunProfile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static abstract class MyRunProfile
    extends RunConfigurationBase<Element>
    implements ModuleRunProfile,
    WrappingRunConfiguration<RunConfigurationBase> {
        private final RunConfigurationBase myConfiguration;

        @Deprecated
        public RunConfigurationBase getConfiguration() {
            return this.getPeer();
        }

        @Override
        public RunConfigurationBase getPeer() {
            return this.myConfiguration;
        }

        public MyRunProfile(RunConfigurationBase configuration) {
            super(configuration.getProject(), configuration.getFactory(), ActionsBundle.message("action.RerunFailedTests.text", new Object[0]));
            this.myConfiguration = configuration;
        }

        public void clear() {
        }

        @Override
        public void readExternal(@NotNull Element element2) throws InvalidDataException {
            if (element2 == null) {
                MyRunProfile.$$$reportNull$$$0(0);
            }
            this.myConfiguration.readExternal(element2);
        }

        @Override
        public void writeExternal(@NotNull Element element2) throws WriteExternalException {
            if (element2 == null) {
                MyRunProfile.$$$reportNull$$$0(1);
            }
            this.myConfiguration.writeExternal(element2);
        }

        @Override
        @NotNull
        public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
            SettingsEditor<? extends RunConfiguration> settingsEditor = this.myConfiguration.getConfigurationEditor();
            if (settingsEditor == null) {
                MyRunProfile.$$$reportNull$$$0(2);
            }
            return settingsEditor;
        }

        @Override
        public ConfigurationPerRunnerSettings createRunnerSettings(ConfigurationInfoProvider provider) {
            return this.myConfiguration.createRunnerSettings(provider);
        }

        @Override
        public SettingsEditor<ConfigurationPerRunnerSettings> getRunnerSettingsEditor(ProgramRunner runner) {
            return this.myConfiguration.getRunnerSettingsEditor(runner);
        }

        @Override
        public RunConfiguration clone() {
            return this.myConfiguration.clone();
        }

        @Override
        public int getUniqueID() {
            return this.myConfiguration.getUniqueID();
        }

        @Override
        public LogFileOptions getOptionsForPredefinedLogFile(PredefinedLogFile predefinedLogFile) {
            return this.myConfiguration.getOptionsForPredefinedLogFile(predefinedLogFile);
        }

        @Override
        @NotNull
        public List<PredefinedLogFile> getPredefinedLogFiles() {
            List<PredefinedLogFile> list2 = this.myConfiguration.getPredefinedLogFiles();
            if (list2 == null) {
                MyRunProfile.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @Override
        @NotNull
        public ArrayList<LogFileOptions> getAllLogFiles() {
            ArrayList<LogFileOptions> arrayList = this.myConfiguration.getAllLogFiles();
            if (arrayList == null) {
                MyRunProfile.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        @Override
        @NotNull
        public List<LogFileOptions> getLogFiles() {
            List<LogFileOptions> list2 = this.myConfiguration.getLogFiles();
            if (list2 == null) {
                MyRunProfile.$$$reportNull$$$0(5);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction$MyRunProfile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction$MyRunProfile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigurationEditor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPredefinedLogFiles";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllLogFiles";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLogFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "readExternal";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "writeExternal";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

