/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.actions;

import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.tree.TreeUtil;

public class TestTreeExpander
implements TreeExpander {
    private TestFrameworkRunningModel myModel;

    public void setModel(TestFrameworkRunningModel model) {
        this.myModel = model;
        Disposer.register(model, new Disposable(){

            @Override
            public void dispose() {
                TestTreeExpander.this.myModel = null;
            }
        });
    }

    @Override
    public void expandAll() {
        TreeUtil.expandAll(this.myModel.getTreeView());
    }

    @Override
    public boolean canExpand() {
        return this.treeHasMoreThanOneLevel();
    }

    @Override
    public void collapseAll() {
        TreeUtil.collapseAll(this.myModel.getTreeView(), 1);
    }

    @Override
    public boolean canCollapse() {
        return this.treeHasMoreThanOneLevel();
    }

    private boolean treeHasMoreThanOneLevel() {
        return this.myModel != null && this.myModel.hasTestSuites();
    }
}

