/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.autotest;

import com.intellij.AppTopics;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.execution.testframework.autotest.AutoTestWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.PsiErrorElementUtil;
import com.intellij.util.SingleAlarm;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DelayedDocumentWatcher
implements AutoTestWatcher {
    private final Project myProject;
    private final int myDelayMillis;
    private final Consumer<? super Integer> myModificationStampConsumer;
    private final Condition<? super VirtualFile> myChangedFileFilter;
    private final MyDocumentAdapter myListener;
    private Disposable myDisposable;
    private SingleAlarm myAlarm;
    private final Set<VirtualFile> myChangedFiles;
    private boolean myDocumentSavingInProgress;
    private MessageBusConnection myConnection;
    private int myModificationStamp;

    public DelayedDocumentWatcher(@NotNull Project project2, int delayMillis, @NotNull Consumer<? super Integer> modificationStampConsumer, @Nullable Condition<? super VirtualFile> changedFileFilter) {
        if (project2 == null) {
            DelayedDocumentWatcher.$$$reportNull$$$0(0);
        }
        if (modificationStampConsumer == null) {
            DelayedDocumentWatcher.$$$reportNull$$$0(1);
        }
        this.myChangedFiles = new THashSet<VirtualFile>();
        this.myDocumentSavingInProgress = false;
        this.myModificationStamp = 0;
        this.myProject = project2;
        this.myDelayMillis = delayMillis;
        this.myModificationStampConsumer = modificationStampConsumer;
        this.myChangedFileFilter = changedFileFilter;
        this.myListener = new MyDocumentAdapter();
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            DelayedDocumentWatcher.$$$reportNull$$$0(2);
        }
        return project2;
    }

    @Override
    public void activate() {
        if (this.myConnection == null) {
            this.myDisposable = Disposer.newDisposable();
            Disposer.register(this.myProject, this.myDisposable);
            EditorFactory.getInstance().getEventMulticaster().addDocumentListener(this.myListener, this.myDisposable);
            this.myConnection = ApplicationManager.getApplication().getMessageBus().connect(this.myProject);
            this.myConnection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, new FileDocumentManagerListener(){

                @Override
                public void beforeAllDocumentsSaving() {
                    DelayedDocumentWatcher.this.myDocumentSavingInProgress = true;
                    ApplicationManager.getApplication().invokeLater(() -> DelayedDocumentWatcher.this.myDocumentSavingInProgress = false, ModalityState.any());
                }
            });
            LookupManager.getInstance(this.myProject).addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("activeLookup".equals(evt.getPropertyName()) && evt.getNewValue() == null && !DelayedDocumentWatcher.this.myChangedFiles.isEmpty()) {
                        DelayedDocumentWatcher.this.myAlarm.cancelAndRequest();
                    }
                }
            }, this.myDisposable);
            this.myAlarm = new SingleAlarm((Runnable)new MyRunnable(), this.myDelayMillis, Alarm.ThreadToUse.SWING_THREAD, this.myDisposable);
        }
    }

    @Override
    public void deactivate() {
        if (this.myDisposable != null) {
            Disposer.dispose(this.myDisposable);
            this.myDisposable = null;
        }
        if (this.myConnection != null) {
            this.myConnection.disconnect();
            this.myConnection = null;
        }
    }

    @Override
    public boolean isUpToDate(int modificationStamp) {
        return this.myModificationStamp == modificationStamp;
    }

    private void asyncCheckErrors(@NotNull Collection<? extends VirtualFile> files2, @NotNull Consumer<? super Boolean> errorsFoundConsumer) {
        if (files2 == null) {
            DelayedDocumentWatcher.$$$reportNull$$$0(3);
        }
        if (errorsFoundConsumer == null) {
            DelayedDocumentWatcher.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            boolean errorsFound = ReadAction.compute(() -> {
                for (VirtualFile file2 : files2) {
                    if (!PsiErrorElementUtil.hasErrors(this.myProject, file2)) continue;
                    return true;
                }
                return false;
            });
            ApplicationManager.getApplication().invokeLater(() -> errorsFoundConsumer.consume(errorsFound), ModalityState.any());
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modificationStampConsumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/autotest/DelayedDocumentWatcher";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorsFoundConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/autotest/DelayedDocumentWatcher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "asyncCheckErrors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyRunnable
    implements Runnable {
        private MyRunnable() {
        }

        @Override
        public void run() {
            int oldModificationStamp = DelayedDocumentWatcher.this.myModificationStamp;
            DelayedDocumentWatcher.this.asyncCheckErrors(DelayedDocumentWatcher.this.myChangedFiles, errorsFound -> {
                if (Disposer.isDisposed(DelayedDocumentWatcher.this.myDisposable)) {
                    return;
                }
                if (DelayedDocumentWatcher.this.myModificationStamp != oldModificationStamp) {
                    return;
                }
                LookupEx activeLookup = LookupManager.getInstance(DelayedDocumentWatcher.this.myProject).getActiveLookup();
                if (activeLookup != null && activeLookup.isCompletion()) {
                    return;
                }
                if (errorsFound.booleanValue()) {
                    return;
                }
                DelayedDocumentWatcher.this.myChangedFiles.clear();
                DelayedDocumentWatcher.this.myModificationStampConsumer.consume(DelayedDocumentWatcher.this.myModificationStamp);
            });
        }
    }

    private class MyDocumentAdapter
    implements DocumentListener {
        private MyDocumentAdapter() {
        }

        @Override
        public void documentChanged(@NotNull DocumentEvent event) {
            if (event == null) {
                MyDocumentAdapter.$$$reportNull$$$0(0);
            }
            if (DelayedDocumentWatcher.this.myDocumentSavingInProgress) {
                return;
            }
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(event.getDocument());
            if (file2 == null) {
                return;
            }
            if (!DelayedDocumentWatcher.this.myChangedFiles.contains(file2)) {
                if (ProjectUtil.isProjectOrWorkspaceFile(file2)) {
                    return;
                }
                if (DelayedDocumentWatcher.this.myChangedFileFilter != null && !DelayedDocumentWatcher.this.myChangedFileFilter.value(file2)) {
                    return;
                }
                DelayedDocumentWatcher.this.myChangedFiles.add(file2);
            }
            DelayedDocumentWatcher.this.myAlarm.cancelAndRequest();
            DelayedDocumentWatcher.this.myModificationStamp++;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/testframework/autotest/DelayedDocumentWatcher$MyDocumentAdapter", "documentChanged"));
        }
    }
}

