/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.export;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.export.ExportTestResultsConfiguration;
import com.intellij.execution.testframework.export.ExportTestResultsDialog;
import com.intellij.execution.testframework.export.TestResultsXmlFormatter;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.PathUtil;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;

public class ExportTestResultsAction
extends DumbAwareAction {
    private static final String ID = "ExportTestResults";
    private static final Logger LOG = Logger.getInstance(ExportTestResultsAction.class.getName());
    private TestFrameworkRunningModel myModel;
    private String myToolWindowId;
    private RunConfiguration myRunConfiguration;

    public static ExportTestResultsAction create(String toolWindowId, RunConfiguration runtimeConfiguration, JComponent component2) {
        ExportTestResultsAction action2 = new ExportTestResultsAction();
        ActionUtil.copyFrom(action2, ID);
        action2.myToolWindowId = toolWindowId;
        action2.myRunConfiguration = runtimeConfiguration;
        action2.registerCustomShortcutSet(action2.getShortcutSet(), component2);
        return action2;
    }

    public void setModel(TestFrameworkRunningModel model) {
        this.myModel = model;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ExportTestResultsAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabled(this.isEnabled(e.getDataContext()));
    }

    private boolean isEnabled(DataContext dataContext) {
        if (this.myModel == null) {
            return false;
        }
        if (CommonDataKeys.PROJECT.getData(dataContext) == null) {
            return false;
        }
        return !this.myModel.getRoot().isInProgress();
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            ExportTestResultsAction.$$$reportNull$$$0(1);
        }
        LOG.assertTrue((project2 = e.getProject()) != null);
        final ExportTestResultsConfiguration config2 = ExportTestResultsConfiguration.getInstance(project2);
        String name = ExecutionBundle.message("export.test.results.filename", PathUtil.suggestFileName(this.myRunConfiguration.getName()));
        String filename = name + "." + config2.getExportFormat().getDefaultExtension();
        boolean showDialog = true;
        while (showDialog) {
            ExportTestResultsDialog d = new ExportTestResultsDialog(project2, config2, filename);
            if (!d.showAndGet()) {
                return;
            }
            filename = d.getFileName();
            showDialog = ExportTestResultsAction.getOutputFile(config2, project2, filename).exists() && Messages.showOkCancelDialog(project2, ExecutionBundle.message("export.test.results.file.exists.message", filename), ExecutionBundle.message("export.test.results.file.exists.title", new Object[0]), "Overwrite", "Cancel", Messages.getQuestionIcon()) != 0;
        }
        final String filename_ = filename;
        ProgressManager.getInstance().run(new Task.Backgroundable(project2, ExecutionBundle.message("export.test.results.task.name", new Object[0]), false, new PerformInBackgroundOption(){

            @Override
            public boolean shouldStartInBackground() {
                return true;
            }
        }){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                String outputText;
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(true);
                final File outputFile = ExportTestResultsAction.getOutputFile(config2, project2, filename_);
                try {
                    outputText = ExportTestResultsAction.this.getOutputText(config2);
                    if (outputText == null) {
                        return;
                    }
                }
                catch (IOException | TransformerException | SAXException ex) {
                    LOG.warn(ex);
                    ExportTestResultsAction.this.showBalloon(project2, MessageType.ERROR, ExecutionBundle.message("export.test.results.failed", ex.getMessage()), null);
                    return;
                }
                catch (RuntimeException ex) {
                    String xml = null;
                    try {
                        ExportTestResultsConfiguration c = new ExportTestResultsConfiguration();
                        c.setExportFormat(ExportTestResultsConfiguration.ExportFormat.Xml);
                        c.setOpenResults(false);
                        xml = ExportTestResultsAction.this.getOutputText(c);
                    }
                    catch (Throwable c) {
                        // empty catch block
                    }
                    if (xml != null) {
                        LOG.error("Failed to export test results", (Throwable)ex, new Attachment("dump.xml", xml));
                    } else {
                        LOG.error("Failed to export test results", ex);
                    }
                    return;
                }
                final Ref result2 = new Ref();
                final Ref error = new Ref();
                ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        result2.set(ApplicationManager.getApplication().runWriteAction(new Computable<VirtualFile>(){

                            @Override
                            public VirtualFile compute() {
                                outputFile.getParentFile().mkdirs();
                                VirtualFile parent = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(outputFile.getParentFile());
                                if (parent == null || !parent.isValid()) {
                                    error.set(ExecutionBundle.message("failed.to.create.output.file", outputFile.getPath()));
                                    return null;
                                }
                                try {
                                    VirtualFile result2 = parent.findChild(outputFile.getName());
                                    if (result2 == null) {
                                        result2 = parent.createChildData(this, outputFile.getName());
                                    }
                                    VfsUtil.saveText(result2, outputText);
                                    return result2;
                                }
                                catch (IOException e) {
                                    LOG.warn(e);
                                    error.set(e.getMessage());
                                    return null;
                                }
                            }
                        }));
                    }
                });
                if (!result2.isNull()) {
                    if (config2.isOpenResults()) {
                        ExportTestResultsAction.openEditorOrBrowser((VirtualFile)result2.get(), project2, config2.getExportFormat() == ExportTestResultsConfiguration.ExportFormat.Xml);
                    } else {
                        HyperlinkListener listener2 = new HyperlinkListener(){

                            @Override
                            public void hyperlinkUpdate(HyperlinkEvent e) {
                                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                                    ExportTestResultsAction.openEditorOrBrowser((VirtualFile)result2.get(), project2, config2.getExportFormat() == ExportTestResultsConfiguration.ExportFormat.Xml);
                                }
                            }
                        };
                        ExportTestResultsAction.this.showBalloon(project2, MessageType.INFO, ExecutionBundle.message("export.test.results.succeeded", outputFile.getName()), listener2);
                    }
                } else {
                    ExportTestResultsAction.this.showBalloon(project2, MessageType.ERROR, ExecutionBundle.message("export.test.results.failed", error.get()), null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/execution/testframework/export/ExportTestResultsAction$2", "run"));
            }
        });
    }

    @NotNull
    private static File getOutputFile(@NotNull ExportTestResultsConfiguration config2, @NotNull Project project2, @NotNull String filename) {
        String outputFolderPath;
        if (config2 == null) {
            ExportTestResultsAction.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            ExportTestResultsAction.$$$reportNull$$$0(3);
        }
        if (filename == null) {
            ExportTestResultsAction.$$$reportNull$$$0(4);
        }
        File outputFolder = !StringUtil.isEmptyOrSpaces(outputFolderPath = config2.getOutputFolder()) ? (FileUtil.isAbsolute(outputFolderPath) ? new File(outputFolderPath) : new File(new File(project2.getBasePath()), config2.getOutputFolder())) : new File(project2.getBasePath());
        return new File(outputFolder, filename);
    }

    private static void openEditorOrBrowser(VirtualFile result2, Project project2, boolean editor) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (editor) {
                FileEditorManager.getInstance(project2).openFile(result2, true);
            } else {
                BrowserUtil.browse(result2);
            }
        });
    }

    @Nullable
    private String getOutputText(ExportTestResultsConfiguration config2) throws IOException, TransformerException, SAXException {
        TransformerHandler handler2;
        ExportTestResultsConfiguration.ExportFormat exportFormat = config2.getExportFormat();
        SAXTransformerFactory transformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        if (exportFormat == ExportTestResultsConfiguration.ExportFormat.Xml) {
            handler2 = transformerFactory.newTransformerHandler();
            handler2.getTransformer().setOutputProperty("indent", "yes");
            handler2.getTransformer().setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        } else {
            StreamSource xslSource;
            if (config2.getExportFormat() == ExportTestResultsConfiguration.ExportFormat.BundledTemplate) {
                URL bundledXsltUrl = this.getClass().getResource("intellij-export.xsl");
                xslSource = new StreamSource(URLUtil.openStream(bundledXsltUrl));
            } else {
                File xslFile = new File(config2.getUserTemplatePath());
                if (!xslFile.isFile()) {
                    this.showBalloon(this.myRunConfiguration.getProject(), MessageType.ERROR, ExecutionBundle.message("export.test.results.custom.template.not.found", xslFile.getPath()), null);
                    return null;
                }
                xslSource = new StreamSource(xslFile);
            }
            handler2 = transformerFactory.newTransformerHandler(xslSource);
            handler2.getTransformer().setParameter("TITLE", ExecutionBundle.message("export.test.results.filename", this.myRunConfiguration.getName(), this.myRunConfiguration.getType().getDisplayName()));
        }
        StringWriter w = new StringWriter();
        handler2.setResult(new StreamResult(w));
        try {
            TestResultsXmlFormatter.execute(this.myModel.getRoot(), this.myRunConfiguration, this.myModel.getProperties(), handler2);
        }
        catch (ProcessCanceledException e) {
            return null;
        }
        return w.toString();
    }

    private void showBalloon(Project project2, MessageType type, String text2, @Nullable HyperlinkListener listener2) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project2.isDisposed()) {
                return;
            }
            if (ToolWindowManager.getInstance(project2).getToolWindow(this.myToolWindowId) != null) {
                ToolWindowManager.getInstance(project2).notifyByBalloon(this.myToolWindowId, type, text2, null, listener2);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/testframework/export/ExportTestResultsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getOutputFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

