/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.export;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.testframework.export.ExportTestResultsConfiguration;
import com.intellij.execution.testframework.export.ExportTestResultsForm;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ExportTestResultsDialog
extends DialogWrapper {
    private final ExportTestResultsForm myForm;
    private final ExportTestResultsConfiguration myConfig;

    public ExportTestResultsDialog(Project project2, ExportTestResultsConfiguration config2, String defaultFileName) {
        super(project2);
        String defaultFolder;
        this.myConfig = config2;
        if (StringUtil.isNotEmpty(config2.getOutputFolder())) {
            defaultFolder = FileUtil.toSystemDependentName(config2.getOutputFolder());
        } else {
            VirtualFile dir = project2.getBaseDir();
            assert (dir != null);
            defaultFolder = FileUtil.toSystemDependentName(dir.getPresentableUrl());
        }
        this.myForm = new ExportTestResultsForm(config2, defaultFileName, defaultFolder);
        this.myForm.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ExportTestResultsDialog.this.revalidate();
            }
        });
        this.setSize(600, 400);
        this.setTitle(ExecutionBundle.message("export.test.results.dialog.title", new Object[0]));
        this.init();
        this.revalidate();
    }

    @Override
    protected void doOKAction() {
        this.myForm.apply(this.myConfig);
        super.doOKAction();
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myForm.getPreferredFocusedComponent();
    }

    private void revalidate() {
        String message = this.myForm.validate();
        this.myForm.showMessage(message);
        this.setOKActionEnabled(message == null);
    }

    @Override
    protected JComponent createCenterPanel() {
        return this.myForm.getContentPane();
    }

    @Override
    protected String getDimensionServiceKey() {
        return "export.test.results";
    }

    @Override
    protected String getHelpId() {
        return "reference.settings.ide.settings.export.test.results";
    }

    public String getFileName() {
        return this.myForm.getFileName();
    }
}

