/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.sm.runner.SMTRunnerTreeStructure;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.ui.AbstractTestTreeBuilderBase;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.util.Alarm;
import javax.swing.JTree;

public class SMTRunnerTreeBuilder
implements Disposable,
AbstractTestTreeBuilderBase<SMTestProxy> {
    private final JTree myTree;
    private final SMTRunnerTreeStructure myTreeStructure;
    private boolean myDisposed;
    private StructureTreeModel myTreeModel;
    private final Alarm mySelectionAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, this);

    public SMTRunnerTreeBuilder(JTree tree, SMTRunnerTreeStructure structure) {
        this.myTree = tree;
        this.myTreeStructure = structure;
    }

    @Override
    public void repaintWithParents(SMTestProxy testProxy) {
        do {
            this.getTreeModel().invalidate(testProxy, false);
        } while ((testProxy = testProxy.getParent()) != null);
    }

    @Override
    public void dispose() {
        this.myDisposed = true;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public void updateTestsSubtree(SMTestProxy parentTestProxy) {
        this.getTreeModel().invalidate(parentTestProxy, true);
    }

    public JTree getTree() {
        return this.myTree;
    }

    public SMTRunnerTreeStructure getTreeStructure() {
        return this.myTreeStructure;
    }

    protected StructureTreeModel getTreeModel() {
        return this.myTreeModel;
    }

    protected boolean isSmartExpand() {
        return false;
    }

    @Override
    public void setTestsComparator(TestFrameworkRunningModel model) {
        this.myTreeModel.setComparator(model.createComparator());
    }

    public void updateFromRoot() {
        this.myTreeModel.invalidate();
    }

    public void setModel(StructureTreeModel asyncTreeModel) {
        this.myTreeModel = asyncTreeModel;
    }

    public void expand(AbstractTestProxy test) {
        this.getTreeModel().expand(test, this.getTree(), path2 -> {});
    }

    public void select(Object proxy, Runnable onDone) {
        if (!(proxy instanceof AbstractTestProxy)) {
            return;
        }
        this.mySelectionAlarm.cancelAllRequests();
        this.mySelectionAlarm.addRequest(() -> this.getTreeModel().select(proxy, this.getTree(), path2 -> {
            if (onDone != null) {
                onDone.run();
            }
        }), 50);
    }

    protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        SMTRunnerTreeStructure treeStructure = this.getTreeStructure();
        Object rootElement = ((AbstractTreeStructure)treeStructure).getRootElement();
        Object nodeElement = nodeDescriptor.getElement();
        if (nodeElement == rootElement) {
            return true;
        }
        return ((SMTestProxy)nodeElement).getParent() == rootElement && ((SMTestProxy)rootElement).getChildren().size() == 1;
    }
}

