/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.states;

import com.intellij.execution.testframework.sm.runner.states.AbstractState;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;

public abstract class SuiteFinishedState
extends AbstractState {
    public static SuiteFinishedState PASSED_SUITE = new SuiteFinishedState(){

        @Override
        public TestStateInfo.Magnitude getMagnitude() {
            return TestStateInfo.Magnitude.PASSED_INDEX;
        }

        public String toString() {
            return "SUITE PASSED";
        }
    };
    public static SuiteFinishedState FAILED_SUITE = new SuiteFinishedState(){

        @Override
        public boolean isDefect() {
            return true;
        }

        @Override
        public TestStateInfo.Magnitude getMagnitude() {
            return TestStateInfo.Magnitude.FAILED_INDEX;
        }

        public String toString() {
            return "FAILED SUITE";
        }
    };
    public static SuiteFinishedState WITH_IGNORED_TESTS_SUITE = new SuiteFinishedState(){

        @Override
        public boolean isDefect() {
            return true;
        }

        @Override
        public TestStateInfo.Magnitude getMagnitude() {
            return TestStateInfo.Magnitude.IGNORED_INDEX;
        }

        public String toString() {
            return "WITH IGNORED TESTS SUITE";
        }
    };
    public static SuiteFinishedState ERROR_SUITE = new SuiteFinishedState(){

        @Override
        public boolean isDefect() {
            return true;
        }

        @Override
        public TestStateInfo.Magnitude getMagnitude() {
            return TestStateInfo.Magnitude.ERROR_INDEX;
        }

        public String toString() {
            return "ERROR SUITE";
        }
    };
    public static SuiteFinishedState EMPTY_SUITE = new EmptySuite();
    public static SuiteFinishedState TESTS_REPORTER_NOT_ATTACHED = new SuiteFinishedState(){

        @Override
        public boolean isDefect() {
            return false;
        }

        @Override
        public TestStateInfo.Magnitude getMagnitude() {
            return TestStateInfo.Magnitude.COMPLETE_INDEX;
        }

        public String toString() {
            return "TESTS REPORTER NOT ATTACHED";
        }
    };

    private SuiteFinishedState() {
    }

    @Override
    public boolean isInProgress() {
        return false;
    }

    @Override
    public boolean isDefect() {
        return false;
    }

    @Override
    public boolean wasLaunched() {
        return true;
    }

    @Override
    public boolean isFinal() {
        return true;
    }

    @Override
    public boolean wasTerminated() {
        return false;
    }

    private static class EmptySuite
    extends SuiteFinishedState {
        private EmptySuite() {
        }

        @Override
        public boolean isDefect() {
            return false;
        }

        @Override
        public TestStateInfo.Magnitude getMagnitude() {
            return TestStateInfo.Magnitude.COMPLETE_INDEX;
        }

        public String toString() {
            return "EMPTY FINISHED SUITE";
        }
    }
}

