/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.states;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.sm.runner.states.TestFailedState;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestComparisionFailedState
extends TestFailedState {
    private final String myErrorMsgPresentation;
    private final String myStacktracePresentation;
    private final DiffHyperlink myHyperlink;
    private boolean myToDeleteExpectedFile;
    private boolean myToDeleteActualFile;

    public TestComparisionFailedState(@Nullable String localizedMessage, @Nullable String stackTrace, @NotNull String actualText, @NotNull String expectedText) {
        if (actualText == null) {
            TestComparisionFailedState.$$$reportNull$$$0(0);
        }
        if (expectedText == null) {
            TestComparisionFailedState.$$$reportNull$$$0(1);
        }
        this(localizedMessage, stackTrace, actualText, expectedText, null);
    }

    public TestComparisionFailedState(@Nullable String localizedMessage, @Nullable String stackTrace, @NotNull String actualText, @NotNull String expectedText, @Nullable String filePath2) {
        if (actualText == null) {
            TestComparisionFailedState.$$$reportNull$$$0(2);
        }
        if (expectedText == null) {
            TestComparisionFailedState.$$$reportNull$$$0(3);
        }
        this(localizedMessage, stackTrace, actualText, expectedText, true, filePath2, null);
    }

    public TestComparisionFailedState(@Nullable String localizedMessage, @Nullable String stackTrace, @NotNull String actualText, @NotNull String expectedText, boolean printExpectedAndActualValues, @Nullable String expectedFilePath, @Nullable String actualFilePath) {
        if (actualText == null) {
            TestComparisionFailedState.$$$reportNull$$$0(4);
        }
        if (expectedText == null) {
            TestComparisionFailedState.$$$reportNull$$$0(5);
        }
        super(localizedMessage, stackTrace);
        this.myHyperlink = new DiffHyperlink(expectedText, actualText, expectedFilePath, actualFilePath, printExpectedAndActualValues);
        this.myErrorMsgPresentation = StringUtil.isEmptyOrSpaces(localizedMessage) ? "" : localizedMessage;
        this.myStacktracePresentation = StringUtil.isEmptyOrSpaces(stackTrace) ? "" : stackTrace;
    }

    @Override
    public void printOn(Printer printer) {
        printer.print("\n", ConsoleViewContentType.ERROR_OUTPUT);
        printer.mark();
        printer.printWithAnsiColoring(this.myErrorMsgPresentation, ProcessOutputTypes.STDERR);
        this.myHyperlink.printOn(printer);
        printer.print("\n", ConsoleViewContentType.ERROR_OUTPUT);
        printer.printWithAnsiColoring(this.myStacktracePresentation, ProcessOutputTypes.STDERR);
        printer.print("\n", ConsoleViewContentType.ERROR_OUTPUT);
    }

    @Nullable
    public DiffHyperlink getHyperlink() {
        return this.myHyperlink;
    }

    public void setToDeleteExpectedFile(boolean expectedTemp) {
        this.myToDeleteExpectedFile = expectedTemp;
    }

    public void setToDeleteActualFile(boolean actualTemp) {
        this.myToDeleteActualFile = actualTemp;
    }

    @Override
    public void dispose() {
        if (this.myToDeleteActualFile) {
            FileUtil.delete(new File(this.myHyperlink.getActualFilePath()));
        }
        if (this.myToDeleteExpectedFile) {
            FileUtil.delete(new File(this.myHyperlink.getFilePath()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "actualText";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "expectedText";
                break;
            }
        }
        objectArray[1] = "com/intellij/execution/testframework/sm/runner/states/TestComparisionFailedState";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

