/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.ui;

import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTRunnerNodeDescriptor;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMRootTestProxyFormatter;
import com.intellij.execution.testframework.sm.runner.ui.TestsPresentationUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Shape;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TestTreeRenderer
extends ColoredTreeCellRenderer {
    @NonNls
    private static final String SPACE_STRING = " ";
    private final TestConsoleProperties myConsoleProperties;
    private SMRootTestProxyFormatter myAdditionalRootFormatter;
    private String myDurationText;
    private Color myDurationColor;
    private int myDurationWidth;
    private int myDurationOffset;

    public TestTreeRenderer(TestConsoleProperties consoleProperties) {
        this.myConsoleProperties = consoleProperties;
    }

    @Override
    public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (tree == null) {
            TestTreeRenderer.$$$reportNull$$$0(0);
        }
        this.myDurationText = null;
        this.myDurationColor = null;
        this.myDurationWidth = 0;
        this.myDurationOffset = 0;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value2;
        Object userObj = node.getUserObject();
        if (userObj instanceof SMTRunnerNodeDescriptor) {
            SMTRunnerNodeDescriptor desc = (SMTRunnerNodeDescriptor)userObj;
            SMTestProxy testProxy = (SMTestProxy)desc.getElement();
            if (testProxy instanceof SMTestProxy.SMRootTestProxy) {
                SMTestProxy.SMRootTestProxy rootTestProxy = (SMTestProxy.SMRootTestProxy)testProxy;
                if (rootTestProxy.isLeaf()) {
                    TestsPresentationUtil.formatRootNodeWithoutChildren(rootTestProxy, this);
                } else {
                    TestsPresentationUtil.formatRootNodeWithChildren(rootTestProxy, this);
                }
                if (this.myAdditionalRootFormatter != null) {
                    this.myAdditionalRootFormatter.format(rootTestProxy, this);
                }
            } else {
                TestsPresentationUtil.formatTestProxy(testProxy, this);
            }
            if (TestConsoleProperties.SHOW_INLINE_STATISTICS.value(this.myConsoleProperties)) {
                this.myDurationText = testProxy.getDurationString(this.myConsoleProperties);
                if (this.myDurationText != null) {
                    FontMetrics metrics = this.getFontMetrics(RelativeFont.SMALL.derive(this.getFont()));
                    this.myDurationWidth = metrics.stringWidth(this.myDurationText);
                    this.myDurationOffset = metrics.getHeight() / 2;
                    this.myDurationColor = selected2 ? UIUtil.getTreeSelectionForeground(hasFocus) : SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor();
                }
            }
            return;
        }
        String text2 = node.toString();
        this.append(text2 != null ? text2 : SPACE_STRING, SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        if (this.myDurationWidth > 0) {
            preferredSize.width += this.myDurationWidth + this.myDurationOffset;
        }
        Dimension dimension = preferredSize;
        if (dimension == null) {
            TestTreeRenderer.$$$reportNull$$$0(1);
        }
        return dimension;
    }

    public TestConsoleProperties getConsoleProperties() {
        return this.myConsoleProperties;
    }

    public void setAdditionalRootFormatter(@NotNull SMRootTestProxyFormatter formatter) {
        if (formatter == null) {
            TestTreeRenderer.$$$reportNull$$$0(2);
        }
        this.myAdditionalRootFormatter = formatter;
    }

    public void removeAdditionalRootFormatter() {
        this.myAdditionalRootFormatter = null;
    }

    @Override
    protected void paintComponent(Graphics g) {
        UISettings.setupAntialiasing(g);
        Shape clip = null;
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, width, height);
        }
        if (this.myDurationWidth > 0 && (width -= this.myDurationWidth + this.myDurationOffset) > 0 && height > 0) {
            g.setColor(this.myDurationColor);
            g.setFont(RelativeFont.SMALL.derive(this.getFont()));
            g.drawString(this.myDurationText, width + this.myDurationOffset / 2, TestTreeRenderer.getTextBaseLine(g.getFontMetrics(), height));
            clip = g.getClip();
            g.clipRect(0, 0, width, height);
        }
        super.paintComponent(g);
        if (clip != null) {
            g.setClip(clip);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/sm/runner/ui/TestTreeRenderer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/sm/runner/ui/TestTreeRenderer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "customizeCellRenderer";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setAdditionalRootFormatter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

