/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.stacktrace;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoBase;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.actions.ViewAssertEqualsDiffAction;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.awt.RelativePoint;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffHyperlink
implements Printable {
    private static final String NEW_LINE = "\n";
    private static final Logger LOG = Logger.getInstance(DiffHyperlink.class);
    protected final String myExpected;
    protected final String myActual;
    protected final String myFilePath;
    protected final String myActualFilePath;
    private final boolean myPrintOneLine;
    private final HyperlinkInfo myDiffHyperlink = new DiffHyperlinkInfo();
    private String myTestProxyName;

    public DiffHyperlink(String expected, String actual, String filePath2) {
        this(expected, actual, filePath2, true);
    }

    public DiffHyperlink(String expected, String actual, String filePath2, boolean printOneLine) {
        this(expected, actual, filePath2, null, printOneLine);
    }

    public DiffHyperlink(String expected, String actual, String expectedFilePath, String actualFilePath, boolean printOneLine) {
        this.myExpected = expected;
        this.myActual = actual;
        this.myFilePath = DiffHyperlink.normalizeSeparators(expectedFilePath);
        this.myActualFilePath = DiffHyperlink.normalizeSeparators(actualFilePath);
        this.myPrintOneLine = printOneLine;
    }

    public void setTestProxyName(String name) {
        this.myTestProxyName = name;
    }

    private static String normalizeSeparators(String filePath2) {
        return filePath2 == null ? null : filePath2.replace(File.separatorChar, '/');
    }

    protected String getTitle() {
        return ExecutionBundle.message("strings.equal.failed.dialog.title", new Object[0]) + (this.myTestProxyName != null ? " (" + this.myTestProxyName + ")" : "");
    }

    public String getDiffTitle() {
        return this.getTitle();
    }

    public String getLeft() {
        return this.myExpected;
    }

    public String getRight() {
        return this.myActual;
    }

    public String getFilePath() {
        return this.myFilePath;
    }

    public String getActualFilePath() {
        return this.myActualFilePath;
    }

    @Override
    public void printOn(Printer printer) {
        if (!DiffHyperlink.hasMoreThanOneLine(this.myActual) && !DiffHyperlink.hasMoreThanOneLine(this.myExpected) && this.myPrintOneLine) {
            printer.printExpectedActualHeader(this.myExpected, this.myActual);
        }
        printer.print(NEW_LINE, ConsoleViewContentType.ERROR_OUTPUT);
        printer.printHyperlink(ExecutionBundle.message("junit.click.to.see.diff.link", new Object[0]), this.myDiffHyperlink);
        printer.print(NEW_LINE, ConsoleViewContentType.ERROR_OUTPUT);
    }

    private static boolean hasMoreThanOneLine(String string) {
        return string.indexOf(10) != -1 || string.indexOf(13) != -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DiffHyperlink)) {
            return false;
        }
        DiffHyperlink hyperlink = (DiffHyperlink)o;
        if (this.myActual != null ? !this.myActual.equals(hyperlink.myActual) : hyperlink.myActual != null) {
            return false;
        }
        if (this.myExpected != null ? !this.myExpected.equals(hyperlink.myExpected) : hyperlink.myExpected != null) {
            return false;
        }
        if (this.myFilePath != null ? !this.myFilePath.equals(hyperlink.myFilePath) : hyperlink.myFilePath != null) {
            return false;
        }
        return !(this.myActualFilePath != null ? !this.myActualFilePath.equals(hyperlink.myActualFilePath) : hyperlink.myActualFilePath != null);
    }

    public int hashCode() {
        int result2 = this.myExpected != null ? this.myExpected.hashCode() : 0;
        result2 = 31 * result2 + (this.myActual != null ? this.myActual.hashCode() : 0);
        result2 = 31 * result2 + (this.myFilePath != null ? this.myFilePath.hashCode() : 0);
        result2 = 31 * result2 + (this.myActualFilePath != null ? this.myActualFilePath.hashCode() : 0);
        return result2;
    }

    public class DiffHyperlinkInfo
    extends HyperlinkInfoBase {
        @Override
        public void navigate(@NotNull Project project2, @Nullable RelativePoint hyperlinkLocationPoint) {
            if (project2 == null) {
                DiffHyperlinkInfo.$$$reportNull$$$0(0);
            }
            DataManager dataManager = DataManager.getInstance();
            DataContext dataContext = hyperlinkLocationPoint != null ? dataManager.getDataContext(hyperlinkLocationPoint.getOriginalComponent()) : dataManager.getDataContext();
            ViewAssertEqualsDiffAction.openDiff(dataContext, DiffHyperlink.this);
        }

        public DiffHyperlink getPrintable() {
            return DiffHyperlink.this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/testframework/stacktrace/DiffHyperlink$DiffHyperlinkInfo", "navigate"));
        }
    }
}

