/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.ui;

import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.ui.AbstractTestTreeBuilder;
import com.intellij.execution.testframework.ui.AbstractTestTreeBuilderBase;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class TestsProgressAnimator
implements Runnable,
Disposable {
    private static final int FRAMES_COUNT = 8;
    private static final int MOVIE_TIME = 800;
    private static final int FRAME_TIME = 100;
    public static final Icon[] FRAMES = new Icon[8];
    private long myLastInvocationTime = -1L;
    private final Alarm myAlarm = new Alarm();
    private volatile AbstractTestProxy myCurrentTestCase;
    private final AbstractTestTreeBuilderBase myTreeBuilder;

    @Deprecated
    public TestsProgressAnimator(AbstractTestTreeBuilder builder2) {
        this((AbstractTestTreeBuilderBase)builder2);
    }

    public TestsProgressAnimator(AbstractTestTreeBuilderBase builder2) {
        Disposer.register(builder2, this);
        this.myTreeBuilder = builder2;
    }

    public static int getCurrentFrameIndex() {
        return (int)(System.currentTimeMillis() % 800L / 100L);
    }

    public static Icon getCurrentFrame() {
        return FRAMES[TestsProgressAnimator.getCurrentFrameIndex()];
    }

    public AbstractTestProxy getCurrentTestCase() {
        return this.myCurrentTestCase;
    }

    @Override
    public void run() {
        long time;
        if (this.myCurrentTestCase != null && (time = System.currentTimeMillis()) - this.myLastInvocationTime >= 100L) {
            this.repaintSubTree();
            this.myLastInvocationTime = time;
        }
        this.scheduleRepaint();
    }

    public void setCurrentTestCase(@Nullable AbstractTestProxy currentTestCase) {
        this.myCurrentTestCase = currentTestCase;
        this.scheduleRepaint();
    }

    public void stopMovie() {
        this.myCurrentTestCase = null;
        this.myAlarm.cancelAllRequests();
    }

    @Override
    public synchronized void dispose() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myCurrentTestCase = null;
        Disposer.dispose(this.myAlarm);
    }

    private void repaintSubTree() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        AbstractTestProxy testProxy = this.myCurrentTestCase;
        if (testProxy != null) {
            this.myTreeBuilder.repaintWithParents(testProxy);
        }
    }

    private synchronized void scheduleRepaint() {
        this.myAlarm.cancelAllRequests();
        if (this.myCurrentTestCase != null && !this.myAlarm.isDisposed()) {
            this.myAlarm.addRequest((Runnable)this, 100);
        }
    }

    static {
        TestsProgressAnimator.FRAMES[0] = AllIcons.Process.Step_1;
        TestsProgressAnimator.FRAMES[1] = AllIcons.Process.Step_2;
        TestsProgressAnimator.FRAMES[2] = AllIcons.Process.Step_3;
        TestsProgressAnimator.FRAMES[3] = AllIcons.Process.Step_4;
        TestsProgressAnimator.FRAMES[4] = AllIcons.Process.Step_5;
        TestsProgressAnimator.FRAMES[5] = AllIcons.Process.Step_6;
        TestsProgressAnimator.FRAMES[6] = AllIcons.Process.Step_7;
        TestsProgressAnimator.FRAMES[7] = AllIcons.Process.Step_8;
    }
}

