/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout;

import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.ui.content.Content;

public abstract class LayoutAttractionPolicy {
    public abstract void attract(Content var1, RunnerLayoutUi var2);

    public abstract void clearAttraction(Content var1, RunnerLayoutUi var2);

    public static class FocusAlways
    extends LayoutAttractionPolicy {
        @Override
        public void attract(Content content2, RunnerLayoutUi ui) {
            ui.selectAndFocus(content2, true, true);
        }

        @Override
        public void clearAttraction(Content content2, RunnerLayoutUi ui) {
        }
    }

    public static class FocusOnce
    extends LayoutAttractionPolicy {
        private boolean myWasAttracted;
        private final boolean myRequestFocus;

        public FocusOnce() {
            this(true);
        }

        public FocusOnce(boolean requestFocus) {
            this.myRequestFocus = requestFocus;
        }

        @Override
        public void attract(Content content2, RunnerLayoutUi ui) {
            if (!this.myWasAttracted) {
                this.myWasAttracted = true;
                ui.selectAndFocus(content2, this.myRequestFocus, true, true);
            } else {
                ui.setBouncing(content2, true);
            }
        }

        @Override
        public void clearAttraction(Content content2, RunnerLayoutUi ui) {
            ui.setBouncing(content2, false);
        }
    }

    public static class Bounce
    extends LayoutAttractionPolicy {
        @Override
        public void attract(Content content2, RunnerLayoutUi ui) {
            ui.setBouncing(content2, true);
        }

        @Override
        public void clearAttraction(Content content2, RunnerLayoutUi ui) {
            ui.setBouncing(content2, false);
        }
    }
}

