/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.update;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.update.RunningApplicationUpdater;
import com.intellij.execution.update.RunningApplicationUpdaterProvider;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateRunningApplicationAction
extends AnAction {
    UpdateRunningApplicationAction() {
        super(ExecutionBundle.messagePointer("action.AnAction.text.update.running.application", new Object[0]), ExecutionBundle.messagePointer("action.AnAction.description.update.running.application", new Object[0]), AllIcons.Javaee.UpdateRunningApplication);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            UpdateRunningApplicationAction.$$$reportNull$$$0(0);
        }
        Project project2 = e.getData(CommonDataKeys.PROJECT);
        RunContentDescriptor contentDescriptor = e.getData(LangDataKeys.RUN_CONTENT_DESCRIPTOR);
        Presentation presentation = e.getPresentation();
        if (contentDescriptor != null && project2 != null) {
            ProcessHandler processHandler2 = contentDescriptor.getProcessHandler();
            RunningApplicationUpdater updater2 = UpdateRunningApplicationAction.findUpdater(project2, processHandler2);
            if (updater2 != null) {
                presentation.setEnabled(processHandler2.isStartNotified() && !processHandler2.isProcessTerminating() && !processHandler2.isProcessTerminated());
                presentation.setText(updater2.getDescription());
            } else {
                presentation.setEnabled(false);
            }
            presentation.setVisible(true);
            return;
        }
        List<RunningApplicationUpdater> updaters = UpdateRunningApplicationAction.getAvailableUpdaters(project2);
        boolean enable = !updaters.isEmpty();
        presentation.setEnabledAndVisible(enable);
        if (updaters.size() == 1) {
            presentation.setText(updaters.get(0).getDescription());
        } else {
            presentation.setText(ExecutionBundle.messagePointer("action.presentation.UpdateRunningApplicationAction.text", new Object[0]));
        }
    }

    @Nullable
    private static RunningApplicationUpdater findUpdater(@NotNull Project project2, @Nullable ProcessHandler processHandler2) {
        if (project2 == null) {
            UpdateRunningApplicationAction.$$$reportNull$$$0(1);
        }
        if (processHandler2 == null) {
            return null;
        }
        for (RunningApplicationUpdaterProvider provider : RunningApplicationUpdaterProvider.EP_NAME.getExtensions()) {
            RunningApplicationUpdater updater2 = provider.createUpdater(project2, processHandler2);
            if (updater2 == null) continue;
            return updater2;
        }
        return null;
    }

    private static List<RunningApplicationUpdater> getAvailableUpdaters(@Nullable Project project2) {
        ProcessHandler[] processes;
        if (project2 == null) {
            return Collections.emptyList();
        }
        ArrayList<RunningApplicationUpdater> result2 = new ArrayList<RunningApplicationUpdater>();
        for (ProcessHandler process2 : processes = ExecutionManager.getInstance(project2).getRunningProcesses()) {
            if (process2.isProcessTerminated() || process2.isProcessTerminating() || !process2.isStartNotified()) continue;
            ContainerUtil.addIfNotNull(result2, UpdateRunningApplicationAction.findUpdater(project2, process2));
        }
        return result2;
    }

    @Override
    public void actionPerformed(final @NotNull AnActionEvent e) {
        RunningApplicationUpdater updater2;
        Project project2;
        if (e == null) {
            UpdateRunningApplicationAction.$$$reportNull$$$0(2);
        }
        if ((project2 = e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        RunContentDescriptor contentDescriptor = e.getData(LangDataKeys.RUN_CONTENT_DESCRIPTOR);
        if (contentDescriptor != null && (updater2 = UpdateRunningApplicationAction.findUpdater(project2, contentDescriptor.getProcessHandler())) != null) {
            updater2.performUpdate(e);
            return;
        }
        List<RunningApplicationUpdater> updaters = UpdateRunningApplicationAction.getAvailableUpdaters(project2);
        if (updaters.isEmpty()) {
            return;
        }
        if (updaters.size() > 1) {
            ListPopup popup2 = JBPopupFactory.getInstance().createListPopup(new BaseListPopupStep<RunningApplicationUpdater>("Select Process to Update", updaters){

                @Override
                @NotNull
                public String getTextFor(RunningApplicationUpdater value2) {
                    String string = value2.getShortName();
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                @Override
                public Icon getIconFor(RunningApplicationUpdater value2) {
                    return value2.getIcon();
                }

                @Override
                public PopupStep onChosen(RunningApplicationUpdater selectedValue, boolean finalChoice) {
                    return this.doFinalStep(() -> selectedValue.performUpdate(e));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/update/UpdateRunningApplicationAction$1", "getTextFor"));
                }
            });
            popup2.showCenteredInCurrentWindow(project2);
        } else {
            updaters.get(0).performUpdate(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/update/UpdateRunningApplicationAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findUpdater";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

