/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public final class ExecutionErrorDialog {
    private ExecutionErrorDialog() {
    }

    public static void show(ExecutionException e, String title, Project project2) {
        if (e instanceof RunCanceledByUserException) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        String message = e.getMessage();
        if (message == null || message.length() < 100) {
            Messages.showErrorDialog(project2, message == null ? IdeBundle.message("error.message.exception.was.thrown", new Object[0]) : message, title);
            return;
        }
        DialogBuilder builder2 = new DialogBuilder(project2);
        builder2.setTitle(title);
        JTextArea textArea = new JTextArea();
        textArea.setEditable(false);
        textArea.setForeground(UIUtil.getLabelForeground());
        textArea.setBackground(UIUtil.getLabelBackground());
        textArea.setFont(UIUtil.getLabelFont());
        textArea.setText(message);
        textArea.setWrapStyleWord(false);
        textArea.setLineWrap(true);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(textArea);
        scrollPane.setHorizontalScrollBarPolicy(31);
        JPanel panel2 = new JPanel(new BorderLayout(10, 0));
        panel2.setPreferredSize(JBUI.size(500, 200));
        panel2.add((Component)scrollPane, "Center");
        panel2.add((Component)new JLabel(Messages.getErrorIcon()), "West");
        builder2.setCenterPanel(panel2);
        builder2.setButtonsAlignment(0);
        builder2.addOkAction();
        builder2.show();
    }
}

