/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.configurations.SimpleProgramParameters;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroManager;
import com.intellij.ide.macro.PromptingMacro;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.WorkingDirectoryProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.PathUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public class ProgramParametersConfigurator {
    private static final ExtensionPointName<WorkingDirectoryProvider> WORKING_DIRECTORY_PROVIDER_EP_NAME = ExtensionPointName.create("com.intellij.module.workingDirectoryProvider");
    @Deprecated
    public static final String MODULE_WORKING_DIR = "%MODULE_WORKING_DIR%";

    public void configureConfiguration(SimpleProgramParameters parameters, CommonProgramRunConfigurationParameters configuration) {
        Project project2 = configuration.getProject();
        Module module2 = this.getModule(configuration);
        String parametersString = this.expandPathAndMacros(configuration.getProgramParameters(), module2, project2);
        parameters.getProgramParametersList().addParametersString(parametersString);
        parameters.setWorkingDirectory(this.getWorkingDir(configuration, project2, module2));
        HashMap<String, String> envs = new HashMap<String, String>(configuration.getEnvs());
        EnvironmentUtil.inlineParentOccurrences(envs);
        for (Map.Entry entry : envs.entrySet()) {
            entry.setValue(this.expandPath((String)entry.getValue(), module2, project2));
        }
        parameters.setEnv(envs);
        parameters.setPassParentEnvs(configuration.isPassParentEnvs());
    }

    @Contract(value="!null, _, _ -> !null")
    @Nullable
    public String expandPathAndMacros(String s, Module module2, Project project2) {
        String path2 = this.expandPath(s, module2, project2);
        if (path2 == null) {
            return null;
        }
        return ProgramParametersConfigurator.expandMacros(path2, ProgramParametersConfigurator.projectContext(project2, module2), false);
    }

    @NotNull
    private static DataContext projectContext(Project project2, Module module2) {
        DataContext dataContext = dataId -> {
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return project2;
            }
            if (LangDataKeys.MODULE.is(dataId) || LangDataKeys.MODULE_CONTEXT.is(dataId)) {
                return module2;
            }
            return null;
        };
        if (dataContext == null) {
            ProgramParametersConfigurator.$$$reportNull$$$0(0);
        }
        return dataContext;
    }

    public static String expandMacros(@Nullable String path2) {
        if (StringUtil.isEmpty(path2)) {
            return path2;
        }
        return ProgramParametersConfigurator.expandMacros(path2, DataContext.EMPTY_CONTEXT, false);
    }

    @NotNull
    public static List<String> expandMacrosAndParseParameters(@Nullable String parametersStringWithMacros) {
        if (StringUtil.isEmpty(parametersStringWithMacros)) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                ProgramParametersConfigurator.$$$reportNull$$$0(1);
            }
            return list2;
        }
        String expandedParametersString = ProgramParametersConfigurator.expandMacros(parametersStringWithMacros, DataContext.EMPTY_CONTEXT, true);
        List<String> list3 = ParametersListUtil.parse(expandedParametersString);
        if (list3 == null) {
            ProgramParametersConfigurator.$$$reportNull$$$0(2);
        }
        return list3;
    }

    @NotNull
    private static String expandMacros(@NotNull String path2, @NotNull DataContext dataContext, boolean applyParameterEscaping) {
        if (path2 == null) {
            ProgramParametersConfigurator.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            ProgramParametersConfigurator.$$$reportNull$$$0(4);
        }
        if (!Registry.is("allow.macros.for.run.configurations")) {
            String string = path2;
            if (string == null) {
                ProgramParametersConfigurator.$$$reportNull$$$0(5);
            }
            return string;
        }
        for (Macro macro : MacroManager.getInstance().getMacros()) {
            String template = "$" + macro.getName() + "$";
            int index = path2.indexOf(template);
            while (index != -1 && index < path2.length() + template.length()) {
                String value2 = StringUtil.notNullize(ProgramParametersConfigurator.previewOrExpandMacro(macro, dataContext));
                if (applyParameterEscaping) {
                    value2 = ParametersListUtil.escape(value2);
                }
                path2 = path2.substring(0, index) + value2 + path2.substring(index + template.length());
                index += value2.length();
                index = path2.indexOf(template, index);
            }
        }
        String string = path2;
        if (string == null) {
            ProgramParametersConfigurator.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    private static String previewOrExpandMacro(@NotNull Macro macro, @NotNull DataContext dataContext) {
        if (macro == null) {
            ProgramParametersConfigurator.$$$reportNull$$$0(7);
        }
        if (dataContext == null) {
            ProgramParametersConfigurator.$$$reportNull$$$0(8);
        }
        try {
            return macro instanceof PromptingMacro ? ((PromptingMacro)macro).expand(dataContext) : macro.preview();
        }
        catch (Macro.ExecutionCancelledException e) {
            return null;
        }
    }

    @Nullable
    public String getWorkingDir(CommonProgramRunConfigurationParameters configuration, Project project2, Module module2) {
        String workingDirectory = configuration.getWorkingDirectory();
        String defaultWorkingDir = this.getDefaultWorkingDir(project2);
        if (StringUtil.isEmptyOrSpaces(workingDirectory) && (workingDirectory = defaultWorkingDir) == null) {
            return null;
        }
        if (!PathUtil.isAbsolute(workingDirectory = this.expandPathAndMacros(workingDirectory, module2, project2)) && defaultWorkingDir != null) {
            if ("$MODULE_DIR$".equals(workingDirectory)) {
                return defaultWorkingDir;
            }
            if (MODULE_WORKING_DIR.equals(workingDirectory)) {
                workingDirectory = "$MODULE_WORKING_DIR$";
            }
            if ("$MODULE_WORKING_DIR$".equals(workingDirectory)) {
                if (module2 == null) {
                    return defaultWorkingDir;
                }
                String workingDir = this.getDefaultWorkingDir(module2);
                if (workingDir != null) {
                    return workingDir;
                }
            }
            workingDirectory = defaultWorkingDir + "/" + workingDirectory;
        }
        return workingDirectory;
    }

    @Nullable
    protected String getDefaultWorkingDir(@NotNull Project project2) {
        if (project2 == null) {
            ProgramParametersConfigurator.$$$reportNull$$$0(9);
        }
        return com.intellij.util.PathUtil.getLocalPath(project2.getBaseDir());
    }

    @Nullable
    protected String getDefaultWorkingDir(@NotNull Module module2) {
        if (module2 == null) {
            ProgramParametersConfigurator.$$$reportNull$$$0(10);
        }
        for (WorkingDirectoryProvider provider : WORKING_DIRECTORY_PROVIDER_EP_NAME.getExtensions()) {
            @SystemIndependent String path2 = provider.getWorkingDirectoryPath(module2);
            if (path2 == null) continue;
            return path2;
        }
        VirtualFile[] roots = ModuleRootManager.getInstance(module2).getContentRoots();
        if (roots.length > 0) {
            return com.intellij.util.PathUtil.getLocalPath(roots[0]);
        }
        return null;
    }

    public void checkWorkingDirectoryExist(CommonProgramRunConfigurationParameters configuration, Project project2, Module module2) throws RuntimeConfigurationWarning {
        String workingDir = this.getWorkingDir(configuration, project2, module2);
        if (workingDir == null) {
            throw new RuntimeConfigurationWarning("Working directory is null for project '" + project2.getName() + "' (" + project2.getBasePath() + "), module " + (module2 == null ? "null" : "'" + module2.getName() + "' (" + module2.getModuleFilePath() + ")"));
        }
        if (!new File(workingDir).exists()) {
            throw new RuntimeConfigurationWarning("Working directory '" + workingDir + "' doesn't exist");
        }
    }

    protected String expandPath(@Nullable String path2, Module module2, Project project2) {
        if (module2 != null && "$MODULE_DIR$".equals(path2) && module2.getModuleFilePath().contains("/.idea/") && ExternalProjectSystemRegistry.getInstance().getExternalSource(module2) != null) {
            return this.getDefaultWorkingDir(module2);
        }
        path2 = PathMacroManager.getInstance(project2).expandPath(path2);
        if (module2 != null) {
            path2 = PathMacroManager.getInstance(module2).expandPath(path2);
        }
        return path2;
    }

    @Nullable
    protected Module getModule(CommonProgramRunConfigurationParameters configuration) {
        if (configuration instanceof ModuleBasedConfiguration) {
            return ((RunConfigurationModule)((ModuleBasedConfiguration)((Object)configuration)).getConfigurationModule()).getModule();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/util/ProgramParametersConfigurator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macro";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "projectContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "expandMacrosAndParseParameters";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/util/ProgramParametersConfigurator";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "expandMacros";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "expandMacros";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "previewOrExpandMacro";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultWorkingDir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

