/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslDistributionDescriptor;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WSLDistributionLegacy
extends WSLDistribution {
    private static final WslDistributionDescriptor LEGACY_WSL = new WslDistributionDescriptor("UBUNTU_LEGACY", "ubuntu_bash", "bash.exe", "Ubuntu (Legacy)");
    private static final String WSL_ROOT_CHUNK = "\\lxss\\rootfs";
    private static final AtomicNullableLazyValue<String> WSL_ROOT_IN_WINDOWS_PROVIDER = AtomicNullableLazyValue.createValue(() -> {
        String localAppDataPath = System.getenv().get("LOCALAPPDATA");
        return StringUtil.isEmpty(localAppDataPath) ? null : localAppDataPath + WSL_ROOT_CHUNK;
    });

    @Nullable
    private static Path getExecutableRootPath() {
        String windir = System.getenv().get("windir");
        return StringUtil.isEmpty(windir) ? null : Paths.get(windir, "System32");
    }

    @Nullable
    public static WSLDistributionLegacy getInstance() {
        Path executableRoot = WSLDistributionLegacy.getExecutableRootPath();
        if (executableRoot == null) {
            return null;
        }
        Path executablePath = executableRoot.resolve(LEGACY_WSL.getExecutablePath());
        if (Files.exists(executablePath, LinkOption.NOFOLLOW_LINKS)) {
            return new WSLDistributionLegacy(executablePath);
        }
        return null;
    }

    private WSLDistributionLegacy(@NotNull Path executablePath) {
        if (executablePath == null) {
            WSLDistributionLegacy.$$$reportNull$$$0(0);
        }
        super(LEGACY_WSL, executablePath);
    }

    @Override
    @NotNull
    protected String getRunCommandLineParameter() {
        return "-c";
    }

    @Override
    @Nullable
    public String getWslPath(@NotNull String windowsPath) {
        String wslRootInHost;
        if (windowsPath == null) {
            WSLDistributionLegacy.$$$reportNull$$$0(1);
        }
        if ((wslRootInHost = WSL_ROOT_IN_WINDOWS_PROVIDER.getValue()) == null) {
            return null;
        }
        if (FileUtil.isAncestor(wslRootInHost, windowsPath, true)) {
            return FileUtil.toSystemIndependentName(windowsPath.substring(wslRootInHost.length()));
        }
        return super.getWslPath(windowsPath);
    }

    @Override
    @Nullable
    public String getWindowsPath(@NotNull String wslPath) {
        String windowsPath;
        if (wslPath == null) {
            WSLDistributionLegacy.$$$reportNull$$$0(2);
        }
        if ((windowsPath = super.getWindowsPath(wslPath)) != null) {
            return windowsPath;
        }
        String wslRootInHost = WSL_ROOT_IN_WINDOWS_PROVIDER.getValue();
        if (wslRootInHost == null) {
            return null;
        }
        return FileUtil.toSystemDependentName(wslRootInHost + wslPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executablePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "windowsPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wslPath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/wsl/WSLDistributionLegacy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getWslPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getWindowsPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

