/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.WindowsRegistryUtil;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WSLDistributionWithRoot
extends WSLDistribution {
    private static final AtomicNotNullLazyValue<Map<String, String>> DISTRIBUTION_TO_ROOTFS = AtomicNotNullLazyValue.createValue(() -> {
        HashMap<String, String> result2 = new HashMap<String, String>();
        String lxss = "HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Lxss";
        List<String> distributions = WindowsRegistryUtil.readRegistryBranch("HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Lxss");
        WSLUtil.LOG.debug("Processing Lxss registry: " + distributions.size());
        for (String distribution : distributions) {
            String name = WindowsRegistryUtil.readRegistryValue("HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Lxss\\" + distribution, "DistributionName");
            String path2 = WindowsRegistryUtil.readRegistryValue("HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Lxss\\" + distribution, "BasePath");
            WSLUtil.LOG.debug(name + ": " + path2);
            if (path2 == null) continue;
            result2.put(name, path2 + "\\rootfs");
        }
        return Collections.unmodifiableMap(result2);
    });
    @Nullable
    protected final String myWslRootInHost;

    public WSLDistributionWithRoot(@NotNull WSLDistribution wslDistribution) {
        String p9root;
        boolean checkP9root;
        if (wslDistribution == null) {
            WSLDistributionWithRoot.$$$reportNull$$$0(0);
        }
        super(wslDistribution);
        File uncRoot = this.getUNCRoot();
        String wslRootInHost = DISTRIBUTION_TO_ROOTFS.getValue().get(wslDistribution.getMsId());
        boolean isDirectory = wslRootInHost != null && new File(wslRootInHost).isDirectory();
        boolean bl = checkP9root = Experiments.getInstance().isFeatureEnabled("wsl.prefer.p9.support") || !isDirectory;
        if (Experiments.getInstance().isFeatureEnabled("wsl.p9.support") && checkP9root && FileUtil.exists(p9root = FileUtil.toSystemDependentName(uncRoot.getPath()))) {
            wslRootInHost = p9root;
        }
        if (!FileUtil.exists(wslRootInHost)) {
            WSLUtil.LOG.warn("WSL rootfs doesn't exist: " + wslRootInHost);
            wslRootInHost = null;
        }
        this.myWslRootInHost = wslRootInHost;
    }

    @Override
    @Nullable
    public String getWslPath(@NotNull String windowsPath) {
        if (windowsPath == null) {
            WSLDistributionWithRoot.$$$reportNull$$$0(1);
        }
        String canonicalPath = FileUtil.toCanonicalPath(windowsPath);
        if (this.myWslRootInHost != null && FileUtil.isAncestor(this.myWslRootInHost, canonicalPath, true)) {
            return FileUtil.toSystemIndependentName(canonicalPath.substring(this.myWslRootInHost.length()));
        }
        return super.getWslPath(canonicalPath);
    }

    @Override
    @Nullable
    public String getWindowsPath(@NotNull String wslPath) {
        String windowsPath;
        if (wslPath == null) {
            WSLDistributionWithRoot.$$$reportNull$$$0(2);
        }
        if ((windowsPath = super.getWindowsPath(wslPath)) != null) {
            return windowsPath;
        }
        if (this.myWslRootInHost == null) {
            return null;
        }
        return FileUtil.toSystemDependentName(this.myWslRootInHost + FileUtil.toCanonicalPath(wslPath));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wslDistribution";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "windowsPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wslPath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/wsl/WSLDistributionWithRoot";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getWslPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getWindowsPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

