/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.externalDependencies.impl;

import com.intellij.externalDependencies.DependencyOnPlugin;
import com.intellij.externalDependencies.ExternalDependenciesManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

final class CheckRequiredPluginsActivity
implements StartupActivity.DumbAware {
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Required Plugins", NotificationDisplayType.BALLOON, true);

    CheckRequiredPluginsActivity() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw ExtensionNotApplicableException.INSTANCE;
        }
    }

    @Override
    public void runActivity(@NotNull Project project2) {
        if (project2 == null) {
            CheckRequiredPluginsActivity.$$$reportNull$$$0(0);
        }
        ExternalDependenciesManager.getInstance(project2);
    }

    public static void runCheck(final @NotNull Project project2, @NotNull ExternalDependenciesManager dependencyManager) {
        List<DependencyOnPlugin> dependencies;
        if (project2 == null) {
            CheckRequiredPluginsActivity.$$$reportNull$$$0(1);
        }
        if (dependencyManager == null) {
            CheckRequiredPluginsActivity.$$$reportNull$$$0(2);
        }
        if ((dependencies = dependencyManager.getDependencies(DependencyOnPlugin.class)).isEmpty()) {
            return;
        }
        ArrayList<String> errorMessages = new ArrayList<String>();
        final ArrayList<IdeaPluginDescriptor> disabled = new ArrayList<IdeaPluginDescriptor>();
        final ArrayList<PluginId> notInstalled = new ArrayList<PluginId>();
        for (DependencyOnPlugin dependency : dependencies) {
            PluginId pluginId = PluginId.getId(dependency.getPluginId());
            IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin(pluginId);
            if (plugin == null) {
                errorMessages.add("Plugin '" + dependency.getPluginId() + "' required for '" + project2.getName() + "' project isn't installed.");
                notInstalled.add(pluginId);
                continue;
            }
            if (!plugin.isEnabled()) {
                errorMessages.add("Plugin '" + plugin.getName() + "' required for '" + project2.getName() + "' project is disabled.");
                disabled.add(plugin);
                continue;
            }
            String minVersion = dependency.getMinVersion();
            String maxVersion = dependency.getMaxVersion();
            String pluginVersion = plugin.getVersion();
            BuildNumber currentIdeVersion = ApplicationInfo.getInstance().getBuild();
            if (plugin.isBundled() && !plugin.allowBundledUpdate() && currentIdeVersion.asStringWithoutProductCode().equals(pluginVersion)) {
                String pluginFromString;
                String string = pluginFromString = PluginManagerCore.CORE_ID == plugin.getPluginId() ? "" : "plugin '" + plugin.getName() + "' from ";
                if (minVersion != null && currentIdeVersion.compareTo(BuildNumber.fromString(minVersion)) < 0) {
                    errorMessages.add("Project '" + project2.getName() + "' requires " + pluginFromString + "'" + minVersion + "' or newer build of the IDE, but the current build is '" + pluginVersion + "'.");
                }
                if (maxVersion == null || currentIdeVersion.compareTo(BuildNumber.fromString(maxVersion)) <= 0) continue;
                errorMessages.add("Project '" + project2.getName() + "' requires " + pluginFromString + "'" + maxVersion + "' or older build of the IDE, but the current build is '" + pluginVersion + "'.");
                continue;
            }
            if (minVersion != null && VersionComparatorUtil.compare(pluginVersion, minVersion) < 0) {
                errorMessages.add("Project '" + project2.getName() + "' requires plugin  '" + plugin.getName() + "' version '" + minVersion + "' or higher, but '" + pluginVersion + "' is installed.");
            }
            if (maxVersion == null || VersionComparatorUtil.compare(pluginVersion, maxVersion) <= 0) continue;
            errorMessages.add("Project '" + project2.getName() + "' requires plugin  '" + plugin.getName() + "' version '" + maxVersion + "' or lower, but '" + pluginVersion + "' is installed.");
        }
        if (!errorMessages.isEmpty()) {
            if (!disabled.isEmpty() && notInstalled.isEmpty()) {
                String plugins2 = disabled.size() == 1 ? ((IdeaPluginDescriptor)disabled.get(0)).getName() : "required plugins";
                errorMessages.add("<a href=\"enable\">Enable " + plugins2 + "</a>");
            } else if (!disabled.isEmpty() || !notInstalled.isEmpty()) {
                errorMessages.add("<a href=\"install\">Install required plugins</a>");
            }
            NOTIFICATION_GROUP.createNotification(IdeBundle.message("notification.title.required.plugins.weren.t.loaded", new Object[0]), StringUtil.join(errorMessages, "<br>"), NotificationType.ERROR, new NotificationListener(){

                @Override
                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (event == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        if ("enable".equals(event.getDescription())) {
                            notification.expire();
                            PluginManager.getInstance().enablePlugins(disabled, true);
                            PluginManagerMain.notifyPluginsUpdated(project2);
                        } else {
                            HashSet<PluginId> pluginIds = new HashSet<PluginId>();
                            for (IdeaPluginDescriptor descriptor2 : disabled) {
                                pluginIds.add(descriptor2.getPluginId());
                            }
                            pluginIds.addAll(notInstalled);
                            PluginsAdvertiser.installAndEnable(pluginIds, () -> notification.expire());
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/externalDependencies/impl/CheckRequiredPluginsActivity$1";
                    objectArray[2] = "hyperlinkUpdate";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }).notify(project2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyManager";
                break;
            }
        }
        objectArray2[1] = "com/intellij/externalDependencies/impl/CheckRequiredPluginsActivity";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "runCheck";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

