/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetFromExternalSourcesStorage;
import com.intellij.facet.FacetManagerBase;
import com.intellij.facet.FacetManagerListener;
import com.intellij.facet.FacetModel;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.impl.FacetModelBase;
import com.intellij.facet.impl.FacetModelImpl;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.facet.impl.invalid.InvalidFacet;
import com.intellij.facet.impl.invalid.InvalidFacetConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleComponent;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.facet.FacetManagerState;
import org.jetbrains.jps.model.serialization.facet.FacetState;

@State(name="FacetManager", useLoadedStateAsExisting=false)
@ApiStatus.Internal
public final class FacetManagerImpl
extends FacetManagerBase
implements ModuleComponent,
PersistentStateComponent<FacetManagerState> {
    private static final Logger LOG = Logger.getInstance(FacetManagerImpl.class);
    private final Module myModule;
    private final FacetManagerModel myModel;
    private boolean myInsideCommit;
    private boolean myModuleAdded;
    private final FacetFromExternalSourcesStorage myExternalSourcesStorage;

    public FacetManagerImpl(@NotNull Module module2) {
        if (module2 == null) {
            FacetManagerImpl.$$$reportNull$$$0(0);
        }
        this.myModel = new FacetManagerModel();
        this.myModule = module2;
        this.myExternalSourcesStorage = FacetFromExternalSourcesStorage.getInstance(module2);
    }

    @Override
    @NotNull
    public ModifiableFacetModel createModifiableModel() {
        FacetModelImpl model = new FacetModelImpl(this);
        model.addFacetsFromManager();
        FacetModelImpl facetModelImpl = model;
        if (facetModelImpl == null) {
            FacetManagerImpl.$$$reportNull$$$0(1);
        }
        return facetModelImpl;
    }

    @Override
    protected FacetModel getModel() {
        return this.myModel;
    }

    @Override
    protected Module getModule() {
        return this.myModule;
    }

    private void addFacets(List<? extends FacetState> facetStates, Facet<?> underlyingFacet, ModifiableFacetModel model) {
        FacetTypeRegistry registry = FacetTypeRegistry.getInstance();
        for (FacetState facetState : facetStates) {
            FacetType actualUnderlyingType;
            String typeId = facetState.getFacetType();
            if (typeId == null) {
                this.addInvalidFacet(facetState, model, underlyingFacet, ProjectBundle.message("error.message.facet.type.isn.t.specified", new Object[0]));
                continue;
            }
            FacetType type = registry.findFacetType(typeId);
            if (type == null) {
                this.addInvalidFacet(facetState, model, underlyingFacet, ProjectBundle.message("error.message.unknown.facet.type.0", typeId), true);
                continue;
            }
            ModuleType moduleType = ModuleType.get(this.myModule);
            if (!type.isSuitableModuleType(moduleType)) {
                this.addInvalidFacet(facetState, model, underlyingFacet, ProjectBundle.message("error.message.0.facets.are.not.allowed.in.1", type.getPresentableName(), moduleType.getName()));
                continue;
            }
            FacetType expectedUnderlyingType = null;
            FacetTypeId<?> underlyingTypeId = type.getUnderlyingFacetType();
            if (underlyingTypeId != null) {
                expectedUnderlyingType = registry.findFacetType(underlyingTypeId);
            }
            FacetType facetType = actualUnderlyingType = underlyingFacet != null ? underlyingFacet.getType() : null;
            if (expectedUnderlyingType != null) {
                if (!expectedUnderlyingType.equals(actualUnderlyingType)) {
                    this.addInvalidFacet(facetState, model, underlyingFacet, ProjectBundle.message("error.message.0.facet.must.be.placed.under.1.facet", type.getPresentableName(), expectedUnderlyingType.getPresentableName()));
                    continue;
                }
            } else if (actualUnderlyingType != null) {
                this.addInvalidFacet(facetState, model, underlyingFacet, ProjectBundle.message("error.message.0.cannot.be.placed.under.1", type.getPresentableName(), actualUnderlyingType.getPresentableName()));
                continue;
            }
            try {
                this.addFacet(type, facetState, underlyingFacet, model);
            }
            catch (InvalidDataException e) {
                LOG.info(e);
                this.addInvalidFacet(facetState, model, underlyingFacet, ProjectBundle.message("error.message.cannot.load.facet.configuration.0", e.getMessage()));
            }
        }
    }

    private void addInvalidFacet(FacetState state, ModifiableFacetModel model, Facet<?> underlyingFacet, String errorMessage) {
        this.addInvalidFacet(state, model, underlyingFacet, errorMessage, false);
    }

    private void addInvalidFacet(FacetState state, ModifiableFacetModel model, Facet<?> underlyingFacet, String errorMessage, boolean unknownType) {
        model.addFacet(FacetManagerImpl.createInvalidFacet(this.getModule(), state, underlyingFacet, errorMessage, unknownType, true));
    }

    private <F extends Facet<C>, C extends FacetConfiguration> void addFacet(FacetType<F, C> type, FacetState state, Facet<?> underlyingFacet, ModifiableFacetModel model) throws InvalidDataException {
        Element newConfiguration;
        Collection<F> facetsOfThisType;
        Collection<F> collection = facetsOfThisType = underlyingFacet == null ? model.getFacetsByType(type.getId()) : model.getFacetsByType(underlyingFacet, type.getId());
        if (type.isOnlyOneFacetAllowed() && !facetsOfThisType.isEmpty() && facetsOfThisType.stream().anyMatch(f -> !f.getName().equals(state.getName()))) {
            LOG.info("'" + state.getName() + "' facet removed from module " + this.myModule.getName() + ", because only one " + type.getPresentableName() + " facet allowed");
            return;
        }
        Facet facet = null;
        if (!facetsOfThisType.isEmpty() && ProjectUtilCore.isExternalStorageEnabled(this.myModule.getProject()) && (facet = (Facet)facetsOfThisType.stream().filter(f -> f.getName().equals(state.getName())).findFirst().orElse(null)) != null && (newConfiguration = state.getConfiguration()) != null) {
            FacetUtil.loadFacetConfiguration(facet.getConfiguration(), newConfiguration);
        }
        if (facet == null) {
            facet = (Facet)FacetManagerImpl.createFacetFromState(this.getModule(), type, state, underlyingFacet);
            model.addFacet(facet);
        }
        this.addFacets(state.getSubFacets(), facet, model);
    }

    @ApiStatus.Internal
    @NotNull
    public static Facet<?> createFacetFromStateRaw(@NotNull Module module2, @NotNull FacetType<?, ?> type, @NotNull FacetState state, @Nullable Facet<?> underlyingFacet) {
        if (module2 == null) {
            FacetManagerImpl.$$$reportNull$$$0(2);
        }
        if (type == null) {
            FacetManagerImpl.$$$reportNull$$$0(3);
        }
        if (state == null) {
            FacetManagerImpl.$$$reportNull$$$0(4);
        }
        return FacetManagerImpl.createFacetFromState(module2, type, state, underlyingFacet);
    }

    @NotNull
    private static <F extends Facet<C>, C extends FacetConfiguration> F createFacetFromState(Module module2, FacetType<F, C> type, FacetState state, Facet<?> underlyingFacet) {
        String externalSystemId;
        C configuration = type.createDefaultConfiguration();
        Element config2 = state.getConfiguration();
        FacetUtil.loadFacetConfiguration(configuration, config2);
        String name = state.getName();
        F facet = FacetManagerImpl.createFacet(module2, type, name, configuration, underlyingFacet);
        if (facet instanceof JDOMExternalizable) {
            ((JDOMExternalizable)facet).readExternal(config2);
        }
        if ((externalSystemId = state.getExternalSystemId()) != null) {
            ((Facet)facet).setExternalSource(ExternalProjectSystemRegistry.getInstance().getSourceById(externalSystemId));
        }
        F f = facet;
        if (f == null) {
            FacetManagerImpl.$$$reportNull$$$0(5);
        }
        return f;
    }

    @Override
    public void noStateLoaded() {
        this.doLoadState(null);
    }

    @Override
    public void loadState(@NotNull FacetManagerState state) {
        if (state == null) {
            FacetManagerImpl.$$$reportNull$$$0(6);
        }
        this.doLoadState(state);
    }

    private void doLoadState(@Nullable FacetManagerState state) {
        FacetModelImpl model = new FacetModelImpl(this);
        FacetManagerState importedFacetsState = this.myExternalSourcesStorage.getLoadedState();
        this.addFacets(ContainerUtil.concat(state == null ? Collections.emptyList() : state.facets, importedFacetsState.facets), null, model);
        this.commit(model, false);
    }

    @Override
    @NotNull
    public FacetManagerState getState() {
        FacetManagerState facetManagerState = this.saveState(FacetManagerImpl.getImportedFacetPredicate(this.myModule.getProject()).negate());
        if (facetManagerState == null) {
            FacetManagerImpl.$$$reportNull$$$0(7);
        }
        return facetManagerState;
    }

    @NotNull
    static Predicate<Facet<?>> getImportedFacetPredicate(@NotNull Project project2) {
        if (project2 == null) {
            FacetManagerImpl.$$$reportNull$$$0(8);
        }
        if (ProjectUtilCore.isExternalStorageEnabled(project2)) {
            Predicate<Facet<?>> predicate = facet -> facet.getExternalSource() != null;
            if (predicate == null) {
                FacetManagerImpl.$$$reportNull$$$0(9);
            }
            return predicate;
        }
        Predicate<Facet<?>> predicate = facet -> false;
        if (predicate == null) {
            FacetManagerImpl.$$$reportNull$$$0(10);
        }
        return predicate;
    }

    @NotNull
    FacetManagerState saveState(Predicate<? super Facet<?>> filter2) {
        FacetManagerState managerState = new FacetManagerState();
        Facet<?>[] facets2 = this.getSortedFacets();
        HashMap states = new HashMap();
        states.put(null, managerState.facets);
        for (Facet<?> facet : facets2) {
            if (!filter2.test(facet)) continue;
            Facet underlyingFacet = facet.getUnderlyingFacet();
            FacetState facetState = FacetManagerImpl.saveFacetConfiguration(facet);
            if (facetState == null) continue;
            FacetManagerImpl.getOrCreateTargetFacetList(underlyingFacet, states, this.myModule.getProject()).add(facetState);
            states.put(facet, facetState.getSubFacets());
        }
        FacetManagerState facetManagerState = managerState;
        if (facetManagerState == null) {
            FacetManagerImpl.$$$reportNull$$$0(11);
        }
        return facetManagerState;
    }

    @ApiStatus.Internal
    @Nullable
    public static FacetState saveFacetConfiguration(Facet<?> facet) {
        FacetState facetState = FacetManagerImpl.createFacetState(facet, facet.getModule().getProject());
        if (!(facet instanceof InvalidFacet)) {
            Element config2 = FacetUtil.saveFacetConfiguration(facet);
            if (config2 == null) {
                return null;
            }
            facetState.setConfiguration(config2);
        }
        return facetState;
    }

    private static List<FacetState> getOrCreateTargetFacetList(Facet<?> underlyingFacet, Map<Facet<?>, List<FacetState>> states, @NotNull Project project2) {
        List facetStateList;
        if (project2 == null) {
            FacetManagerImpl.$$$reportNull$$$0(12);
        }
        if ((facetStateList = states.get(underlyingFacet)) == null) {
            FacetState state = FacetManagerImpl.createFacetState(underlyingFacet, project2);
            FacetManagerImpl.getOrCreateTargetFacetList(underlyingFacet.getUnderlyingFacet(), states, project2).add(state);
            facetStateList = state.getSubFacets();
            states.put(underlyingFacet, facetStateList);
        }
        return facetStateList;
    }

    private static FacetState createFacetState(@NotNull Facet<?> facet, @NotNull Project project2) {
        if (facet == null) {
            FacetManagerImpl.$$$reportNull$$$0(13);
        }
        if (project2 == null) {
            FacetManagerImpl.$$$reportNull$$$0(14);
        }
        if (facet instanceof InvalidFacet) {
            return ((InvalidFacetConfiguration)((InvalidFacet)facet).getConfiguration()).getFacetState();
        }
        FacetState facetState = new FacetState();
        ProjectModelExternalSource externalSource = facet.getExternalSource();
        if (externalSource != null && ProjectUtilCore.isExternalStorageEnabled(project2)) {
            facetState.setExternalSystemId(externalSource.getId());
        }
        facetState.setFacetType(facet.getType().getStringId());
        facetState.setName(facet.getName());
        return facetState;
    }

    public void commit(ModifiableFacetModel model) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.commit(model, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void commit(ModifiableFacetModel model, boolean fireEvents) {
        LOG.assertTrue(!this.myInsideCommit, "Recursive commit");
        Set<Facet<?>> toRemove2 = ContainerUtil.set(this.getAllFacets());
        ArrayList toAdd = new ArrayList();
        ArrayList<FacetRenameInfo> toRename = new ArrayList<FacetRenameInfo>();
        FacetManagerListener publisher = (FacetManagerListener)this.myModule.getMessageBus().syncPublisher(FACETS_TOPIC);
        try {
            void var9_29;
            this.myInsideCommit = true;
            Facet<?>[] facetArray = model.getAllFacets();
            int n = facetArray.length;
            boolean bl = false;
            while (var9_29 < n) {
                boolean isNew;
                Facet<?> facet = facetArray[var9_29];
                boolean bl2 = isNew = !toRemove2.remove(facet);
                if (isNew) {
                    toAdd.add(facet);
                }
                ++var9_29;
            }
            ArrayList newFacets = new ArrayList();
            for (Facet<?> facet : this.getAllFacets()) {
                if (toRemove2.contains(facet)) continue;
                newFacets.add(facet);
            }
            newFacets.addAll(toAdd);
            for (Facet facet : newFacets) {
                String newName = model.getNewName(facet);
                if (newName == null || newName.equals(facet.getName())) continue;
                toRename.add(new FacetRenameInfo(facet, facet.getName(), newName));
            }
            if (fireEvents) {
                for (Facet facet : toAdd) {
                    publisher.beforeFacetAdded(facet);
                }
                for (Facet<?> facet : toRemove2) {
                    publisher.beforeFacetRemoved(facet);
                }
                for (FacetRenameInfo facetRenameInfo : toRename) {
                    publisher.beforeFacetRenamed(facetRenameInfo.myFacet);
                }
            }
            for (FacetRenameInfo facetRenameInfo : toRename) {
                FacetManagerImpl.setFacetName(facetRenameInfo.myFacet, facetRenameInfo.myNewName);
            }
            this.myModel.setAllFacets(newFacets.toArray(Facet.EMPTY_ARRAY));
        }
        finally {
            this.myInsideCommit = false;
        }
        if (this.myModuleAdded) {
            for (Facet facet : toAdd) {
                facet.initFacet();
            }
        }
        for (Facet facet : toRemove2) {
            Disposer.dispose(facet);
        }
        if (fireEvents) {
            for (Facet facet : toAdd) {
                publisher.facetAdded(facet);
            }
            for (Facet facet : toRemove2) {
                publisher.facetRemoved(facet);
            }
            for (FacetRenameInfo facetRenameInfo : toRename) {
                publisher.facetRenamed(facetRenameInfo.myFacet, facetRenameInfo.myOldName);
            }
        }
        for (Facet facet : toAdd) {
            FacetType type;
            Module module2 = facet.getModule();
            if (!module2.equals(this.myModule)) {
                LOG.error(facet + " is created for module " + module2 + " but added to module " + this.myModule);
            }
            if (!(type = facet.getType()).isOnlyOneFacetAllowed()) continue;
            if (type.getUnderlyingFacetType() == null) {
                Collection facets2 = this.getFacetsByType(type.getId());
                if (facets2.size() <= 1) continue;
                LOG.error("Only one '" + type.getPresentableName() + "' facet per module allowed, but " + facets2.size() + " facets found in module '" + this.myModule.getName() + "'");
                continue;
            }
            Facet underlyingFacet = facet.getUnderlyingFacet();
            LOG.assertTrue(underlyingFacet != null, "Underlying facet is not specified for '" + facet.getName() + "'");
            Collection facets3 = this.getFacetsByType(underlyingFacet, type.getId());
            if (facets3.size() <= 1) continue;
            LOG.error("Only one '" + type.getPresentableName() + "' facet per parent facet allowed, but " + facets3.size() + " sub-facets found in facet " + underlyingFacet.getName());
        }
    }

    public static void setExternalSource(@NotNull Facet<?> facet, ProjectModelExternalSource externalSource) {
        if (facet == null) {
            FacetManagerImpl.$$$reportNull$$$0(15);
        }
        facet.setExternalSource(externalSource);
    }

    Set<ProjectModelExternalSource> getExternalSources() {
        return this.myModel.myExternalSources;
    }

    @Override
    public void moduleAdded() {
        if (this.myModuleAdded) {
            return;
        }
        for (Facet<?> facet : this.getAllFacets()) {
            facet.initFacet();
        }
        this.myModuleAdded = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/FacetManagerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/FacetManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createModifiableModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createFacetFromState";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportedFacetPredicate";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "saveState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFacetFromStateRaw";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getImportedFacetPredicate";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateTargetFacetList";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createFacetState";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setExternalSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FacetRenameInfo {
        private final Facet<?> myFacet;
        private final String myOldName;
        private final String myNewName;

        FacetRenameInfo(Facet<?> facet, String oldName, String newName) {
            this.myFacet = facet;
            this.myOldName = oldName;
            this.myNewName = newName;
        }
    }

    private static class FacetManagerModel
    extends FacetModelBase {
        private Facet<?>[] myAllFacets = Facet.EMPTY_ARRAY;
        private final Set<ProjectModelExternalSource> myExternalSources = new LinkedHashSet<ProjectModelExternalSource>();

        private FacetManagerModel() {
        }

        @Override
        public Facet<?> @NotNull [] getAllFacets() {
            if (this.myAllFacets == null) {
                FacetManagerModel.$$$reportNull$$$0(0);
            }
            return this.myAllFacets;
        }

        void setAllFacets(Facet<?>[] allFacets) {
            this.myExternalSources.clear();
            for (Facet<?> facet : allFacets) {
                ContainerUtil.addIfNotNull(this.myExternalSources, facet.getExternalSource());
            }
            this.myAllFacets = allFacets;
            this.facetsChanged();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/FacetManagerImpl$FacetManagerModel", "getAllFacets"));
        }
    }
}

