/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.frameworks;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.HttpRequests;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SettingsConnectionService {
    private static final Logger LOG = Logger.getInstance(SettingsConnectionService.class);
    protected static final String SERVICE_URL_ATTR_NAME = "url";
    private Map<String, String> myAttributesMap;
    @Nullable
    private final String mySettingsUrl;
    @Nullable
    private final String myDefaultServiceUrl;

    protected String @NotNull [] getAttributeNames() {
        String[] stringArray = new String[]{SERVICE_URL_ATTR_NAME};
        if (stringArray == null) {
            SettingsConnectionService.$$$reportNull$$$0(0);
        }
        return stringArray;
    }

    protected SettingsConnectionService(@Nullable String settingsUrl, @Nullable String defaultServiceUrl) {
        this.mySettingsUrl = settingsUrl;
        this.myDefaultServiceUrl = defaultServiceUrl;
    }

    @Nullable
    public String getDefaultServiceUrl() {
        return this.myDefaultServiceUrl;
    }

    @Nullable
    private Map<String, String> readSettings(String ... attributes) {
        if (this.mySettingsUrl == null) {
            return Collections.emptyMap();
        }
        return HttpRequests.request(this.mySettingsUrl).productNameAsUserAgent().connect(request2 -> {
            LinkedHashMap<String, String> settings = new LinkedHashMap<String, String>();
            try {
                Element root = JDOMUtil.load(request2.getReader());
                for (String s : attributes) {
                    String attributeValue = root.getAttributeValue(s);
                    if (!StringUtil.isNotEmpty(attributeValue)) continue;
                    settings.put(s, attributeValue);
                }
            }
            catch (JDOMException e) {
                LOG.info(e);
            }
            return settings;
        }, Collections.emptyMap(), LOG);
    }

    @Nullable
    public String getServiceUrl() {
        String serviceUrl = this.getSettingValue(SERVICE_URL_ATTR_NAME);
        return serviceUrl == null ? this.getDefaultServiceUrl() : serviceUrl;
    }

    @Nullable
    protected String getSettingValue(@NotNull String attributeValue) {
        if (attributeValue == null) {
            SettingsConnectionService.$$$reportNull$$$0(1);
        }
        if (this.myAttributesMap == null || this.myAttributesMap.isEmpty()) {
            this.myAttributesMap = this.readSettings(this.getAttributeNames());
        }
        return this.myAttributesMap != null ? this.myAttributesMap.get(attributeValue) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/frameworks/SettingsConnectionService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/frameworks/SettingsConnectionService";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSettingValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

