/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.frameworks.beans;

import com.intellij.facet.frameworks.beans.RequiredClass;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;

@Tag(value="item")
@ApiStatus.Internal
public class ArtifactItem {
    @Property(surroundWithTag=false)
    @XCollection
    public RequiredClass[] myRequiredClasses;
    @Attribute(value="name")
    public String myName;
    @Attribute(value="url")
    public String myUrl;
    @Attribute(value="srcUrl")
    public String mySourceUrl;
    @Attribute(value="docUrl")
    public String myDocUrl;
    @Attribute(value="md5")
    public String myMD5;
    @Attribute(value="optional")
    public boolean myOptional;

    public String getName() {
        return this.myName == null ? this.getNameFromUrl() : this.myName;
    }

    private String getNameFromUrl() {
        int index = this.myUrl.lastIndexOf(47);
        return index == -1 ? this.myUrl : this.myUrl.substring(index + 1);
    }

    public boolean isOptional() {
        return this.myOptional;
    }

    public String getSourceUrl() {
        return this.mySourceUrl;
    }

    public String getDocUrl() {
        return this.myDocUrl;
    }

    public String getUrl() {
        return this.myUrl;
    }

    public String getMD5() {
        return this.myMD5;
    }

    public String toString() {
        return this.myName;
    }

    public String[] getRequiredClasses() {
        if (this.myRequiredClasses == null) {
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        List<String> classes = ContainerUtil.mapNotNull(this.myRequiredClasses, requiredClass -> requiredClass.getFqn());
        return ArrayUtilRt.toStringArray(classes);
    }
}

