/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetModel;
import com.intellij.facet.FacetTypeId;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FacetModelBase
implements FacetModel {
    private volatile Map<FacetTypeId<?>, Collection<Facet<?>>> myType2Facets;
    private volatile Map<Pair<Facet<?>, FacetTypeId<?>>, Collection<Facet<?>>> myChildFacets;
    private volatile Facet<?>[] mySortedFacets;

    @Override
    public Facet<?> @NotNull [] getSortedFacets() {
        if (this.mySortedFacets == null) {
            Facet<?>[] allFacets = this.getAllFacets();
            if (allFacets.length == 0) {
                this.mySortedFacets = Facet.EMPTY_ARRAY;
            } else {
                LinkedHashSet facets2 = new LinkedHashSet();
                for (Facet<?> facet : allFacets) {
                    FacetModelBase.addUnderlyingFacets(facets2, facet);
                }
                this.mySortedFacets = facets2.toArray(Facet.EMPTY_ARRAY);
            }
        }
        if (this.mySortedFacets == null) {
            FacetModelBase.$$$reportNull$$$0(0);
        }
        return this.mySortedFacets;
    }

    private static void addUnderlyingFacets(LinkedHashSet<? super Facet<?>> facets2, Facet<?> facet) {
        Facet underlyingFacet = facet.getUnderlyingFacet();
        if (underlyingFacet != null && !facets2.contains(facet)) {
            FacetModelBase.addUnderlyingFacets(facets2, underlyingFacet);
        }
        facets2.add(facet);
    }

    @Override
    @NotNull
    public <F extends Facet<?>> Collection<F> getFacetsByType(@NotNull Facet<?> underlyingFacet, FacetTypeId<F> typeId) {
        Collection<Facet<?>> facets2;
        if (underlyingFacet == null) {
            FacetModelBase.$$$reportNull$$$0(1);
        }
        if (this.myChildFacets == null) {
            MultiValuesMap children2 = new MultiValuesMap();
            for (Facet<?> facet : this.getAllFacets()) {
                Facet underlying = facet.getUnderlyingFacet();
                if (underlying == null) continue;
                children2.put(new Pair<Facet, FacetTypeId>(underlying, facet.getTypeId()), facet);
            }
            HashMap childFacets = new HashMap();
            for (Pair pair : children2.keySet()) {
                Collection facets3 = children2.get(pair);
                childFacets.put(pair, Collections.unmodifiableCollection(facets3));
            }
            this.myChildFacets = childFacets;
        }
        Collection<Facet<Object>> collection = (facets2 = this.myChildFacets.get(new Pair(underlyingFacet, typeId))) != null ? facets2 : Collections.emptyList();
        if (collection == null) {
            FacetModelBase.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @Override
    @NotNull
    public String getFacetName(@NotNull Facet<?> facet) {
        if (facet == null) {
            FacetModelBase.$$$reportNull$$$0(3);
        }
        String string = facet.getName();
        if (string == null) {
            FacetModelBase.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @Nullable
    public <F extends Facet<?>> F findFacet(FacetTypeId<F> type, String name) {
        Collection<F> fs = this.getFacetsByType(type);
        for (Facet f : fs) {
            if (!f.getName().equals(name)) continue;
            return (F)f;
        }
        return null;
    }

    @Override
    @Nullable
    public <F extends Facet<?>> F getFacetByType(@NotNull Facet<?> underlyingFacet, FacetTypeId<F> typeId) {
        Collection<F> fs;
        if (underlyingFacet == null) {
            FacetModelBase.$$$reportNull$$$0(5);
        }
        return (F)((fs = this.getFacetsByType(underlyingFacet, typeId)).isEmpty() ? null : (Facet)fs.iterator().next());
    }

    @Override
    @Nullable
    public <F extends Facet<?>> F getFacetByType(FacetTypeId<F> typeId) {
        Collection<F> facets2 = this.getFacetsByType(typeId);
        return (F)(facets2.isEmpty() ? null : (Facet)facets2.iterator().next());
    }

    @Override
    @NotNull
    public <F extends Facet<?>> Collection<F> getFacetsByType(FacetTypeId<F> typeId) {
        Collection<Facet<?>> facets2;
        if (this.myType2Facets == null) {
            MultiValuesMap typeToFacets = new MultiValuesMap();
            for (Facet<?> facet : this.getAllFacets()) {
                typeToFacets.put(facet.getTypeId(), facet);
            }
            HashMap typeToFacetsCollection = new HashMap();
            for (FacetTypeId id2 : typeToFacets.keySet()) {
                Collection facets3 = typeToFacets.get(id2);
                typeToFacetsCollection.put(id2, Collections.unmodifiableCollection(facets3));
            }
            this.myType2Facets = typeToFacetsCollection;
        }
        Collection<Facet<Object>> collection = (facets2 = this.myType2Facets.get(typeId)) != null ? facets2 : Collections.emptyList();
        if (collection == null) {
            FacetModelBase.$$$reportNull$$$0(6);
        }
        return collection;
    }

    protected void facetsChanged() {
        this.myChildFacets = null;
        this.myType2Facets = null;
        this.mySortedFacets = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/impl/FacetModelBase";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "underlyingFacet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedFacets";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/impl/FacetModelBase";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetsByType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFacetsByType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFacetName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFacetByType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

